# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__COMPUTE_GCOR_METADATA = Metadata(
    id="5b49288dc45e60df83fcd651b8cdf3b983aa266d.boutiques",
    name="@compute_gcor",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VComputeGcorParameters = typing.TypedDict('VComputeGcorParameters', {
    "__STYXTYPE__": typing.Literal["@compute_gcor"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "corr_vol_prefix": typing.NotRequired[str | None],
    "initial_trs": typing.NotRequired[float | None],
    "no_demean": bool,
    "save_tmp": bool,
    "verbose": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@compute_gcor": v__compute_gcor_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@compute_gcor": v__compute_gcor_outputs,
    }.get(t)


class VComputeGcorOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__compute_gcor(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    corr_vol_brik: OutputPathType | None
    """Output correlation volume BRIK file"""
    corr_vol_head: OutputPathType | None
    """Output correlation volume HEAD file"""


def v__compute_gcor_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    corr_vol_prefix: str | None = None,
    initial_trs: float | None = None,
    no_demean: bool = False,
    save_tmp: bool = False,
    verbose: float | None = None,
) -> VComputeGcorParameters:
    """
    Build parameters.
    
    Args:
        input_: Specify input dataset to compute the GCOR over.
        mask: Specify mask dataset, for restricting the computation.
        corr_vol_prefix: Specify prefix for correlation volume output.
        initial_trs: Specify number of initial TRs to ignore.
        no_demean: Do not demean as the first step.
        save_tmp: Save temporary files (do not remove at end).
        verbose: Set verbose level (0=quiet, 3=max).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@compute_gcor",
        "input": input_,
        "no_demean": no_demean,
        "save_tmp": save_tmp,
    }
    if mask is not None:
        params["mask"] = mask
    if corr_vol_prefix is not None:
        params["corr_vol_prefix"] = corr_vol_prefix
    if initial_trs is not None:
        params["initial_trs"] = initial_trs
    if verbose is not None:
        params["verbose"] = verbose
    return params


def v__compute_gcor_cargs(
    params: VComputeGcorParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@compute_gcor")
    cargs.append(execution.input_file(params.get("input")))
    if params.get("mask") is not None:
        cargs.append(execution.input_file(params.get("mask")))
    if params.get("corr_vol_prefix") is not None:
        cargs.extend([
            "-corr_vol",
            params.get("corr_vol_prefix")
        ])
    if params.get("initial_trs") is not None:
        cargs.extend([
            "-nfirst",
            str(params.get("initial_trs"))
        ])
    if params.get("no_demean"):
        cargs.append("-no_demean")
    if params.get("save_tmp"):
        cargs.append("-savetmp")
    if params.get("verbose") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbose"))
        ])
    return cargs


def v__compute_gcor_outputs(
    params: VComputeGcorParameters,
    execution: Execution,
) -> VComputeGcorOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VComputeGcorOutputs(
        root=execution.output_file("."),
        corr_vol_brik=execution.output_file(params.get("corr_vol_prefix") + "+tlrc.BRIK") if (params.get("corr_vol_prefix") is not None) else None,
        corr_vol_head=execution.output_file(params.get("corr_vol_prefix") + "+tlrc.HEAD") if (params.get("corr_vol_prefix") is not None) else None,
    )
    return ret


def v__compute_gcor_execute(
    params: VComputeGcorParameters,
    execution: Execution,
) -> VComputeGcorOutputs:
    """
    Compute GCOR, the global correlation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VComputeGcorOutputs`).
    """
    params = execution.params(params)
    cargs = v__compute_gcor_cargs(params, execution)
    ret = v__compute_gcor_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__compute_gcor(
    input_: InputPathType,
    mask: InputPathType | None = None,
    corr_vol_prefix: str | None = None,
    initial_trs: float | None = None,
    no_demean: bool = False,
    save_tmp: bool = False,
    verbose: float | None = None,
    runner: Runner | None = None,
) -> VComputeGcorOutputs:
    """
    Compute GCOR, the global correlation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Specify input dataset to compute the GCOR over.
        mask: Specify mask dataset, for restricting the computation.
        corr_vol_prefix: Specify prefix for correlation volume output.
        initial_trs: Specify number of initial TRs to ignore.
        no_demean: Do not demean as the first step.
        save_tmp: Save temporary files (do not remove at end).
        verbose: Set verbose level (0=quiet, 3=max).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VComputeGcorOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__COMPUTE_GCOR_METADATA)
    params = v__compute_gcor_params(
        input_=input_,
        mask=mask,
        corr_vol_prefix=corr_vol_prefix,
        initial_trs=initial_trs,
        no_demean=no_demean,
        save_tmp=save_tmp,
        verbose=verbose,
    )
    return v__compute_gcor_execute(params, execution)


__all__ = [
    "VComputeGcorOutputs",
    "VComputeGcorParameters",
    "V__COMPUTE_GCOR_METADATA",
    "v__compute_gcor",
    "v__compute_gcor_params",
]
