# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DEBLANK_FILE_NAMES_METADATA = Metadata(
    id="5ee51800cef7163b87f314574ef99b6eec9f40f6.boutiques",
    name="@DeblankFileNames",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDeblankFileNamesParameters = typing.TypedDict('VDeblankFileNamesParameters', {
    "__STYXTYPE__": typing.Literal["@DeblankFileNames"],
    "move": bool,
    "nobrac": bool,
    "demo_set": bool,
    "echo": bool,
    "help": bool,
    "files": typing.NotRequired[list[InputPathType] | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@DeblankFileNames": v__deblank_file_names_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class VDeblankFileNamesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__deblank_file_names(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__deblank_file_names_params(
    move: bool = False,
    nobrac: bool = False,
    demo_set: bool = False,
    echo: bool = False,
    help_: bool = False,
    files: list[InputPathType] | None = None,
) -> VDeblankFileNamesParameters:
    """
    Build parameters.
    
    Args:
        move: Actually rename the files (opposite of -dry_run).
        nobrac: Do not replace () and [] in filenames, just spaces.
        demo_set: Create a toy directory with bad names for testing.
        echo: Turn on script echo.
        help_: Display help message.
        files: Specify files to fix as opposed to letting it fix all the names\
            in the current directory.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@DeblankFileNames",
        "move": move,
        "nobrac": nobrac,
        "demo_set": demo_set,
        "echo": echo,
        "help": help_,
    }
    if files is not None:
        params["files"] = files
    return params


def v__deblank_file_names_cargs(
    params: VDeblankFileNamesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@DeblankFileNames")
    if params.get("move"):
        cargs.append("-move")
    if params.get("nobrac"):
        cargs.append("-nobrac")
    if params.get("demo_set"):
        cargs.append("-demo_set")
    if params.get("echo"):
        cargs.append("-echo")
    if params.get("help"):
        cargs.append("-help")
    if params.get("files") is not None:
        cargs.extend([execution.input_file(f) for f in params.get("files")])
    return cargs


def v__deblank_file_names_outputs(
    params: VDeblankFileNamesParameters,
    execution: Execution,
) -> VDeblankFileNamesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDeblankFileNamesOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__deblank_file_names_execute(
    params: VDeblankFileNamesParameters,
    execution: Execution,
) -> VDeblankFileNamesOutputs:
    """
    A script to remove blanks and other annoying characters ([], ()) from filenames.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VDeblankFileNamesOutputs`).
    """
    params = execution.params(params)
    cargs = v__deblank_file_names_cargs(params, execution)
    ret = v__deblank_file_names_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__deblank_file_names(
    move: bool = False,
    nobrac: bool = False,
    demo_set: bool = False,
    echo: bool = False,
    help_: bool = False,
    files: list[InputPathType] | None = None,
    runner: Runner | None = None,
) -> VDeblankFileNamesOutputs:
    """
    A script to remove blanks and other annoying characters ([], ()) from filenames.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        move: Actually rename the files (opposite of -dry_run).
        nobrac: Do not replace () and [] in filenames, just spaces.
        demo_set: Create a toy directory with bad names for testing.
        echo: Turn on script echo.
        help_: Display help message.
        files: Specify files to fix as opposed to letting it fix all the names\
            in the current directory.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDeblankFileNamesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DEBLANK_FILE_NAMES_METADATA)
    params = v__deblank_file_names_params(
        move=move,
        nobrac=nobrac,
        demo_set=demo_set,
        echo=echo,
        help_=help_,
        files=files,
    )
    return v__deblank_file_names_execute(params, execution)


__all__ = [
    "VDeblankFileNamesOutputs",
    "VDeblankFileNamesParameters",
    "V__DEBLANK_FILE_NAMES_METADATA",
    "v__deblank_file_names",
    "v__deblank_file_names_params",
]
