# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DIFF_TREE_METADATA = Metadata(
    id="c1b88ca0b49c6f0c6d5e49fb3192c34dfd29e2ba.boutiques",
    name="@diff.tree",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDiffTreeParameters = typing.TypedDict('VDiffTreeParameters', {
    "__STYXTYPE__": typing.Literal["@diff.tree"],
    "new_dir": str,
    "old_dir": str,
    "diff_opts": typing.NotRequired[str | None],
    "ignore_append": typing.NotRequired[str | None],
    "ia": typing.NotRequired[str | None],
    "ignore_list": typing.NotRequired[str | None],
    "il": typing.NotRequired[str | None],
    "ignore_missing": bool,
    "no_diffs": bool,
    "quiet": bool,
    "save": bool,
    "show": bool,
    "show_list_comp": bool,
    "skip_data": bool,
    "verb": typing.NotRequired[str | None],
    "diff_prog": typing.NotRequired[str | None],
    "xxdiff": bool,
    "X_option": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@diff.tree": v__diff_tree_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class VDiffTreeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__diff_tree(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__diff_tree_params(
    new_dir: str,
    old_dir: str,
    diff_opts: str | None = None,
    ignore_append: str | None = None,
    ia: str | None = None,
    ignore_list: str | None = None,
    il: str | None = None,
    ignore_missing: bool = False,
    no_diffs: bool = False,
    quiet: bool = False,
    save: bool = False,
    show: bool = False,
    show_list_comp: bool = False,
    skip_data: bool = False,
    verb: str | None = None,
    diff_prog: str | None = None,
    xxdiff: bool = False,
    x_option: bool = False,
) -> VDiffTreeParameters:
    """
    Build parameters.
    
    Args:
        new_dir: New directory to compare.
        old_dir: Old directory to compare.
        diff_opts: Apply OPTS as options in diff commands.
        ignore_append: Append to ignore_list (list in quotes).
        ia: Short for -ignore_append.
        ignore_list: Create new ignore_list (list in quotes).
        il: Short for -ignore_list.
        ignore_missing: Only compare overlapping files, if different files,\
            fail.
        no_diffs: Only compare existence of files.
        quiet: Only list files with diffs.
        save: Save actual file differences (txt and pdf).
        show: Show actual file differences.
        show_list_comp: Show any pairwise differences in file lists (terminate\
            after showing comparison).
        skip_data: Skip binary diff of select data files (.BRIK, .dcm,\
            .BRIK.gz).
        verb: Set verbosity level (0,1,2) (default 1).
        diff_prog: Use PROG to show diffs (e.g. xxdiff, meld).
        xxdiff: Use xxdiff to show diffs.
        x_option: Implies -xxdiff -ignore_missing.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@diff.tree",
        "new_dir": new_dir,
        "old_dir": old_dir,
        "ignore_missing": ignore_missing,
        "no_diffs": no_diffs,
        "quiet": quiet,
        "save": save,
        "show": show,
        "show_list_comp": show_list_comp,
        "skip_data": skip_data,
        "xxdiff": xxdiff,
        "X_option": x_option,
    }
    if diff_opts is not None:
        params["diff_opts"] = diff_opts
    if ignore_append is not None:
        params["ignore_append"] = ignore_append
    if ia is not None:
        params["ia"] = ia
    if ignore_list is not None:
        params["ignore_list"] = ignore_list
    if il is not None:
        params["il"] = il
    if verb is not None:
        params["verb"] = verb
    if diff_prog is not None:
        params["diff_prog"] = diff_prog
    return params


def v__diff_tree_cargs(
    params: VDiffTreeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@diff.tree")
    cargs.append(params.get("new_dir"))
    cargs.append(params.get("old_dir"))
    if params.get("diff_opts") is not None:
        cargs.extend([
            "-diff_opts",
            params.get("diff_opts")
        ])
    if params.get("ignore_append") is not None:
        cargs.extend([
            "-ignore_append",
            params.get("ignore_append")
        ])
    if params.get("ia") is not None:
        cargs.extend([
            "-ia",
            params.get("ia")
        ])
    if params.get("ignore_list") is not None:
        cargs.extend([
            "-ignore_list",
            params.get("ignore_list")
        ])
    if params.get("il") is not None:
        cargs.extend([
            "-il",
            params.get("il")
        ])
    if params.get("ignore_missing"):
        cargs.append("-ignore_missing")
    if params.get("no_diffs"):
        cargs.append("-no_diffs")
    if params.get("quiet"):
        cargs.append("-quiet")
    if params.get("save"):
        cargs.append("-save")
    if params.get("show"):
        cargs.append("-show")
    if params.get("show_list_comp"):
        cargs.append("-show_list_comp")
    if params.get("skip_data"):
        cargs.append("-skip_data")
    if params.get("verb") is not None:
        cargs.extend([
            "-verb",
            params.get("verb")
        ])
    if params.get("diff_prog") is not None:
        cargs.extend([
            "-diff_prog",
            params.get("diff_prog")
        ])
    if params.get("xxdiff"):
        cargs.append("-xxdiff")
    if params.get("X_option"):
        cargs.append("-X")
    return cargs


def v__diff_tree_outputs(
    params: VDiffTreeParameters,
    execution: Execution,
) -> VDiffTreeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDiffTreeOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__diff_tree_execute(
    params: VDiffTreeParameters,
    execution: Execution,
) -> VDiffTreeOutputs:
    """
    Show file differences between 2 directories.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VDiffTreeOutputs`).
    """
    params = execution.params(params)
    cargs = v__diff_tree_cargs(params, execution)
    ret = v__diff_tree_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__diff_tree(
    new_dir: str,
    old_dir: str,
    diff_opts: str | None = None,
    ignore_append: str | None = None,
    ia: str | None = None,
    ignore_list: str | None = None,
    il: str | None = None,
    ignore_missing: bool = False,
    no_diffs: bool = False,
    quiet: bool = False,
    save: bool = False,
    show: bool = False,
    show_list_comp: bool = False,
    skip_data: bool = False,
    verb: str | None = None,
    diff_prog: str | None = None,
    xxdiff: bool = False,
    x_option: bool = False,
    runner: Runner | None = None,
) -> VDiffTreeOutputs:
    """
    Show file differences between 2 directories.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        new_dir: New directory to compare.
        old_dir: Old directory to compare.
        diff_opts: Apply OPTS as options in diff commands.
        ignore_append: Append to ignore_list (list in quotes).
        ia: Short for -ignore_append.
        ignore_list: Create new ignore_list (list in quotes).
        il: Short for -ignore_list.
        ignore_missing: Only compare overlapping files, if different files,\
            fail.
        no_diffs: Only compare existence of files.
        quiet: Only list files with diffs.
        save: Save actual file differences (txt and pdf).
        show: Show actual file differences.
        show_list_comp: Show any pairwise differences in file lists (terminate\
            after showing comparison).
        skip_data: Skip binary diff of select data files (.BRIK, .dcm,\
            .BRIK.gz).
        verb: Set verbosity level (0,1,2) (default 1).
        diff_prog: Use PROG to show diffs (e.g. xxdiff, meld).
        xxdiff: Use xxdiff to show diffs.
        x_option: Implies -xxdiff -ignore_missing.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDiffTreeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DIFF_TREE_METADATA)
    params = v__diff_tree_params(
        new_dir=new_dir,
        old_dir=old_dir,
        diff_opts=diff_opts,
        ignore_append=ignore_append,
        ia=ia,
        ignore_list=ignore_list,
        il=il,
        ignore_missing=ignore_missing,
        no_diffs=no_diffs,
        quiet=quiet,
        save=save,
        show=show,
        show_list_comp=show_list_comp,
        skip_data=skip_data,
        verb=verb,
        diff_prog=diff_prog,
        xxdiff=xxdiff,
        x_option=x_option,
    )
    return v__diff_tree_execute(params, execution)


__all__ = [
    "VDiffTreeOutputs",
    "VDiffTreeParameters",
    "V__DIFF_TREE_METADATA",
    "v__diff_tree",
    "v__diff_tree_params",
]
