# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__EXTRACT_MEICA_ORTVEC_METADATA = Metadata(
    id="af2a42cd65df6cf5f7af9bf797cce1dbd022d517.boutiques",
    name="@extract_meica_ortvec",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VExtractMeicaOrtvecParameters = typing.TypedDict('VExtractMeicaOrtvecParameters', {
    "__STYXTYPE__": typing.Literal["@extract_meica_ortvec"],
    "prefix": str,
    "meica_dir": typing.NotRequired[str | None],
    "reject_ignored": typing.NotRequired[int | None],
    "reject_midk": typing.NotRequired[int | None],
    "work_dir": typing.NotRequired[str | None],
    "verbosity": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@extract_meica_ortvec": v__extract_meica_ortvec_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@extract_meica_ortvec": v__extract_meica_ortvec_outputs,
    }.get(t)


class VExtractMeicaOrtvecOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__extract_meica_ortvec(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output 1D ortvec file"""


def v__extract_meica_ortvec_params(
    prefix: str,
    meica_dir: str | None = None,
    reject_ignored: int | None = None,
    reject_midk: int | None = None,
    work_dir: str | None = None,
    verbosity: str | None = None,
) -> VExtractMeicaOrtvecParameters:
    """
    Build parameters.
    
    Args:
        prefix: Name for output 1D ortvec file.
        meica_dir: Directory for MEICA files.
        reject_ignored: Do we reject ignored components (0=keep, 1=reject),\
            default is 0.
        reject_midk: Do we reject midk components (0=keep, 1=reject), default\
            is 1.
        work_dir: Sub-directory for work.
        verbosity: Set verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@extract_meica_ortvec",
        "prefix": prefix,
    }
    if meica_dir is not None:
        params["meica_dir"] = meica_dir
    if reject_ignored is not None:
        params["reject_ignored"] = reject_ignored
    if reject_midk is not None:
        params["reject_midk"] = reject_midk
    if work_dir is not None:
        params["work_dir"] = work_dir
    if verbosity is not None:
        params["verbosity"] = verbosity
    return params


def v__extract_meica_ortvec_cargs(
    params: VExtractMeicaOrtvecParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@extract_meica_ortvec")
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("meica_dir") is not None:
        cargs.extend([
            "-meica_dir",
            params.get("meica_dir")
        ])
    if params.get("reject_ignored") is not None:
        cargs.extend([
            "-reject_ignored",
            str(params.get("reject_ignored"))
        ])
    if params.get("reject_midk") is not None:
        cargs.extend([
            "-reject_midk",
            str(params.get("reject_midk"))
        ])
    if params.get("work_dir") is not None:
        cargs.extend([
            "-work_dir",
            params.get("work_dir")
        ])
    if params.get("verbosity") is not None:
        cargs.extend([
            "-verb",
            params.get("verbosity")
        ])
    return cargs


def v__extract_meica_ortvec_outputs(
    params: VExtractMeicaOrtvecParameters,
    execution: Execution,
) -> VExtractMeicaOrtvecOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VExtractMeicaOrtvecOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("prefix") + ".1D"),
    )
    return ret


def v__extract_meica_ortvec_execute(
    params: VExtractMeicaOrtvecParameters,
    execution: Execution,
) -> VExtractMeicaOrtvecOutputs:
    """
    Project good MEICA components out of bad ones.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VExtractMeicaOrtvecOutputs`).
    """
    params = execution.params(params)
    cargs = v__extract_meica_ortvec_cargs(params, execution)
    ret = v__extract_meica_ortvec_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__extract_meica_ortvec(
    prefix: str,
    meica_dir: str | None = None,
    reject_ignored: int | None = None,
    reject_midk: int | None = None,
    work_dir: str | None = None,
    verbosity: str | None = None,
    runner: Runner | None = None,
) -> VExtractMeicaOrtvecOutputs:
    """
    Project good MEICA components out of bad ones.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Name for output 1D ortvec file.
        meica_dir: Directory for MEICA files.
        reject_ignored: Do we reject ignored components (0=keep, 1=reject),\
            default is 0.
        reject_midk: Do we reject midk components (0=keep, 1=reject), default\
            is 1.
        work_dir: Sub-directory for work.
        verbosity: Set verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VExtractMeicaOrtvecOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__EXTRACT_MEICA_ORTVEC_METADATA)
    params = v__extract_meica_ortvec_params(
        prefix=prefix,
        meica_dir=meica_dir,
        reject_ignored=reject_ignored,
        reject_midk=reject_midk,
        work_dir=work_dir,
        verbosity=verbosity,
    )
    return v__extract_meica_ortvec_execute(params, execution)


__all__ = [
    "VExtractMeicaOrtvecOutputs",
    "VExtractMeicaOrtvecParameters",
    "V__EXTRACT_MEICA_ORTVEC_METADATA",
    "v__extract_meica_ortvec",
    "v__extract_meica_ortvec_params",
]
