# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_ID_METADATA = Metadata(
    id="bf0b6ddb2e06fa70fd2d0608f37cdc065cc8bf73.boutiques",
    name="@GetAfniID",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniIdParameters = typing.TypedDict('VGetAfniIdParameters', {
    "__STYXTYPE__": typing.Literal["@GetAfniID"],
    "dset": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@GetAfniID": v__get_afni_id_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@GetAfniID": v__get_afni_id_outputs,
    }.get(t)


class VGetAfniIdOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__get_afni_id(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    unique_id: OutputPathType
    """Unique identifier of the dataset"""


def v__get_afni_id_params(
    dset: InputPathType,
) -> VGetAfniIdParameters:
    """
    Build parameters.
    
    Args:
        dset: Dataset for which the unique identifier is to be returned.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@GetAfniID",
        "dset": dset,
    }
    return params


def v__get_afni_id_cargs(
    params: VGetAfniIdParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniID")
    cargs.append(execution.input_file(params.get("dset")))
    return cargs


def v__get_afni_id_outputs(
    params: VGetAfniIdParameters,
    execution: Execution,
) -> VGetAfniIdOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniIdOutputs(
        root=execution.output_file("."),
        unique_id=execution.output_file("stdout"),
    )
    return ret


def v__get_afni_id_execute(
    params: VGetAfniIdParameters,
    execution: Execution,
) -> VGetAfniIdOutputs:
    """
    Returns the unique identifier of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VGetAfniIdOutputs`).
    """
    params = execution.params(params)
    cargs = v__get_afni_id_cargs(params, execution)
    ret = v__get_afni_id_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_id(
    dset: InputPathType,
    runner: Runner | None = None,
) -> VGetAfniIdOutputs:
    """
    Returns the unique identifier of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: Dataset for which the unique identifier is to be returned.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniIdOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_ID_METADATA)
    params = v__get_afni_id_params(
        dset=dset,
    )
    return v__get_afni_id_execute(params, execution)


__all__ = [
    "VGetAfniIdOutputs",
    "VGetAfniIdParameters",
    "V__GET_AFNI_ID_METADATA",
    "v__get_afni_id",
    "v__get_afni_id_params",
]
