# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_ORIENT_METADATA = Metadata(
    id="c762859f5f7c452b51a781a2d7fabbb5993939a9.boutiques",
    name="@GetAfniOrient",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniOrientParameters = typing.TypedDict('VGetAfniOrientParameters', {
    "__STYXTYPE__": typing.Literal["@GetAfniOrient"],
    "exploratory": bool,
    "infile": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@GetAfniOrient": v__get_afni_orient_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@GetAfniOrient": v__get_afni_orient_outputs,
    }.get(t)


class VGetAfniOrientOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__get_afni_orient(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_orient_code: OutputPathType
    """File containing the orientation code"""


def v__get_afni_orient_params(
    infile: InputPathType,
    exploratory: bool = False,
) -> VGetAfniOrientParameters:
    """
    Build parameters.
    
    Args:
        infile: Input AFNI dataset (e.g. Hello+orig.HEAD).
        exploratory: Exploratory flag for additional functionalities.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@GetAfniOrient",
        "exploratory": exploratory,
        "infile": infile,
    }
    return params


def v__get_afni_orient_cargs(
    params: VGetAfniOrientParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniOrient")
    if params.get("exploratory"):
        cargs.append("-exp")
    cargs.append(execution.input_file(params.get("infile")))
    return cargs


def v__get_afni_orient_outputs(
    params: VGetAfniOrientParameters,
    execution: Execution,
) -> VGetAfniOrientOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniOrientOutputs(
        root=execution.output_file("."),
        output_orient_code=execution.output_file(pathlib.Path(params.get("infile")).name + "_orient_code.txt"),
    )
    return ret


def v__get_afni_orient_execute(
    params: VGetAfniOrientParameters,
    execution: Execution,
) -> VGetAfniOrientOutputs:
    """
    Returns the orient code of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VGetAfniOrientOutputs`).
    """
    params = execution.params(params)
    cargs = v__get_afni_orient_cargs(params, execution)
    ret = v__get_afni_orient_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_orient(
    infile: InputPathType,
    exploratory: bool = False,
    runner: Runner | None = None,
) -> VGetAfniOrientOutputs:
    """
    Returns the orient code of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input AFNI dataset (e.g. Hello+orig.HEAD).
        exploratory: Exploratory flag for additional functionalities.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniOrientOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_ORIENT_METADATA)
    params = v__get_afni_orient_params(
        exploratory=exploratory,
        infile=infile,
    )
    return v__get_afni_orient_execute(params, execution)


__all__ = [
    "VGetAfniOrientOutputs",
    "VGetAfniOrientParameters",
    "V__GET_AFNI_ORIENT_METADATA",
    "v__get_afni_orient",
    "v__get_afni_orient_params",
]
