# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_VIEW_METADATA = Metadata(
    id="697dd7318bcca131bdbfbdb54166fd3accb9e01b.boutiques",
    name="@GetAfniView",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniViewParameters = typing.TypedDict('VGetAfniViewParameters', {
    "__STYXTYPE__": typing.Literal["@GetAfniView"],
    "dataset_name": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@GetAfniView": v__get_afni_view_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@GetAfniView": v__get_afni_view_outputs,
    }.get(t)


class VGetAfniViewOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__get_afni_view(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    afni_view: OutputPathType
    """The AFNI view extension retrieved from the dataset name"""


def v__get_afni_view_params(
    dataset_name: str,
) -> VGetAfniViewParameters:
    """
    Build parameters.
    
    Args:
        dataset_name: Name of the dataset (including path) from which to\
            retrieve the AFNI view (+orig, +acpc, etc.).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@GetAfniView",
        "dataset_name": dataset_name,
    }
    return params


def v__get_afni_view_cargs(
    params: VGetAfniViewParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniView")
    cargs.append(params.get("dataset_name"))
    return cargs


def v__get_afni_view_outputs(
    params: VGetAfniViewParameters,
    execution: Execution,
) -> VGetAfniViewOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniViewOutputs(
        root=execution.output_file("."),
        afni_view=execution.output_file("view_extension.txt"),
    )
    return ret


def v__get_afni_view_execute(
    params: VGetAfniViewParameters,
    execution: Execution,
) -> VGetAfniViewOutputs:
    """
    A tool to retrieve the AFNI view of a given dataset name.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VGetAfniViewOutputs`).
    """
    params = execution.params(params)
    cargs = v__get_afni_view_cargs(params, execution)
    ret = v__get_afni_view_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_view(
    dataset_name: str,
    runner: Runner | None = None,
) -> VGetAfniViewOutputs:
    """
    A tool to retrieve the AFNI view of a given dataset name.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset_name: Name of the dataset (including path) from which to\
            retrieve the AFNI view (+orig, +acpc, etc.).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniViewOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_VIEW_METADATA)
    params = v__get_afni_view_params(
        dataset_name=dataset_name,
    )
    return v__get_afni_view_execute(params, execution)


__all__ = [
    "VGetAfniViewOutputs",
    "VGetAfniViewParameters",
    "V__GET_AFNI_VIEW_METADATA",
    "v__get_afni_view",
    "v__get_afni_view_params",
]
