# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GRAD_FLIP_TEST_METADATA = Metadata(
    id="f4c7bc4f70165e7a5d15e00cfa90501d609d65ee.boutiques",
    name="@GradFlipTest",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGradFlipTestParameters = typing.TypedDict('VGradFlipTestParameters', {
    "__STYXTYPE__": typing.Literal["@GradFlipTest"],
    "dwi": InputPathType,
    "grad_row_vec": typing.NotRequired[InputPathType | None],
    "grad_col_vec": typing.NotRequired[InputPathType | None],
    "grad_col_matA": typing.NotRequired[InputPathType | None],
    "grad_col_matT": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "bvals": typing.NotRequired[InputPathType | None],
    "thresh_fa": typing.NotRequired[float | None],
    "thresh_len": typing.NotRequired[float | None],
    "prefix": typing.NotRequired[str | None],
    "check_abs_min": typing.NotRequired[float | None],
    "scale_out_1000": bool,
    "wdir": typing.NotRequired[str | None],
    "do_clean": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@GradFlipTest": v__grad_flip_test_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@GradFlipTest": v__grad_flip_test_outputs,
    }.get(t)


class VGradFlipTestOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__grad_flip_test(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Text file that stores recommended flip option"""
    temp_directory: OutputPathType
    """Temporary working directory to store intermediate files"""


def v__grad_flip_test_params(
    dwi: InputPathType,
    grad_row_vec: InputPathType | None = None,
    grad_col_vec: InputPathType | None = None,
    grad_col_mat_a: InputPathType | None = None,
    grad_col_mat_t: InputPathType | None = None,
    mask: InputPathType | None = None,
    bvals: InputPathType | None = None,
    thresh_fa: float | None = None,
    thresh_len: float | None = None,
    prefix: str | None = None,
    check_abs_min: float | None = None,
    scale_out_1000: bool = False,
    wdir: str | None = None,
    do_clean: bool = False,
) -> VGradFlipTestParameters:
    """
    Build parameters.
    
    Args:
        dwi: Set of DWIs (N total volumes).
        grad_row_vec: Set of row-wise gradient vectors.
        grad_col_vec: Set of column-wise gradient vectors.
        grad_col_mat_a: Set of column-wise g- or b-matrix elements\
            ("AFNI"-style format, "diagonal-first").
        grad_col_mat_t: Set of column-wise g- or b-matrix elements\
            ("TORTOISE"-style format, "row-first").
        mask: Optional mask (probably whole brain); otherwise, automasking is\
            performed.
        bvals: Can input bvals, if necessary (but shouldn't be necessary?).
        thresh_fa: Set minimum FA value for tracking (default X=0.2).
        thresh_len: Set minimum tract length to keep a tract when propagating\
            (default L=30mm).
        prefix: Output name of text file that stores recommended flip option.
        check_abs_min: Handle tiny negative values in gradient vectors.
        scale_out_1000: Scale output to 1000, as in 3dDWItoDT (probably not\
            necessary).
        wdir: Rename working directory output; useful if running multiple\
            iterations.
        do_clean: Remove temporary directory.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@GradFlipTest",
        "dwi": dwi,
        "scale_out_1000": scale_out_1000,
        "do_clean": do_clean,
    }
    if grad_row_vec is not None:
        params["grad_row_vec"] = grad_row_vec
    if grad_col_vec is not None:
        params["grad_col_vec"] = grad_col_vec
    if grad_col_mat_a is not None:
        params["grad_col_matA"] = grad_col_mat_a
    if grad_col_mat_t is not None:
        params["grad_col_matT"] = grad_col_mat_t
    if mask is not None:
        params["mask"] = mask
    if bvals is not None:
        params["bvals"] = bvals
    if thresh_fa is not None:
        params["thresh_fa"] = thresh_fa
    if thresh_len is not None:
        params["thresh_len"] = thresh_len
    if prefix is not None:
        params["prefix"] = prefix
    if check_abs_min is not None:
        params["check_abs_min"] = check_abs_min
    if wdir is not None:
        params["wdir"] = wdir
    return params


def v__grad_flip_test_cargs(
    params: VGradFlipTestParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GradFlipTest")
    cargs.extend([
        "-in_dwi",
        execution.input_file(params.get("dwi"))
    ])
    if params.get("grad_row_vec") is not None:
        cargs.extend([
            "-in_row_vec",
            execution.input_file(params.get("grad_row_vec"))
        ])
    if params.get("grad_col_vec") is not None:
        cargs.extend([
            "-in_col_vec",
            execution.input_file(params.get("grad_col_vec"))
        ])
    if params.get("grad_col_matA") is not None:
        cargs.extend([
            "-in_col_matA",
            execution.input_file(params.get("grad_col_matA"))
        ])
    if params.get("grad_col_matT") is not None:
        cargs.extend([
            "-in_col_matT",
            execution.input_file(params.get("grad_col_matT"))
        ])
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("bvals") is not None:
        cargs.extend([
            "-in_bvals",
            execution.input_file(params.get("bvals"))
        ])
    if params.get("thresh_fa") is not None:
        cargs.extend([
            "-alg_Thresh_FA",
            str(params.get("thresh_fa"))
        ])
    if params.get("thresh_len") is not None:
        cargs.extend([
            "-alg_Thresh_Len",
            str(params.get("thresh_len"))
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("check_abs_min") is not None:
        cargs.extend([
            "-check_abs_min",
            str(params.get("check_abs_min"))
        ])
    if params.get("scale_out_1000"):
        cargs.append("-scale_out_1000")
    if params.get("wdir") is not None:
        cargs.extend([
            "-wdir",
            params.get("wdir")
        ])
    if params.get("do_clean"):
        cargs.append("-do_clean")
    return cargs


def v__grad_flip_test_outputs(
    params: VGradFlipTestParameters,
    execution: Execution,
) -> VGradFlipTestOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGradFlipTestOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix") + ".txt") if (params.get("prefix") is not None) else None,
        temp_directory=execution.output_file("_tmp_TESTFLIP"),
    )
    return ret


def v__grad_flip_test_execute(
    params: VGradFlipTestParameters,
    execution: Execution,
) -> VGradFlipTestOutputs:
    """
    Script to test the correct flip for a data set when using 1dDW_Grad_o_Mat++.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VGradFlipTestOutputs`).
    """
    params = execution.params(params)
    cargs = v__grad_flip_test_cargs(params, execution)
    ret = v__grad_flip_test_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__grad_flip_test(
    dwi: InputPathType,
    grad_row_vec: InputPathType | None = None,
    grad_col_vec: InputPathType | None = None,
    grad_col_mat_a: InputPathType | None = None,
    grad_col_mat_t: InputPathType | None = None,
    mask: InputPathType | None = None,
    bvals: InputPathType | None = None,
    thresh_fa: float | None = None,
    thresh_len: float | None = None,
    prefix: str | None = None,
    check_abs_min: float | None = None,
    scale_out_1000: bool = False,
    wdir: str | None = None,
    do_clean: bool = False,
    runner: Runner | None = None,
) -> VGradFlipTestOutputs:
    """
    Script to test the correct flip for a data set when using 1dDW_Grad_o_Mat++.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dwi: Set of DWIs (N total volumes).
        grad_row_vec: Set of row-wise gradient vectors.
        grad_col_vec: Set of column-wise gradient vectors.
        grad_col_mat_a: Set of column-wise g- or b-matrix elements\
            ("AFNI"-style format, "diagonal-first").
        grad_col_mat_t: Set of column-wise g- or b-matrix elements\
            ("TORTOISE"-style format, "row-first").
        mask: Optional mask (probably whole brain); otherwise, automasking is\
            performed.
        bvals: Can input bvals, if necessary (but shouldn't be necessary?).
        thresh_fa: Set minimum FA value for tracking (default X=0.2).
        thresh_len: Set minimum tract length to keep a tract when propagating\
            (default L=30mm).
        prefix: Output name of text file that stores recommended flip option.
        check_abs_min: Handle tiny negative values in gradient vectors.
        scale_out_1000: Scale output to 1000, as in 3dDWItoDT (probably not\
            necessary).
        wdir: Rename working directory output; useful if running multiple\
            iterations.
        do_clean: Remove temporary directory.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGradFlipTestOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GRAD_FLIP_TEST_METADATA)
    params = v__grad_flip_test_params(
        dwi=dwi,
        grad_row_vec=grad_row_vec,
        grad_col_vec=grad_col_vec,
        grad_col_mat_a=grad_col_mat_a,
        grad_col_mat_t=grad_col_mat_t,
        mask=mask,
        bvals=bvals,
        thresh_fa=thresh_fa,
        thresh_len=thresh_len,
        prefix=prefix,
        check_abs_min=check_abs_min,
        scale_out_1000=scale_out_1000,
        wdir=wdir,
        do_clean=do_clean,
    )
    return v__grad_flip_test_execute(params, execution)


__all__ = [
    "VGradFlipTestOutputs",
    "VGradFlipTestParameters",
    "V__GRAD_FLIP_TEST_METADATA",
    "v__grad_flip_test",
    "v__grad_flip_test_params",
]
