# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__IS_OBLIQUE_METADATA = Metadata(
    id="26f04b5daa7f9df4c6266d840714d074632c8670.boutiques",
    name="@isOblique",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VIsObliqueParameters = typing.TypedDict('VIsObliqueParameters', {
    "__STYXTYPE__": typing.Literal["@isOblique"],
    "infile": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@isOblique": v__is_oblique_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@isOblique": v__is_oblique_outputs,
    }.get(t)


class VIsObliqueOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__is_oblique(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    result: OutputPathType
    """Output result indicating if the file is oblique or plumb"""


def v__is_oblique_params(
    infile: InputPathType,
) -> VIsObliqueParameters:
    """
    Build parameters.
    
    Args:
        infile: Input file (e.g., Hello+orig.HEAD).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@isOblique",
        "infile": infile,
    }
    return params


def v__is_oblique_cargs(
    params: VIsObliqueParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@isOblique")
    cargs.append(execution.input_file(params.get("infile")))
    return cargs


def v__is_oblique_outputs(
    params: VIsObliqueParameters,
    execution: Execution,
) -> VIsObliqueOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VIsObliqueOutputs(
        root=execution.output_file("."),
        result=execution.output_file("oblique_check_result.txt"),
    )
    return ret


def v__is_oblique_execute(
    params: VIsObliqueParameters,
    execution: Execution,
) -> VIsObliqueOutputs:
    """
    Determine if a file is oblique or plumb.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VIsObliqueOutputs`).
    """
    params = execution.params(params)
    cargs = v__is_oblique_cargs(params, execution)
    ret = v__is_oblique_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__is_oblique(
    infile: InputPathType,
    runner: Runner | None = None,
) -> VIsObliqueOutputs:
    """
    Determine if a file is oblique or plumb.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file (e.g., Hello+orig.HEAD).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VIsObliqueOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__IS_OBLIQUE_METADATA)
    params = v__is_oblique_params(
        infile=infile,
    )
    return v__is_oblique_execute(params, execution)


__all__ = [
    "VIsObliqueOutputs",
    "VIsObliqueParameters",
    "V__IS_OBLIQUE_METADATA",
    "v__is_oblique",
    "v__is_oblique_params",
]
