# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__NOISY_SKULL_STRIP_METADATA = Metadata(
    id="e98b609b47a8089d945c591b91e1f67238f32e0b.boutiques",
    name="@NoisySkullStrip",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VNoisySkullStripParameters = typing.TypedDict('VNoisySkullStripParameters', {
    "__STYXTYPE__": typing.Literal["@NoisySkullStrip"],
    "input_file": InputPathType,
    "keep_tmp": bool,
    "3dskullstrip_opts": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@NoisySkullStrip": v__noisy_skull_strip_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@NoisySkullStrip": v__noisy_skull_strip_outputs,
    }.get(t)


class VNoisySkullStripOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__noisy_skull_strip(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    anat_ns: OutputPathType
    """Skull stripped version of ANAT"""
    anat_air: OutputPathType
    """Special mask output - air"""
    anat_skl: OutputPathType
    """Special mask output - skull"""
    anat_lsp: OutputPathType
    """Volume used to threshold 'air' out of the volume to be stripped"""


def v__noisy_skull_strip_params(
    input_file: InputPathType,
    keep_tmp: bool = False,
    v_3dskullstrip_opts: str | None = None,
) -> VNoisySkullStripParameters:
    """
    Build parameters.
    
    Args:
        input_file: The anatomical dataset.
        keep_tmp: Do not erase temporary files at the end.
        v_3dskullstrip_opts: Anything following this option is passed to\
            3dSkullStrip.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@NoisySkullStrip",
        "input_file": input_file,
        "keep_tmp": keep_tmp,
    }
    if v_3dskullstrip_opts is not None:
        params["3dskullstrip_opts"] = v_3dskullstrip_opts
    return params


def v__noisy_skull_strip_cargs(
    params: VNoisySkullStripParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@NoisySkullStrip")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file"))
    ])
    if params.get("keep_tmp"):
        cargs.append("-keep_tmp")
    if params.get("3dskullstrip_opts") is not None:
        cargs.extend([
            "-3dSkullStrip_opts",
            params.get("3dskullstrip_opts")
        ])
    return cargs


def v__noisy_skull_strip_outputs(
    params: VNoisySkullStripParameters,
    execution: Execution,
) -> VNoisySkullStripOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VNoisySkullStripOutputs(
        root=execution.output_file("."),
        anat_ns=execution.output_file(pathlib.Path(params.get("input_file")).name + ".ns"),
        anat_air=execution.output_file(pathlib.Path(params.get("input_file")).name + ".air"),
        anat_skl=execution.output_file(pathlib.Path(params.get("input_file")).name + ".skl"),
        anat_lsp=execution.output_file(pathlib.Path(params.get("input_file")).name + ".lsp"),
    )
    return ret


def v__noisy_skull_strip_execute(
    params: VNoisySkullStripParameters,
    execution: Execution,
) -> VNoisySkullStripOutputs:
    """
    Strips the skull of anatomical datasets with low SNR.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VNoisySkullStripOutputs`).
    """
    params = execution.params(params)
    cargs = v__noisy_skull_strip_cargs(params, execution)
    ret = v__noisy_skull_strip_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__noisy_skull_strip(
    input_file: InputPathType,
    keep_tmp: bool = False,
    v_3dskullstrip_opts: str | None = None,
    runner: Runner | None = None,
) -> VNoisySkullStripOutputs:
    """
    Strips the skull of anatomical datasets with low SNR.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: The anatomical dataset.
        keep_tmp: Do not erase temporary files at the end.
        v_3dskullstrip_opts: Anything following this option is passed to\
            3dSkullStrip.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VNoisySkullStripOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__NOISY_SKULL_STRIP_METADATA)
    params = v__noisy_skull_strip_params(
        input_file=input_file,
        keep_tmp=keep_tmp,
        v_3dskullstrip_opts=v_3dskullstrip_opts,
    )
    return v__noisy_skull_strip_execute(params, execution)


__all__ = [
    "VNoisySkullStripOutputs",
    "VNoisySkullStripParameters",
    "V__NOISY_SKULL_STRIP_METADATA",
    "v__noisy_skull_strip",
    "v__noisy_skull_strip_params",
]
