# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__PARSE_AFNI_NAME_METADATA = Metadata(
    id="77b207b29d926238300645b41fc4c5e89f1b41c6.boutiques",
    name="@parse_afni_name",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VParseAfniNameParameters = typing.TypedDict('VParseAfniNameParameters', {
    "__STYXTYPE__": typing.Literal["@parse_afni_name"],
    "afni_name": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@parse_afni_name": v__parse_afni_name_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@parse_afni_name": v__parse_afni_name_outputs,
    }.get(t)


class VParseAfniNameOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__parse_afni_name(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_path: OutputPathType
    """Output path parsed from the AFNI name"""
    output_prefix: OutputPathType
    """Output prefix parsed from the AFNI name"""
    output_view: OutputPathType
    """Output view parsed from the AFNI name"""
    output_subbrick: OutputPathType
    """Output sub-brick selection string parsed from the AFNI name"""


def v__parse_afni_name_params(
    afni_name: str,
) -> VParseAfniNameParameters:
    """
    Build parameters.
    
    Args:
        afni_name: The AFNI name to be parsed.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@parse_afni_name",
        "afni_name": afni_name,
    }
    return params


def v__parse_afni_name_cargs(
    params: VParseAfniNameParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@parse_afni_name")
    cargs.append(params.get("afni_name"))
    return cargs


def v__parse_afni_name_outputs(
    params: VParseAfniNameParameters,
    execution: Execution,
) -> VParseAfniNameOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VParseAfniNameOutputs(
        root=execution.output_file("."),
        output_path=execution.output_file("parsed_name_path.txt"),
        output_prefix=execution.output_file("parsed_name_prefix.txt"),
        output_view=execution.output_file("parsed_name_view.txt"),
        output_subbrick=execution.output_file("parsed_name_subbrick.txt"),
    )
    return ret


def v__parse_afni_name_execute(
    params: VParseAfniNameParameters,
    execution: Execution,
) -> VParseAfniNameOutputs:
    """
    A script to parse an AFNI name, outputting the path, prefix, view, and sub-brick
    selection string.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VParseAfniNameOutputs`).
    """
    params = execution.params(params)
    cargs = v__parse_afni_name_cargs(params, execution)
    ret = v__parse_afni_name_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__parse_afni_name(
    afni_name: str,
    runner: Runner | None = None,
) -> VParseAfniNameOutputs:
    """
    A script to parse an AFNI name, outputting the path, prefix, view, and sub-brick
    selection string.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        afni_name: The AFNI name to be parsed.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VParseAfniNameOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__PARSE_AFNI_NAME_METADATA)
    params = v__parse_afni_name_params(
        afni_name=afni_name,
    )
    return v__parse_afni_name_execute(params, execution)


__all__ = [
    "VParseAfniNameOutputs",
    "VParseAfniNameParameters",
    "V__PARSE_AFNI_NAME_METADATA",
    "v__parse_afni_name",
    "v__parse_afni_name_params",
]
