# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__RETINO_PROC_METADATA = Metadata(
    id="bd77350246b7022b7742239292c89e845e034c79.boutiques",
    name="@RetinoProc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VRetinoProcParameters = typing.TypedDict('VRetinoProcParameters', {
    "__STYXTYPE__": typing.Literal["@RetinoProc"],
    "ccw": typing.NotRequired[list[InputPathType] | None],
    "clw": typing.NotRequired[list[InputPathType] | None],
    "exp": typing.NotRequired[list[InputPathType] | None],
    "con": typing.NotRequired[list[InputPathType] | None],
    "epi_ref": typing.NotRequired[InputPathType | None],
    "epi_anat_ref": typing.NotRequired[InputPathType | None],
    "anat_vol": typing.NotRequired[InputPathType | None],
    "anat_vol_epi": typing.NotRequired[InputPathType | None],
    "surf_vol": typing.NotRequired[InputPathType | None],
    "surf_vol_epi": typing.NotRequired[InputPathType | None],
    "phase": bool,
    "delay": bool,
    "tr": float,
    "period_ecc": float,
    "period_pol": float,
    "pre_ecc": typing.NotRequired[float | None],
    "pre_pol": typing.NotRequired[float | None],
    "on_ecc": typing.NotRequired[str | None],
    "on_pol": typing.NotRequired[str | None],
    "var_on_ecc": typing.NotRequired[str | None],
    "var_on_pol": typing.NotRequired[str | None],
    "nwedges": typing.NotRequired[float | None],
    "nrings": typing.NotRequired[float | None],
    "fwhm_pol": typing.NotRequired[float | None],
    "fwhm_ecc": typing.NotRequired[float | None],
    "ignore": typing.NotRequired[float | None],
    "no_tshift": bool,
    "spec_left": typing.NotRequired[InputPathType | None],
    "spec_right": typing.NotRequired[InputPathType | None],
    "dorts": typing.NotRequired[InputPathType | None],
    "ccw_orts": typing.NotRequired[list[InputPathType] | None],
    "clw_orts": typing.NotRequired[list[InputPathType] | None],
    "exp_orts": typing.NotRequired[list[InputPathType] | None],
    "con_orts": typing.NotRequired[list[InputPathType] | None],
    "sid": typing.NotRequired[str | None],
    "out_dir": typing.NotRequired[str | None],
    "echo": bool,
    "echo_edu": bool,
    "a2e_opts": typing.NotRequired[str | None],
    "aea_opts": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@RetinoProc": v__retino_proc_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class VRetinoProcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__retino_proc(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__retino_proc_params(
    tr: float,
    period_ecc: float,
    period_pol: float,
    ccw: list[InputPathType] | None = None,
    clw: list[InputPathType] | None = None,
    exp: list[InputPathType] | None = None,
    con: list[InputPathType] | None = None,
    epi_ref: InputPathType | None = None,
    epi_anat_ref: InputPathType | None = None,
    anat_vol: InputPathType | None = None,
    anat_vol_epi: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    surf_vol_epi: InputPathType | None = None,
    phase: bool = False,
    delay: bool = False,
    pre_ecc: float | None = None,
    pre_pol: float | None = None,
    on_ecc: str | None = None,
    on_pol: str | None = None,
    var_on_ecc: str | None = None,
    var_on_pol: str | None = None,
    nwedges: float | None = None,
    nrings: float | None = None,
    fwhm_pol: float | None = None,
    fwhm_ecc: float | None = None,
    ignore: float | None = None,
    no_tshift: bool = False,
    spec_left: InputPathType | None = None,
    spec_right: InputPathType | None = None,
    dorts: InputPathType | None = None,
    ccw_orts: list[InputPathType] | None = None,
    clw_orts: list[InputPathType] | None = None,
    exp_orts: list[InputPathType] | None = None,
    con_orts: list[InputPathType] | None = None,
    sid: str | None = None,
    out_dir: str | None = None,
    echo: bool = False,
    echo_edu: bool = False,
    a2e_opts: str | None = None,
    aea_opts: str | None = None,
) -> VRetinoProcParameters:
    """
    Build parameters.
    
    Args:
        tr: TR, in seconds, of retinotopic scans.
        period_ecc: Period, in seconds, of eccentricity stimuli.
        period_pol: Period, in seconds, of polar angle stimuli.
        ccw: Input time series dataset for counterclockwise stimulus.
        clw: Input time series dataset for clockwise stimulus.
        exp: Input time series dataset for expanding stimulus.
        con: Input time series dataset for contracting stimulus.
        epi_ref: Specify a volume from the EPI time series to which all EPI\
            volumes are aligned.
        epi_anat_ref: Specify a volume from the EPI time series that is better\
            suited for aligning the T1 to it than EpiRef might be.
        anat_vol: T1 volume acquired during the same session as the retinotopic\
            scans.
        anat_vol_epi: Anatomical volume aligned to EPI reference.
        surf_vol: Surface Volume for the cortical surfaces.
        surf_vol_epi: Surface volume aligned to experiment's EPI data.
        phase: Use phase of fundamental frequency to estimate latency.
        delay: Use delay relative to reference time series to estimate latency.
        pre_ecc: Duration, in seconds, before eccentricity stimulus.
        pre_pol: Duration, in seconds, before polar angle stimulus.
        on_ecc: Number of stimulation blocks and duration of stimulation for\
            eccentricity stimulus.
        on_pol: Number of stimulation blocks and duration of stimulation for\
            polar angle stimulus.
        var_on_ecc: Multiple on durations for eccentricity stimulus.
        var_on_pol: Multiple on durations for polar angle stimulus.
        nwedges: Number of wedges in polar stimulus.
        nrings: Number of rings in eccentricity stimulus.
        fwhm_pol: Target smoothness for polar stimulus.
        fwhm_ecc: Target smoothness for eccentricity stimulus.
        ignore: Ignore volumes from the beginning of each time series.
        no_tshift: Do not correct for slice timing.
        spec_left: Spec file for left hemisphere.
        spec_right: Spec file for right hemisphere.
        dorts: Detrend time series using columns in ORT1D file.
        ccw_orts: Detrend time series for counterclockwise stimulus.
        clw_orts: Detrend time series for clockwise stimulus.
        exp_orts: Detrend time series for expanding stimulus.
        con_orts: Detrend time series for contracting stimulus.
        sid: SID is a flag identifying the subject.
        out_dir: Directory where processing results are to be stored.
        echo: Turn on the command echoing to help with debugging script failure.
        echo_edu: Turn on command echoing for certain programs only.
        a2e_opts: Pass options to @SUMA_AlignToExperiment script.
        aea_opts: Pass options to align_epi_anat.py.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@RetinoProc",
        "phase": phase,
        "delay": delay,
        "tr": tr,
        "period_ecc": period_ecc,
        "period_pol": period_pol,
        "no_tshift": no_tshift,
        "echo": echo,
        "echo_edu": echo_edu,
    }
    if ccw is not None:
        params["ccw"] = ccw
    if clw is not None:
        params["clw"] = clw
    if exp is not None:
        params["exp"] = exp
    if con is not None:
        params["con"] = con
    if epi_ref is not None:
        params["epi_ref"] = epi_ref
    if epi_anat_ref is not None:
        params["epi_anat_ref"] = epi_anat_ref
    if anat_vol is not None:
        params["anat_vol"] = anat_vol
    if anat_vol_epi is not None:
        params["anat_vol_epi"] = anat_vol_epi
    if surf_vol is not None:
        params["surf_vol"] = surf_vol
    if surf_vol_epi is not None:
        params["surf_vol_epi"] = surf_vol_epi
    if pre_ecc is not None:
        params["pre_ecc"] = pre_ecc
    if pre_pol is not None:
        params["pre_pol"] = pre_pol
    if on_ecc is not None:
        params["on_ecc"] = on_ecc
    if on_pol is not None:
        params["on_pol"] = on_pol
    if var_on_ecc is not None:
        params["var_on_ecc"] = var_on_ecc
    if var_on_pol is not None:
        params["var_on_pol"] = var_on_pol
    if nwedges is not None:
        params["nwedges"] = nwedges
    if nrings is not None:
        params["nrings"] = nrings
    if fwhm_pol is not None:
        params["fwhm_pol"] = fwhm_pol
    if fwhm_ecc is not None:
        params["fwhm_ecc"] = fwhm_ecc
    if ignore is not None:
        params["ignore"] = ignore
    if spec_left is not None:
        params["spec_left"] = spec_left
    if spec_right is not None:
        params["spec_right"] = spec_right
    if dorts is not None:
        params["dorts"] = dorts
    if ccw_orts is not None:
        params["ccw_orts"] = ccw_orts
    if clw_orts is not None:
        params["clw_orts"] = clw_orts
    if exp_orts is not None:
        params["exp_orts"] = exp_orts
    if con_orts is not None:
        params["con_orts"] = con_orts
    if sid is not None:
        params["sid"] = sid
    if out_dir is not None:
        params["out_dir"] = out_dir
    if a2e_opts is not None:
        params["a2e_opts"] = a2e_opts
    if aea_opts is not None:
        params["aea_opts"] = aea_opts
    return params


def v__retino_proc_cargs(
    params: VRetinoProcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@RetinoProc")
    if params.get("ccw") is not None:
        cargs.extend([
            "-ccw",
            *[execution.input_file(f) for f in params.get("ccw")]
        ])
    if params.get("clw") is not None:
        cargs.extend([
            "-clw",
            *[execution.input_file(f) for f in params.get("clw")]
        ])
    if params.get("exp") is not None:
        cargs.extend([
            "-exp",
            *[execution.input_file(f) for f in params.get("exp")]
        ])
    if params.get("con") is not None:
        cargs.extend([
            "-con",
            *[execution.input_file(f) for f in params.get("con")]
        ])
    if params.get("epi_ref") is not None:
        cargs.extend([
            "-epi_ref",
            execution.input_file(params.get("epi_ref"))
        ])
    if params.get("epi_anat_ref") is not None:
        cargs.extend([
            "-epi_anat_ref",
            execution.input_file(params.get("epi_anat_ref"))
        ])
    if params.get("anat_vol") is not None:
        cargs.extend([
            "-anat_vol",
            execution.input_file(params.get("anat_vol"))
        ])
    if params.get("anat_vol_epi") is not None:
        cargs.extend([
            "-anat_vol@epi",
            execution.input_file(params.get("anat_vol_epi"))
        ])
    if params.get("surf_vol") is not None:
        cargs.extend([
            "-surf_vol",
            execution.input_file(params.get("surf_vol"))
        ])
    if params.get("surf_vol_epi") is not None:
        cargs.extend([
            "-surf_vol@epi",
            execution.input_file(params.get("surf_vol_epi"))
        ])
    if params.get("phase"):
        cargs.append("-phase")
    if params.get("delay"):
        cargs.append("-delay")
    cargs.extend([
        "-TR",
        str(params.get("tr"))
    ])
    cargs.extend([
        "-period_ecc",
        str(params.get("period_ecc"))
    ])
    cargs.extend([
        "-period_pol",
        str(params.get("period_pol"))
    ])
    if params.get("pre_ecc") is not None:
        cargs.extend([
            "-pre_ecc",
            str(params.get("pre_ecc"))
        ])
    if params.get("pre_pol") is not None:
        cargs.extend([
            "-pre_pol",
            str(params.get("pre_pol"))
        ])
    if params.get("on_ecc") is not None:
        cargs.extend([
            "-on_ecc",
            params.get("on_ecc")
        ])
    if params.get("on_pol") is not None:
        cargs.extend([
            "-on_pol",
            params.get("on_pol")
        ])
    if params.get("var_on_ecc") is not None:
        cargs.extend([
            "-var_on_ecc",
            params.get("var_on_ecc")
        ])
    if params.get("var_on_pol") is not None:
        cargs.extend([
            "-var_on_pol",
            params.get("var_on_pol")
        ])
    if params.get("nwedges") is not None:
        cargs.extend([
            "-nwedges",
            str(params.get("nwedges"))
        ])
    if params.get("nrings") is not None:
        cargs.extend([
            "-nrings",
            str(params.get("nrings"))
        ])
    if params.get("fwhm_pol") is not None:
        cargs.extend([
            "-fwhm_pol",
            str(params.get("fwhm_pol"))
        ])
    if params.get("fwhm_ecc") is not None:
        cargs.extend([
            "-fwhm_ecc",
            str(params.get("fwhm_ecc"))
        ])
    if params.get("ignore") is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore"))
        ])
    if params.get("no_tshift"):
        cargs.append("-no_tshift")
    if params.get("spec_left") is not None:
        cargs.extend([
            "-spec_left",
            execution.input_file(params.get("spec_left"))
        ])
    if params.get("spec_right") is not None:
        cargs.extend([
            "-spec_right",
            execution.input_file(params.get("spec_right"))
        ])
    if params.get("dorts") is not None:
        cargs.extend([
            "-dorts",
            execution.input_file(params.get("dorts"))
        ])
    if params.get("ccw_orts") is not None:
        cargs.extend([
            "-ccw_orts",
            *[execution.input_file(f) for f in params.get("ccw_orts")]
        ])
    if params.get("clw_orts") is not None:
        cargs.extend([
            "-clw_orts",
            *[execution.input_file(f) for f in params.get("clw_orts")]
        ])
    if params.get("exp_orts") is not None:
        cargs.extend([
            "-exp_orts",
            *[execution.input_file(f) for f in params.get("exp_orts")]
        ])
    if params.get("con_orts") is not None:
        cargs.extend([
            "-con_orts",
            *[execution.input_file(f) for f in params.get("con_orts")]
        ])
    if params.get("sid") is not None:
        cargs.extend([
            "-sid",
            params.get("sid")
        ])
    if params.get("out_dir") is not None:
        cargs.extend([
            "-out_dir",
            params.get("out_dir")
        ])
    if params.get("echo"):
        cargs.append("-echo")
    if params.get("echo_edu"):
        cargs.append("-echo_edu")
    if params.get("a2e_opts") is not None:
        cargs.extend([
            "-A2E_opts",
            params.get("a2e_opts")
        ])
    if params.get("aea_opts") is not None:
        cargs.extend([
            "-AEA_opts",
            params.get("aea_opts")
        ])
    return cargs


def v__retino_proc_outputs(
    params: VRetinoProcParameters,
    execution: Execution,
) -> VRetinoProcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VRetinoProcOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__retino_proc_execute(
    params: VRetinoProcParameters,
    execution: Execution,
) -> VRetinoProcOutputs:
    """
    A script to process retinotopic FMRI data, using AFNI's 3dRetinoPhase and
    SurfRetinMap.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VRetinoProcOutputs`).
    """
    params = execution.params(params)
    cargs = v__retino_proc_cargs(params, execution)
    ret = v__retino_proc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__retino_proc(
    tr: float,
    period_ecc: float,
    period_pol: float,
    ccw: list[InputPathType] | None = None,
    clw: list[InputPathType] | None = None,
    exp: list[InputPathType] | None = None,
    con: list[InputPathType] | None = None,
    epi_ref: InputPathType | None = None,
    epi_anat_ref: InputPathType | None = None,
    anat_vol: InputPathType | None = None,
    anat_vol_epi: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    surf_vol_epi: InputPathType | None = None,
    phase: bool = False,
    delay: bool = False,
    pre_ecc: float | None = None,
    pre_pol: float | None = None,
    on_ecc: str | None = None,
    on_pol: str | None = None,
    var_on_ecc: str | None = None,
    var_on_pol: str | None = None,
    nwedges: float | None = None,
    nrings: float | None = None,
    fwhm_pol: float | None = None,
    fwhm_ecc: float | None = None,
    ignore: float | None = None,
    no_tshift: bool = False,
    spec_left: InputPathType | None = None,
    spec_right: InputPathType | None = None,
    dorts: InputPathType | None = None,
    ccw_orts: list[InputPathType] | None = None,
    clw_orts: list[InputPathType] | None = None,
    exp_orts: list[InputPathType] | None = None,
    con_orts: list[InputPathType] | None = None,
    sid: str | None = None,
    out_dir: str | None = None,
    echo: bool = False,
    echo_edu: bool = False,
    a2e_opts: str | None = None,
    aea_opts: str | None = None,
    runner: Runner | None = None,
) -> VRetinoProcOutputs:
    """
    A script to process retinotopic FMRI data, using AFNI's 3dRetinoPhase and
    SurfRetinMap.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tr: TR, in seconds, of retinotopic scans.
        period_ecc: Period, in seconds, of eccentricity stimuli.
        period_pol: Period, in seconds, of polar angle stimuli.
        ccw: Input time series dataset for counterclockwise stimulus.
        clw: Input time series dataset for clockwise stimulus.
        exp: Input time series dataset for expanding stimulus.
        con: Input time series dataset for contracting stimulus.
        epi_ref: Specify a volume from the EPI time series to which all EPI\
            volumes are aligned.
        epi_anat_ref: Specify a volume from the EPI time series that is better\
            suited for aligning the T1 to it than EpiRef might be.
        anat_vol: T1 volume acquired during the same session as the retinotopic\
            scans.
        anat_vol_epi: Anatomical volume aligned to EPI reference.
        surf_vol: Surface Volume for the cortical surfaces.
        surf_vol_epi: Surface volume aligned to experiment's EPI data.
        phase: Use phase of fundamental frequency to estimate latency.
        delay: Use delay relative to reference time series to estimate latency.
        pre_ecc: Duration, in seconds, before eccentricity stimulus.
        pre_pol: Duration, in seconds, before polar angle stimulus.
        on_ecc: Number of stimulation blocks and duration of stimulation for\
            eccentricity stimulus.
        on_pol: Number of stimulation blocks and duration of stimulation for\
            polar angle stimulus.
        var_on_ecc: Multiple on durations for eccentricity stimulus.
        var_on_pol: Multiple on durations for polar angle stimulus.
        nwedges: Number of wedges in polar stimulus.
        nrings: Number of rings in eccentricity stimulus.
        fwhm_pol: Target smoothness for polar stimulus.
        fwhm_ecc: Target smoothness for eccentricity stimulus.
        ignore: Ignore volumes from the beginning of each time series.
        no_tshift: Do not correct for slice timing.
        spec_left: Spec file for left hemisphere.
        spec_right: Spec file for right hemisphere.
        dorts: Detrend time series using columns in ORT1D file.
        ccw_orts: Detrend time series for counterclockwise stimulus.
        clw_orts: Detrend time series for clockwise stimulus.
        exp_orts: Detrend time series for expanding stimulus.
        con_orts: Detrend time series for contracting stimulus.
        sid: SID is a flag identifying the subject.
        out_dir: Directory where processing results are to be stored.
        echo: Turn on the command echoing to help with debugging script failure.
        echo_edu: Turn on command echoing for certain programs only.
        a2e_opts: Pass options to @SUMA_AlignToExperiment script.
        aea_opts: Pass options to align_epi_anat.py.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VRetinoProcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__RETINO_PROC_METADATA)
    params = v__retino_proc_params(
        ccw=ccw,
        clw=clw,
        exp=exp,
        con=con,
        epi_ref=epi_ref,
        epi_anat_ref=epi_anat_ref,
        anat_vol=anat_vol,
        anat_vol_epi=anat_vol_epi,
        surf_vol=surf_vol,
        surf_vol_epi=surf_vol_epi,
        phase=phase,
        delay=delay,
        tr=tr,
        period_ecc=period_ecc,
        period_pol=period_pol,
        pre_ecc=pre_ecc,
        pre_pol=pre_pol,
        on_ecc=on_ecc,
        on_pol=on_pol,
        var_on_ecc=var_on_ecc,
        var_on_pol=var_on_pol,
        nwedges=nwedges,
        nrings=nrings,
        fwhm_pol=fwhm_pol,
        fwhm_ecc=fwhm_ecc,
        ignore=ignore,
        no_tshift=no_tshift,
        spec_left=spec_left,
        spec_right=spec_right,
        dorts=dorts,
        ccw_orts=ccw_orts,
        clw_orts=clw_orts,
        exp_orts=exp_orts,
        con_orts=con_orts,
        sid=sid,
        out_dir=out_dir,
        echo=echo,
        echo_edu=echo_edu,
        a2e_opts=a2e_opts,
        aea_opts=aea_opts,
    )
    return v__retino_proc_execute(params, execution)


__all__ = [
    "VRetinoProcOutputs",
    "VRetinoProcParameters",
    "V__RETINO_PROC_METADATA",
    "v__retino_proc",
    "v__retino_proc_params",
]
