# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_FSVOL_TO_BRIK_METADATA = Metadata(
    id="4852184b5da4f86b34b433664927c76929e3ca4c.boutiques",
    name="@SUMA_FSvolToBRIK",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaFsvolToBrikParameters = typing.TypedDict('VSumaFsvolToBrikParameters', {
    "__STYXTYPE__": typing.Literal["@SUMA_FSvolToBRIK"],
    "fs_vol_data": InputPathType,
    "prefix": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@SUMA_FSvolToBRIK": v__suma_fsvol_to_brik_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@SUMA_FSvolToBRIK": v__suma_fsvol_to_brik_outputs,
    }.get(t)


class VSumaFsvolToBrikOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__suma_fsvol_to_brik(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_brik: OutputPathType
    """Output BRIK volume converted from FreeSurfer data"""
    out_head: OutputPathType
    """Header file for the output BRIK volume"""


def v__suma_fsvol_to_brik_params(
    fs_vol_data: InputPathType,
    prefix: str,
) -> VSumaFsvolToBrikParameters:
    """
    Build parameters.
    
    Args:
        fs_vol_data: Input FreeSurfer volume data (e.g. COR- images or .mgz\
            volume).
        prefix: Prefix for output BRIK volume.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@SUMA_FSvolToBRIK",
        "fs_vol_data": fs_vol_data,
        "prefix": prefix,
    }
    return params


def v__suma_fsvol_to_brik_cargs(
    params: VSumaFsvolToBrikParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_FSvolToBRIK")
    cargs.append(execution.input_file(params.get("fs_vol_data")))
    cargs.append(params.get("prefix"))
    return cargs


def v__suma_fsvol_to_brik_outputs(
    params: VSumaFsvolToBrikParameters,
    execution: Execution,
) -> VSumaFsvolToBrikOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaFsvolToBrikOutputs(
        root=execution.output_file("."),
        out_brik=execution.output_file(params.get("prefix") + ".BRIK"),
        out_head=execution.output_file(params.get("prefix") + ".HEAD"),
    )
    return ret


def v__suma_fsvol_to_brik_execute(
    params: VSumaFsvolToBrikParameters,
    execution: Execution,
) -> VSumaFsvolToBrikOutputs:
    """
    A script to convert COR- or .mgz files from FreeSurfer to BRIK format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VSumaFsvolToBrikOutputs`).
    """
    params = execution.params(params)
    cargs = v__suma_fsvol_to_brik_cargs(params, execution)
    ret = v__suma_fsvol_to_brik_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_fsvol_to_brik(
    fs_vol_data: InputPathType,
    prefix: str,
    runner: Runner | None = None,
) -> VSumaFsvolToBrikOutputs:
    """
    A script to convert COR- or .mgz files from FreeSurfer to BRIK format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        fs_vol_data: Input FreeSurfer volume data (e.g. COR- images or .mgz\
            volume).
        prefix: Prefix for output BRIK volume.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaFsvolToBrikOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_FSVOL_TO_BRIK_METADATA)
    params = v__suma_fsvol_to_brik_params(
        fs_vol_data=fs_vol_data,
        prefix=prefix,
    )
    return v__suma_fsvol_to_brik_execute(params, execution)


__all__ = [
    "VSumaFsvolToBrikOutputs",
    "VSumaFsvolToBrikParameters",
    "V__SUMA_FSVOL_TO_BRIK_METADATA",
    "v__suma_fsvol_to_brik",
    "v__suma_fsvol_to_brik_params",
]
