# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_MAKE_SPEC_CARET_METADATA = Metadata(
    id="9f583a038a94aad61db75157df703ae8d46fc78e.boutiques",
    name="@SUMA_Make_Spec_Caret",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaMakeSpecCaretParameters = typing.TypedDict('VSumaMakeSpecCaretParameters', {
    "__STYXTYPE__": typing.Literal["@SUMA_Make_Spec_Caret"],
    "subject_id": str,
    "help": bool,
    "debug": typing.NotRequired[int | None],
    "echo": bool,
    "surface_path": typing.NotRequired[str | None],
    "side_labels_style": typing.NotRequired[int | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@SUMA_Make_Spec_Caret": v__suma_make_spec_caret_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@SUMA_Make_Spec_Caret": v__suma_make_spec_caret_outputs,
    }.get(t)


class VSumaMakeSpecCaretOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__suma_make_spec_caret(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    left_hemisphere_spec: OutputPathType
    """Output spec file for the left hemisphere"""
    right_hemisphere_spec: OutputPathType
    """Output spec file for the right hemisphere"""


def v__suma_make_spec_caret_params(
    subject_id: str,
    help_: bool = False,
    debug: int | None = None,
    echo: bool = False,
    surface_path: str | None = None,
    side_labels_style: int | None = None,
) -> VSumaMakeSpecCaretParameters:
    """
    Build parameters.
    
    Args:
        subject_id: Subject ID for file naming.
        help_: Show help information.
        debug: Print debug information along the way.
        echo: Turn shell echo on.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        side_labels_style: Naming style for Left, Right sides. Allowed values:\
            1 for L R LR style (default), 2 for LEFT RIGHT LR style, 3 for A B AB.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@SUMA_Make_Spec_Caret",
        "subject_id": subject_id,
        "help": help_,
        "echo": echo,
    }
    if debug is not None:
        params["debug"] = debug
    if surface_path is not None:
        params["surface_path"] = surface_path
    if side_labels_style is not None:
        params["side_labels_style"] = side_labels_style
    return params


def v__suma_make_spec_caret_cargs(
    params: VSumaMakeSpecCaretParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_Make_Spec_Caret")
    cargs.extend([
        "-sid",
        params.get("subject_id")
    ])
    if params.get("help"):
        cargs.append("-help")
    if params.get("debug") is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug"))
        ])
    if params.get("echo"):
        cargs.append("-echo")
    if params.get("surface_path") is not None:
        cargs.extend([
            "-sfpath",
            params.get("surface_path")
        ])
    if params.get("side_labels_style") is not None:
        cargs.extend([
            "-side_labels_style",
            str(params.get("side_labels_style"))
        ])
    return cargs


def v__suma_make_spec_caret_outputs(
    params: VSumaMakeSpecCaretParameters,
    execution: Execution,
) -> VSumaMakeSpecCaretOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaMakeSpecCaretOutputs(
        root=execution.output_file("."),
        left_hemisphere_spec=execution.output_file(params.get("subject_id") + "_lh.spec"),
        right_hemisphere_spec=execution.output_file(params.get("subject_id") + "_rh.spec"),
    )
    return ret


def v__suma_make_spec_caret_execute(
    params: VSumaMakeSpecCaretParameters,
    execution: Execution,
) -> VSumaMakeSpecCaretOutputs:
    """
    Prepare surfaces for viewing in SUMA, tested with Caret-5.2 surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecCaretOutputs`).
    """
    params = execution.params(params)
    cargs = v__suma_make_spec_caret_cargs(params, execution)
    ret = v__suma_make_spec_caret_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_make_spec_caret(
    subject_id: str,
    help_: bool = False,
    debug: int | None = None,
    echo: bool = False,
    surface_path: str | None = None,
    side_labels_style: int | None = None,
    runner: Runner | None = None,
) -> VSumaMakeSpecCaretOutputs:
    """
    Prepare surfaces for viewing in SUMA, tested with Caret-5.2 surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        subject_id: Subject ID for file naming.
        help_: Show help information.
        debug: Print debug information along the way.
        echo: Turn shell echo on.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        side_labels_style: Naming style for Left, Right sides. Allowed values:\
            1 for L R LR style (default), 2 for LEFT RIGHT LR style, 3 for A B AB.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecCaretOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_MAKE_SPEC_CARET_METADATA)
    params = v__suma_make_spec_caret_params(
        subject_id=subject_id,
        help_=help_,
        debug=debug,
        echo=echo,
        surface_path=surface_path,
        side_labels_style=side_labels_style,
    )
    return v__suma_make_spec_caret_execute(params, execution)


__all__ = [
    "VSumaMakeSpecCaretOutputs",
    "VSumaMakeSpecCaretParameters",
    "V__SUMA_MAKE_SPEC_CARET_METADATA",
    "v__suma_make_spec_caret",
    "v__suma_make_spec_caret_params",
]
