# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_MAKE_SPEC_SF_METADATA = Metadata(
    id="b2f1fc4d123e03415cf587f26d4d91d1d54dd486.boutiques",
    name="@SUMA_Make_Spec_SF",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaMakeSpecSfParameters = typing.TypedDict('VSumaMakeSpecSfParameters', {
    "__STYXTYPE__": typing.Literal["@SUMA_Make_Spec_SF"],
    "debug_level": typing.NotRequired[int | None],
    "surface_path": typing.NotRequired[str | None],
    "subject_id": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@SUMA_Make_Spec_SF": v__suma_make_spec_sf_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@SUMA_Make_Spec_SF": v__suma_make_spec_sf_outputs,
    }.get(t)


class VSumaMakeSpecSfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__suma_make_spec_sf(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType
    """All created files are stored in SURFACES directory"""


def v__suma_make_spec_sf_params(
    subject_id: str,
    debug_level: int | None = None,
    surface_path: str | None = None,
) -> VSumaMakeSpecSfParameters:
    """
    Build parameters.
    
    Args:
        subject_id: Required subject ID for file naming.
        debug_level: Print debug information along the way.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@SUMA_Make_Spec_SF",
        "subject_id": subject_id,
    }
    if debug_level is not None:
        params["debug_level"] = debug_level
    if surface_path is not None:
        params["surface_path"] = surface_path
    return params


def v__suma_make_spec_sf_cargs(
    params: VSumaMakeSpecSfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_Make_Spec_SF")
    if params.get("debug_level") is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level"))
        ])
    if params.get("surface_path") is not None:
        cargs.extend([
            "-sfpath",
            params.get("surface_path")
        ])
    cargs.extend([
        "-sid",
        params.get("subject_id")
    ])
    return cargs


def v__suma_make_spec_sf_outputs(
    params: VSumaMakeSpecSfParameters,
    execution: Execution,
) -> VSumaMakeSpecSfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaMakeSpecSfOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file("SURFACES/*"),
    )
    return ret


def v__suma_make_spec_sf_execute(
    params: VSumaMakeSpecSfParameters,
    execution: Execution,
) -> VSumaMakeSpecSfOutputs:
    """
    Prepare for surface viewing in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecSfOutputs`).
    """
    params = execution.params(params)
    cargs = v__suma_make_spec_sf_cargs(params, execution)
    ret = v__suma_make_spec_sf_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_make_spec_sf(
    subject_id: str,
    debug_level: int | None = None,
    surface_path: str | None = None,
    runner: Runner | None = None,
) -> VSumaMakeSpecSfOutputs:
    """
    Prepare for surface viewing in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        subject_id: Required subject ID for file naming.
        debug_level: Print debug information along the way.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecSfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_MAKE_SPEC_SF_METADATA)
    params = v__suma_make_spec_sf_params(
        debug_level=debug_level,
        surface_path=surface_path,
        subject_id=subject_id,
    )
    return v__suma_make_spec_sf_execute(params, execution)


__all__ = [
    "VSumaMakeSpecSfOutputs",
    "VSumaMakeSpecSfParameters",
    "V__SUMA_MAKE_SPEC_SF_METADATA",
    "v__suma_make_spec_sf",
    "v__suma_make_spec_sf_params",
]
