# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TO_MNI_QWARPAR_METADATA = Metadata(
    id="d56ea262996a4cde8c195ff538d38d88a827a2b1.boutiques",
    name="@toMNI_Qwarpar",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VToMniQwarparParameters = typing.TypedDict('VToMniQwarparParameters', {
    "__STYXTYPE__": typing.Literal["@toMNI_Qwarpar"],
    "numcpu": float,
    "numjob": float,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@toMNI_Qwarpar": v__to_mni_qwarpar_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@toMNI_Qwarpar": v__to_mni_qwarpar_outputs,
    }.get(t)


class VToMniQwarparOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__to_mni_qwarpar(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output dataset created after processing."""


def v__to_mni_qwarpar_params(
    numcpu: float,
    numjob: float,
) -> VToMniQwarparParameters:
    """
    Build parameters.
    
    Args:
        numcpu: TOTAL NUMBER OF CPUS TO USE; should not exceed the number of\
            CPUs (cores) on the system.
        numjob: MAX NUMBER OF JOBS TO USE; often set to the same value as\
            numcpu so that 1 dataset is processed in 1 core.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@toMNI_Qwarpar",
        "numcpu": numcpu,
        "numjob": numjob,
    }
    return params


def v__to_mni_qwarpar_cargs(
    params: VToMniQwarparParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@toMNI_Qwarpar")
    cargs.append(str(params.get("numcpu")))
    cargs.append(str(params.get("numjob")))
    return cargs


def v__to_mni_qwarpar_outputs(
    params: VToMniQwarparParameters,
    execution: Execution,
) -> VToMniQwarparOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VToMniQwarparOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("*_uni+tlrc.HEAD"),
    )
    return ret


def v__to_mni_qwarpar_execute(
    params: VToMniQwarparParameters,
    execution: Execution,
) -> VToMniQwarparOutputs:
    """
    Transforms datasets to MNI space, then collectively re-transforms them to
    produce a refined average.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VToMniQwarparOutputs`).
    """
    params = execution.params(params)
    cargs = v__to_mni_qwarpar_cargs(params, execution)
    ret = v__to_mni_qwarpar_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__to_mni_qwarpar(
    numcpu: float,
    numjob: float,
    runner: Runner | None = None,
) -> VToMniQwarparOutputs:
    """
    Transforms datasets to MNI space, then collectively re-transforms them to
    produce a refined average.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        numcpu: TOTAL NUMBER OF CPUS TO USE; should not exceed the number of\
            CPUs (cores) on the system.
        numjob: MAX NUMBER OF JOBS TO USE; often set to the same value as\
            numcpu so that 1 dataset is processed in 1 core.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToMniQwarparOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TO_MNI_QWARPAR_METADATA)
    params = v__to_mni_qwarpar_params(
        numcpu=numcpu,
        numjob=numjob,
    )
    return v__to_mni_qwarpar_execute(params, execution)


__all__ = [
    "VToMniQwarparOutputs",
    "VToMniQwarparParameters",
    "V__TO_MNI_QWARPAR_METADATA",
    "v__to_mni_qwarpar",
    "v__to_mni_qwarpar_params",
]
