# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TO_RAI_METADATA = Metadata(
    id="8c60899686c3401d179992be9780ca970e04a901.boutiques",
    name="@ToRAI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VToRaiParameters = typing.TypedDict('VToRaiParameters', {
    "__STYXTYPE__": typing.Literal["@ToRAI"],
    "coordinates": list[float],
    "orientation": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@ToRAI": v__to_rai_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class VToRaiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__to_rai(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__to_rai_params(
    coordinates: list[float],
    orientation: str,
) -> VToRaiParameters:
    """
    Build parameters.
    
    Args:
        coordinates: Specify the X, Y, and Z coordinates.
        orientation: Specify the orientation.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@ToRAI",
        "coordinates": coordinates,
        "orientation": orientation,
    }
    return params


def v__to_rai_cargs(
    params: VToRaiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@ToRAI")
    cargs.extend([
        "-xyz",
        *map(str, params.get("coordinates"))
    ])
    cargs.extend([
        "-or",
        params.get("orientation")
    ])
    return cargs


def v__to_rai_outputs(
    params: VToRaiParameters,
    execution: Execution,
) -> VToRaiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VToRaiOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__to_rai_execute(
    params: VToRaiParameters,
    execution: Execution,
) -> VToRaiOutputs:
    """
    Tool to change the ORIENT coordinates to RAI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VToRaiOutputs`).
    """
    params = execution.params(params)
    cargs = v__to_rai_cargs(params, execution)
    ret = v__to_rai_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__to_rai(
    coordinates: list[float],
    orientation: str,
    runner: Runner | None = None,
) -> VToRaiOutputs:
    """
    Tool to change the ORIENT coordinates to RAI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        coordinates: Specify the X, Y, and Z coordinates.
        orientation: Specify the orientation.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToRaiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TO_RAI_METADATA)
    params = v__to_rai_params(
        coordinates=coordinates,
        orientation=orientation,
    )
    return v__to_rai_execute(params, execution)


__all__ = [
    "VToRaiOutputs",
    "VToRaiParameters",
    "V__TO_RAI_METADATA",
    "v__to_rai",
    "v__to_rai_params",
]
