from PIL import Image
import os

# helper functions
def get_image_pixels(filepath: str) -> list:
    img = Image.open(filepath)
    pixel_data = img.getdata()
    return list(pixel_data)
def get_image_size(filepath: str) -> tuple:
    img = Image.open(filepath)
    return img.size

def make_blue(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((x, y), (0, 0, img_pixels[y * img_dimensions[0] + x][2]))
    
    img.save(f'{filepath}-blue.png')

def make_red(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((x, y), (img_pixels[y * img_dimensions[0] + x][0], 0, 0))
    
    img.save(f'{filepath}-red.png')

def make_green(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((x, y), (0, img_pixels[y * img_dimensions[0] + x][1], 0))
    
    img.save(f'{filepath}-green.png')

def make_yellow(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((x, y), (img_pixels[y * img_dimensions[0] + x][0], img_pixels[y * img_dimensions[0] + x][1], 0))
    
    img.save(f'{filepath}-yellow.png')

def grayscale(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('L', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            col = sum(img_pixels[y * img_dimensions[0] + x])/3
            img.putpixel((x, y), round(col))
    
    img.save(f'{os.path.splitext(filepath)[0]}-grayscale.png')

def reflectX(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((img_dimensions[0] - x - 1, y), tuple(img_pixels[y * img_dimensions[0] + x]))
    
    img.save(f'{os.path.splitext(filepath)[0]}-reflectedX.png')

def reflectY(filepath: str) -> None:
    img_pixels = get_image_pixels(filepath)
    img_dimensions = get_image_size(filepath)
    img = Image.new('RGB', img_dimensions, color=0)

    for x in range(img_dimensions[0]):
        for y in range(img_dimensions[1]):
            img.putpixel((x, img_dimensions[1] - y - 1), tuple(img_pixels[y * img_dimensions[0] + x]))
    
    img.save(f'{os.path.splitext(filepath)[0]}-reflectedY.png')