<a id="mypy-boto3-s3outposts"></a>

# mypy-boto3-s3outposts

[![PyPI - mypy-boto3-s3outposts](https://img.shields.io/pypi/v/mypy-boto3-s3outposts.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3outposts)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-s3outposts.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3outposts)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-s3outposts?color=blue)](https://pypistats.org/packages/mypy-boto3-s3outposts)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.S3Outposts 1.17.102](https://boto3.amazonaws.com/v1/documentation/api/1.17.102/reference/services/s3outposts.html#S3Outposts)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.20.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-s3outposts docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3outposts/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-s3outposts](#mypy-boto3-s3outposts)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `S3Outposts` service.

```bash
python -m pip install boto3-stubs[s3outposts]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[s3outposts]` in your environment:
  `python -m pip install 'boto3-stubs[s3outposts]'`

Both type checking and auto-complete should work for `S3Outposts` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[s3outposts]` in your environment:
  `python -m pip install 'boto3-stubs[s3outposts]'`

Both type checking and auto-complete should work for `S3Outposts` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[s3outposts]` in your environment:
  `python -m pip install 'boto3-stubs[s3outposts]'`
- Run `mypy` as usual

Type checking should work for `S3Outposts` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[s3outposts]` in your environment:
  `python -m pip install 'boto3-stubs[s3outposts]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `S3Outposts` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`S3OutpostsClient` provides annotations for `boto3.client("s3outposts")`.

```python
import boto3

from mypy_boto3_s3outposts import S3OutpostsClient

client: S3OutpostsClient = boto3.client("s3outposts")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: S3OutpostsClient = session.client("s3outposts")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_s3outposts.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_s3outposts import S3OutpostsClient
from mypy_boto3_s3outposts.paginator import (
    ListEndpointsPaginator,
)

client: S3OutpostsClient = boto3.client("s3outposts")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_endpoints_paginator: ListEndpointsPaginator = client.get_paginator("list_endpoints")
```

<a id="literals"></a>

### Literals

`mypy_boto3_s3outposts.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_s3outposts.literals import (
    EndpointStatusType,
    ListEndpointsPaginatorName,
)

def check_value(value: EndpointStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_s3outposts.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_s3outposts.type_defs import (
    CreateEndpointRequestTypeDef,
    CreateEndpointResultResponseTypeDef,
    DeleteEndpointRequestTypeDef,
    EndpointTypeDef,
    ListEndpointsRequestTypeDef,
    ListEndpointsResultResponseTypeDef,
    NetworkInterfaceTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
)

def get_structure() -> CreateEndpointRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-s3outposts` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-s3outposts docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3outposts/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
