# swiftest.Simulation(**kwargs)
The following key word arguments are specific to the ```swiftest.Simulation``` method. 
| Key Word Name                   | Key Word Description                                                                               | Options                                                                                            | Compatible Integrators |
|---------------------------------|----------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------|------------------------|
|```simdir```                     | Path to subdirectory in which to store data. Default is ```/simdir```.                             | pathlike string (ex. ```path/to/directory```)                                                      | all                    
|```read_param```                 | Read in a pre-existing parameter input file. Default is ```False```.                               | ```True```, ```False```                                                                            | all
|```param_file```                 | Name of the pre-existing parameter input file. Only used if ```read_param``` is set to ```True```. | string (ex. ```param.in```)                                                                        | all
|```read_data```                  | Read in a pre-existing simulation output file. Default is ```False```.                             | ```True```, ```False```                                                                            | all
|```codename```                   | Name of the N-body code to use. Default is ```Swiftest```.                                         | ```Swiftest```, ```Swifter```, ```Swift```                                                         | all
|```integrator```                 | Name of the N-body integrator to use. Default is ```symba```.                                      | ```symba```, ```helio```, ```rmvs```, ```whm```                                                    | all

# Parameters
These parameters can be entered as key word arguments into the ```swiftest.Simulation``` method, the ```swiftest.get_parameter``` method, the ```swiftest.set_parameter``` method, the ```swiftest.run``` method, or through editing the ASCII **<span>param.in</span>** directly, as described in the ```Usage``` column. If the key word argument or parameter's name changes between usage as a Python key word argument and as a parameter in the ASCII input files, the name of the key word argument is listed first, followed by the name of the ASCII parameter in the ```Key Word / Parameter Name``` column. Many parameters retain their Swift / Swifter names in the ASCII for backwards compatibility, but change names in the Python for readability.

| Key Word / Parameter Name       | Key Word / Parameter Description                                                                   | Options                                                                                            | Compatible Integrators | Usage |
|---------------------------------|----------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------|------------------------|-------|
|```t0```                         | The reference time for the start of the simulation in time units. Default is ```0.0```.            | floating point (ex. ```0.0```)                                                                     | all                    | Both  |
|```tstart```                     | Simulation start time for a restarted run in time units. Default is ```0.0```.                     | floating point (ex. ```0.0```)                                                                     | all                    | Both  |
|```tstop```                      | Simulation end time in time units. Must be greater than ```tstart```.                              | floating point (ex. ```100.0```)                                                                   | all                    | Both  |
|```dt```                         | Simulation step size in time units. Must be less than or equal to ```tstop```-```tstart```.        | floating point (ex. ```0.005```)                                                                   | all                    | Both  |
|```istep_out```                  | The number of time steps (```dt```) between output saves to memory. Either ```istep_out``` **OR** ```tstep_out``` may be set. Default is ```1```. | integer (ex. ```200```)                             | all                    | Both  |
|```tstep_out```                  | The approximate time between when outputs saved in memory are written to file in time units. Either ```istep_out``` **OR** ```tstep_out``` may be set. Calculates ```istep_out = floor(tstep_out / dt)``` | floating point (ex. ```10.0```) | all | Both
|```dump_cadence```               | The number of output steps between when data saved to memory is written to file. Setting to ```0``` results in writing data to file only at the completion of the simulation. Default is ```10```. | integer (ex. ```10```) | all | Both |
|```init_cond_file_type``` / ```IN_TYPE``` | Input file type. Default is ```NETCDF_DOUBLE```.                                          | ```NETCDF_DOUBLE```, ```NETCDF_FLOAT```, ```ASCII```                                               | all                    | Both  |
|```init_cond_file_name``` / ```PL_IN```, ```TP_IN```, ```CB_IN```, ```NC_IN``` | Input file name(s). If using Python and ```init_cond_file_type``` is set to ```NETCDF_DOUBLE``` or ```NETCDF_FLOAT```, default is ```init_cond.nc```. If using Python and ```init_cond_file_type``` is set to ```ASCII```, default is a dictionary: ```{"CB" : "cb.in", "PL" : "pl.in", "TP" : "tp.in"}```. If editing the ASCII **<span>param.in</span>**, each input file name is a separate parameter. If ```IN_TYPE``` is set to ```NETCDF_DOUBLE``` or ```NETCDF_FLOAT```, default is ```init_cond.nc```. If ```IN_TYPE``` is set to ```ASCII```, defaults are ```CB.IN```, ```PL.IN```, and ```TP.in```. | string (ex. ```my_init_cond.nc```), dictionary ```{"CB" : "mycb.in", "PL" : "mypl.in", "TP" : "mytp.in"}``` | all | Both
|```init_cond_format``` / ```IN_FORM```  | Input format. Default is ```EL```.                                                          | ```EL```, ```XV```                                                                                 | all                    | Both  |
|```output_file_type``` / ```OUT_TYPE``` | Output file type. Default is ```NETCDF_DOUBLE```. | ```NETCDF_DOUBLE```, ```NETCDF_FLOAT```, Swift / Swifter Only : ```REAL4```, ```REAL8```, ```XDR4```, ```XDR8```                             | all                    | Both  |
|```output_file_name``` / ```BIN_OUT```  | Output file name. Default is ```bin.nc```.                                                  | string (ex. ```mydata.nc```)                                                                       | all                    | Both  |
|```output_format``` / ```OUT_FORM```    | Output format. Default is ```XVEL```.                                                       | ```XV```, ```XVEL```                                                                               | all                    | Both  |
| ```OUT_STAT```                  | Output status. Default is ```REPLACE```.                                                           | ```NEW```, ```APPEND```, ```REPLACE```, ```UNKNOWN```                                              | all                    | ASCII only |
|```MU```                         | Mass unit system to use in the simulation. Default is ```Msun```.                                  | ```Msun```, ```Mearth```, ```kg```, ```g``` (case-insensitive)                                     | all                    | Python only |
|```DU```                         | Distance unit system to use in the simulation. Default is ```AU```.                                | ```AU```, ```Rearth```, ```m```, ```cm``` (case-insensitive)                                       | all                    | Python only |
|```TU```                         | Time unit system to use in the simulation. Default is ```Y```.                                     | ```Y```, ```YR```, ```DAY``` (Julian day), ```d``` (Julian day), ```JD``` (Julian day), ```s``` (case-insensitive) | all    | Python only |
|```MU_name```                    | The name of the mass unit. Overrides ```MU```.                                                     | string (ex. ```kilograms```)                                                                       | all                    | Python only |
|```DU_name```                    | The name of the distance unit. Overrides ```DU```.                                                 | string (ex. ```meters```)                                                                          | all                    | Python only |
|```TU_name```                    | The name of the time unit. Overrides ```TU```.                                                     | string (ex. ```seconds```)                                                                         | all                    | Python only |
|```MU2KG```                      | Mass units to kilogram conversion factor. Overrides ```MU```.                                      | floating point (ex. ```1.988409870698051e+30```)                                                   | all                    | Both  |
|```DU2M```                       | Distance units to meters conversion factor. Overrides ```DU```.                                    | floating point (ex. ```31557600.0```)                                                              | all                    | Both  |
|```TU2S```                       | Time units to seconds conversion factor. Overrides ```TU```.                                       | floating point (ex. ```149597870700.0```)                                                          | all                    | Both  |
|```rmin``` / ```CHK_RMIN```      | Heliocentric distance at which a test particle is considered merged with the central body in distance units. Default is the radius of the central body in system units. | floating point (ex. ```0.3```) | all                   | Both  |
|```rmax``` / ```CHK_RMAX```      | Heliocentric distance at which a test particle is too distant from the central body in distance units. Default is ```10000.0 AU```. | floating point (ex. ```10000.0```)                                | all                    | Both  |
|```qmin_coord``` / ```CHK_QMIN_COORD``` | Coordinate frame used to check for minimum pericenter distance. Default is ```HELIO```.     | ```HELIO```, ```BARY```                                                                            | all                    | Both  |
| ```CHK_QMIN```                  | Pericenter distance at which a test particle is too close to the pericenter of the system in distance units. | floating point, turn off using ```-1.0```                                                | all                    | ASCII only |
| ```CHK_QMIN_RANGE```            | Upper and lower bounds of the semimajor axis range used to check the pericenter distance.          | two floating points, turn off using ```-1.0 -1.0```                                                | all                    | ASCII only |
| ```CHK_EJECT```                 | Heliocentric distance at which an unbound test particle is too distant from the central body in distance units. | floating point (ex. ```1000.0```)                                                     | all                    | ASCII only |
|```extra_force``` / ```EXTRA_FORCE``` | Additional user defined force routines provided. Default is ```False``` / ```NO```.           | ```True```, ```False``` / ```YES```, ```NO```                                                      | all                    | Both  |
|```close_encounter_check``` / ```CHK_CLOSE``` | Check for close encounters. Default is ```True``` / ```YES```. Requires radius of massive bodies to be provided in initial conditions. | ```True```, ```False```  / ```YES```, ```NO```    | all                    | Both  |
|```interaction_loops```          | Method for checking for interactions between bodies. Default is ```TRIANGULAR```.                  | ```TRIANGULAR```, ```FLAT```, ```ADAPTIVE```                                                       | all                    | Both  |
|```encounter_check_loops``` / ```ENCOUNTER_CHECK``` | Method for checking for close encounters between bodies. Default is ```TRIANGULAR```.  | ```TRIANGULAR```, ```SORTSWEEP```, ```ADAPTIVE```                                           | all                    | Both  |
|```encounter_save```             | Save data for each close encounter to a file. Warning! This can generate very large files!         | ```TRAJECTORY```, ```CLOSEST```, ```BOTH```                                                        | SyMBA                  | Python only |
|```collision_model```            | Resolve collisions. Default is ```MERGE```.                                                        | ```MERGE```, ```BOUNCE```, ```FRAGGLE```                                                           | SyMBA                  | Both  |
|```nfrag_reduction```            | Factor to reduce the number of fragments generated by a collision. See below for a more detailed explanation. | floating point, default is ```30.0```, minumum is ```1.0```                             | SyMBA                  | Both  |
|```minimum_fragment_gmass``` / ```MIN_GMFRAG``` | Minimum fragment mass in gravitational mass units. Default is ```0.0```. Either ```minimum_fragment_gmass``` **OR** ```minimum_fragment_mass``` may be set. | floating point (ex. ```1e-9```) | SyMBA             | Both  |
|```minimum_fragment_mass```      | Minimum fragment mass in mass units. Either ```minimum_fragment_gmass``` **OR** ```minimum_fragment_mass``` may be set. | floating point (ex. ```1e20```)                                               | SyMBA                  | Python only |
|```rotation```                   | Rotation of massive bodies. Requires rotation vectors, radii, and moments of inertia to be provided in initial conditions. Default is ```False```. | ```True```, ```False``` / ```YES```, ```NO```      | SyMBA                  | Both  |
|```rhill_present```              | Hill Radius present in massive body input file. Default is ```False```.                            | ```True```, ```False``` / ```YES```, ```NO```                                                      | SyMBA                  | Both  |
|```compute_conservation_values``` / ```ENERGY``` | Track and report the total energy, angular momentum, and mass of the system. Default is ```False```. | ```True```, ```False``` / ```YES```, ```NO```                                    | SyMBA                  | Both  |
|```general_relativity``` / ```GR``` | General relativity. Default is ```True```.                                                      | ```True```, ```False``` / ```YES```, ```NO```                                                      | all                    | Both  |
|```big_discard```                | Include data for all fully-interacting bodies (above GMTINY) in each discard. Swifter only. Default is ```False```. | ```True```, ```False``` / ```YES```, ```NO```                                     | all                    | Both  |
|```restart```                    | If ```True```, the simulation given by ```output_file_name``` will be restarted from ```t0```.  Default is ```False```. | ```True```, ```False```                                                       | all                    | Python only |
|```gmtiny```                     | Mass cutoff between fully and semi-interacting massive bodies in gravitational mass units. Default is ```0.0```. Either ```mtiny``` **OR** ```gmtiny``` may be set. | floating point (ex. ```4e-6```)   | all                    | Both  |
|```mtiny```                      | Mass cutoff between fully and semi-interacting massive bodies in mass units. Either ```mtiny``` **OR** ```gmtiny``` may be set. | floating point (ex. ```1e23```)                                       | all                    | Python only |

In the above list, the following are defined as:
- ```HELIO``` - Use the heliocentric coordinate frame.
- ```BARY``` - Use the barycentric coordinate frame.
- ```XV``` - Heliocentric position and velocity components.
- ```EL``` - Osculating orbital elements.
- ```XVEL``` - Heliocentric position and velocity components and osculating orbital elements.
- ```NETCDF_FLOAT``` - Single precision NetCDF format.
- ```NETCDF_DOUBLE``` - Double precision NetCDF format.
- ```REAL4``` - Single precision 4-byte native Fortran binary format (Swifter/Swift only)
- ```REAL8``` - Double precision 8-byte native Fortran binary format (Swifter/Swift only)
- ```XDR4``` - Single precision 4-byte XDR format (Swifter/Swift only)
- ```XDR8``` - Double precision 8-byte XDR format (Swifter/Swift only)
- ```TRAJECTORY``` - Save the position and velocity vectors of all bodies involved in the close encounter at each intermediary step of the encounter
- ```CLOSEST``` - Save the position and velocity vectors of all bodies involved in the close encounter at the point of closest approach 
- ```MERGE``` - Perfectly conserve the mass of all colliding bodies into a single resultant body
- ```BOUNCE``` - Perfectly-elastic collision in which all bodies reverse trajectory after the collision
- ```FRAGGLE``` - Collisional fragments are generated as a result of a collision
- ```NFRAG_REDUCTION``` - Based on the SFD defined in Leinhardt & Stewart (2012), Fraggle dictates that ```N``` fragments be generated between the mass of the second largest remnant and ```MIN_GMFRAG```, with the maximum value of ```N``` being ```3000```. To improve performance, this number can be reduced by ```N / NFRAG_REDUCTION```.

For more details on the ```INTERACTION_LOOPS``` and ```ENCOUNTER_CHECK``` options, see the **Updates to Swifter SyMBA** section.