# 📐 shapes_geometry

`shapes_geometry` is a lightweight Python package for performing geometry calculations for common 2D and 3D shapes. It provides simple functions to compute area, perimeter, volume, surface area, and other geometric properties — perfect for students, educators, and developers building math-related tools.

---

## ✨ Features

- 📏 **2D Shapes:** Circle, Triangle, Square, Rectangle, Parallelogram, Rhombus, Trapezium, Kite, Semicircle, Regular Polygons (Pentagon, Hexagon, Octagon, Decagon)
- 📦 **3D Shapes:** Sphere, Cube, Cuboid, Cone, Cylinder
- 🧠 Simple API with functional structure (no classes)
- 🛠️ Easy to extend and integrate into other Python projects

---

## 🚀 Installation

```bash
pip install shapes-geometry
```

## Example Usage 

```bash
from shapes_geometry.shapes import circle, square, rectangle

print(circle.area(5))           # Output: 78.53981633974483
print(square.perimeter(4))      # Output: 16
print(rectangle.area(10, 5))    # Output: 50
```
