# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import dumps
from sys import version_info
from typing import Any, Dict, Optional, Union
from urllib.parse import quote

from pydantic import Field, StrictInt, StrictStr
from typing_extensions import Annotated

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self

from algoliasearch.abtesting.config import AbtestingConfig
from algoliasearch.abtesting.models import (
    ABTest,
    ABTestResponse,
    AddABTestsRequest,
    EstimateABTestRequest,
    EstimateABTestResponse,
    ListABTestsResponse,
    ScheduleABTestResponse,
    ScheduleABTestsRequest,
)
from algoliasearch.http.api_response import ApiResponse
from algoliasearch.http.base_config import BaseConfig
from algoliasearch.http.request_options import RequestOptions
from algoliasearch.http.serializer import body_serializer
from algoliasearch.http.transporter import Transporter
from algoliasearch.http.transporter_sync import TransporterSync
from algoliasearch.http.verb import Verb


class AbtestingClient:
    """The Algolia 'AbtestingClient' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("de" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = AbtestingClient("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")
    _client_with_named_args = AbtestingClient(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")

    See `AbtestingClient.create_with_config` for advanced configuration.
    """

    _transporter: Transporter
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: Optional[str] = None,
        transporter: Optional[Transporter] = None,
        config: Optional[AbtestingConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = AbtestingConfig(
                transporter.config.app_id, transporter.config.api_key, region
            )
        elif config is None:
            config = AbtestingConfig(app_id, api_key, region)

        config.set_default_hosts()

        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = Transporter(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls, config: AbtestingConfig, transporter: Optional[Transporter] = None
    ) -> AbtestingClient:
        """Allows creating a client with a customized `AbtestingConfig` and `Transporter`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (AbtestingConfig): The config of the API client.
        transporter (Transporter): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = AbtestingClient.create_with_config(config=AbtestingConfig(...))
        _client_with_custom_config_and_transporter = AbtestingClient.create_with_config(config=AbtestingConfig(...), transporter=Transporter(...))
        """
        if transporter is None:
            transporter = Transporter(config)

        client = AbtestingClient(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

        return client

    async def __aenter__(self) -> Self:
        return self

    async def __aexit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        await self.close()

    async def close(self) -> None:
        """Closes the underlying `transporter` of the API client."""
        return await self._transporter.close()

    async def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    async def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    async def add_ab_tests_with_http_info(
        self,
        add_ab_tests_request: Union[AddABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Creates a new A/B test.

        Required API Key ACLs:
          - editSettings

        :param add_ab_tests_request: (required)
        :type add_ab_tests_request: AddABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if add_ab_tests_request is None:
            raise ValueError(
                "Parameter `add_ab_tests_request` is required when calling `add_ab_tests`."
            )

        _data = {}
        if add_ab_tests_request is not None:
            _data = add_ab_tests_request

        return await self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def add_ab_tests(
        self,
        add_ab_tests_request: Union[AddABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Creates a new A/B test.

        Required API Key ACLs:
          - editSettings

        :param add_ab_tests_request: (required)
        :type add_ab_tests_request: AddABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = await self.add_ab_tests_with_http_info(
            add_ab_tests_request, request_options
        )
        return resp.deserialize(ABTestResponse, resp.raw_data)

    async def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_delete_with_http_info(
            path, parameters, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    async def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_post_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_put_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def delete_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes an A/B test by its ID.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError(
                "Parameter `id` is required when calling `delete_ab_test`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/2/abtests/{id}".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Deletes an A/B test by its ID.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = await self.delete_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTestResponse, resp.raw_data)

    async def estimate_ab_test_with_http_info(
        self,
        estimate_ab_test_request: Union[EstimateABTestRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Given the traffic percentage and the expected effect size, this endpoint estimates the sample size and duration of an A/B test based on historical traffic.

        Required API Key ACLs:
          - analytics

        :param estimate_ab_test_request: (required)
        :type estimate_ab_test_request: EstimateABTestRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if estimate_ab_test_request is None:
            raise ValueError(
                "Parameter `estimate_ab_test_request` is required when calling `estimate_ab_test`."
            )

        _data = {}
        if estimate_ab_test_request is not None:
            _data = estimate_ab_test_request

        return await self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/estimate",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def estimate_ab_test(
        self,
        estimate_ab_test_request: Union[EstimateABTestRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> EstimateABTestResponse:
        """
        Given the traffic percentage and the expected effect size, this endpoint estimates the sample size and duration of an A/B test based on historical traffic.

        Required API Key ACLs:
          - analytics

        :param estimate_ab_test_request: (required)
        :type estimate_ab_test_request: EstimateABTestRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'EstimateABTestResponse' result object.
        """
        resp = await self.estimate_ab_test_with_http_info(
            estimate_ab_test_request, request_options
        )
        return resp.deserialize(EstimateABTestResponse, resp.raw_data)

    async def get_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves the details for an A/B test by its ID.

        Required API Key ACLs:
          - analytics

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError("Parameter `id` is required when calling `get_ab_test`.")

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/abtests/{id}".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTest:
        """
        Retrieves the details for an A/B test by its ID.

        Required API Key ACLs:
          - analytics

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTest' result object.
        """
        resp = await self.get_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTest, resp.raw_data)

    async def list_ab_tests_with_http_info(
        self,
        offset: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Position of the first item to return."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="Number of items to return.")
        ] = None,
        index_prefix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name prefix. Only A/B tests for indices starting with this string are included in the response."
            ),
        ] = None,
        index_suffix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name suffix. Only A/B tests for indices ending with this string are included in the response."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Lists all A/B tests you configured for this application.

        Required API Key ACLs:
          - analytics

        :param offset: Position of the first item to return.
        :type offset: int
        :param limit: Number of items to return.
        :type limit: int
        :param index_prefix: Index name prefix. Only A/B tests for indices starting with this string are included in the response.
        :type index_prefix: str
        :param index_suffix: Index name suffix. Only A/B tests for indices ending with this string are included in the response.
        :type index_suffix: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: Dict[str, Any] = {}

        if offset is not None:
            _query_parameters["offset"] = offset
        if limit is not None:
            _query_parameters["limit"] = limit
        if index_prefix is not None:
            _query_parameters["indexPrefix"] = index_prefix
        if index_suffix is not None:
            _query_parameters["indexSuffix"] = index_suffix

        return await self._transporter.request(
            verb=Verb.GET,
            path="/2/abtests",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def list_ab_tests(
        self,
        offset: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Position of the first item to return."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="Number of items to return.")
        ] = None,
        index_prefix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name prefix. Only A/B tests for indices starting with this string are included in the response."
            ),
        ] = None,
        index_suffix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name suffix. Only A/B tests for indices ending with this string are included in the response."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListABTestsResponse:
        """
        Lists all A/B tests you configured for this application.

        Required API Key ACLs:
          - analytics

        :param offset: Position of the first item to return.
        :type offset: int
        :param limit: Number of items to return.
        :type limit: int
        :param index_prefix: Index name prefix. Only A/B tests for indices starting with this string are included in the response.
        :type index_prefix: str
        :param index_suffix: Index name suffix. Only A/B tests for indices ending with this string are included in the response.
        :type index_suffix: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListABTestsResponse' result object.
        """
        resp = await self.list_ab_tests_with_http_info(
            offset, limit, index_prefix, index_suffix, request_options
        )
        return resp.deserialize(ListABTestsResponse, resp.raw_data)

    async def schedule_ab_test_with_http_info(
        self,
        schedule_ab_tests_request: Union[ScheduleABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Schedule an A/B test to be started at a later time.

        Required API Key ACLs:
          - editSettings

        :param schedule_ab_tests_request: (required)
        :type schedule_ab_tests_request: ScheduleABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if schedule_ab_tests_request is None:
            raise ValueError(
                "Parameter `schedule_ab_tests_request` is required when calling `schedule_ab_test`."
            )

        _data = {}
        if schedule_ab_tests_request is not None:
            _data = schedule_ab_tests_request

        return await self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/schedule",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def schedule_ab_test(
        self,
        schedule_ab_tests_request: Union[ScheduleABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ScheduleABTestResponse:
        """
        Schedule an A/B test to be started at a later time.

        Required API Key ACLs:
          - editSettings

        :param schedule_ab_tests_request: (required)
        :type schedule_ab_tests_request: ScheduleABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ScheduleABTestResponse' result object.
        """
        resp = await self.schedule_ab_test_with_http_info(
            schedule_ab_tests_request, request_options
        )
        return resp.deserialize(ScheduleABTestResponse, resp.raw_data)

    async def stop_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Stops an A/B test by its ID.  You can't restart stopped A/B tests.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError("Parameter `id` is required when calling `stop_ab_test`.")

        return await self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/{id}/stop".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def stop_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Stops an A/B test by its ID.  You can't restart stopped A/B tests.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = await self.stop_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTestResponse, resp.raw_data)


class AbtestingClientSync:
    """The Algolia 'AbtestingClientSync' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("de" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = AbtestingClientSync("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")
    _client_with_named_args = AbtestingClientSync(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'de' or 'us'")

    See `AbtestingClientSync.create_with_config` for advanced configuration.
    """

    _transporter: TransporterSync
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: Optional[str] = None,
        transporter: Optional[TransporterSync] = None,
        config: Optional[AbtestingConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = AbtestingConfig(
                transporter.config.app_id, transporter.config.api_key, region
            )
        elif config is None:
            config = AbtestingConfig(app_id, api_key, region)

        config.set_default_hosts()

        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = TransporterSync(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls, config: AbtestingConfig, transporter: Optional[TransporterSync] = None
    ) -> AbtestingClientSync:
        """Allows creating a client with a customized `AbtestingConfig` and `TransporterSync`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (AbtestingConfig): The config of the API client.
        transporter (TransporterSync): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = AbtestingClientSync.create_with_config(config=AbtestingConfig(...))
        _client_with_custom_config_and_transporter = AbtestingClientSync.create_with_config(config=AbtestingConfig(...), transporter=TransporterSync(...))
        """
        if transporter is None:
            transporter = TransporterSync(config)

        client = AbtestingClientSync(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

        return client

    def __enter__(self) -> Self:
        return self

    def __exit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        self.close()

    def close(self) -> None:
        return self._transporter.close()

    def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    def add_ab_tests_with_http_info(
        self,
        add_ab_tests_request: Union[AddABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Creates a new A/B test.

        Required API Key ACLs:
          - editSettings

        :param add_ab_tests_request: (required)
        :type add_ab_tests_request: AddABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if add_ab_tests_request is None:
            raise ValueError(
                "Parameter `add_ab_tests_request` is required when calling `add_ab_tests`."
            )

        _data = {}
        if add_ab_tests_request is not None:
            _data = add_ab_tests_request

        return self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def add_ab_tests(
        self,
        add_ab_tests_request: Union[AddABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Creates a new A/B test.

        Required API Key ACLs:
          - editSettings

        :param add_ab_tests_request: (required)
        :type add_ab_tests_request: AddABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = self.add_ab_tests_with_http_info(add_ab_tests_request, request_options)
        return resp.deserialize(ABTestResponse, resp.raw_data)

    def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_delete_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_post_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_put_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def delete_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes an A/B test by its ID.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError(
                "Parameter `id` is required when calling `delete_ab_test`."
            )

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/2/abtests/{id}".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def delete_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Deletes an A/B test by its ID.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = self.delete_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTestResponse, resp.raw_data)

    def estimate_ab_test_with_http_info(
        self,
        estimate_ab_test_request: Union[EstimateABTestRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Given the traffic percentage and the expected effect size, this endpoint estimates the sample size and duration of an A/B test based on historical traffic.

        Required API Key ACLs:
          - analytics

        :param estimate_ab_test_request: (required)
        :type estimate_ab_test_request: EstimateABTestRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if estimate_ab_test_request is None:
            raise ValueError(
                "Parameter `estimate_ab_test_request` is required when calling `estimate_ab_test`."
            )

        _data = {}
        if estimate_ab_test_request is not None:
            _data = estimate_ab_test_request

        return self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/estimate",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def estimate_ab_test(
        self,
        estimate_ab_test_request: Union[EstimateABTestRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> EstimateABTestResponse:
        """
        Given the traffic percentage and the expected effect size, this endpoint estimates the sample size and duration of an A/B test based on historical traffic.

        Required API Key ACLs:
          - analytics

        :param estimate_ab_test_request: (required)
        :type estimate_ab_test_request: EstimateABTestRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'EstimateABTestResponse' result object.
        """
        resp = self.estimate_ab_test_with_http_info(
            estimate_ab_test_request, request_options
        )
        return resp.deserialize(EstimateABTestResponse, resp.raw_data)

    def get_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves the details for an A/B test by its ID.

        Required API Key ACLs:
          - analytics

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError("Parameter `id` is required when calling `get_ab_test`.")

        return self._transporter.request(
            verb=Verb.GET,
            path="/2/abtests/{id}".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTest:
        """
        Retrieves the details for an A/B test by its ID.

        Required API Key ACLs:
          - analytics

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTest' result object.
        """
        resp = self.get_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTest, resp.raw_data)

    def list_ab_tests_with_http_info(
        self,
        offset: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Position of the first item to return."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="Number of items to return.")
        ] = None,
        index_prefix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name prefix. Only A/B tests for indices starting with this string are included in the response."
            ),
        ] = None,
        index_suffix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name suffix. Only A/B tests for indices ending with this string are included in the response."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Lists all A/B tests you configured for this application.

        Required API Key ACLs:
          - analytics

        :param offset: Position of the first item to return.
        :type offset: int
        :param limit: Number of items to return.
        :type limit: int
        :param index_prefix: Index name prefix. Only A/B tests for indices starting with this string are included in the response.
        :type index_prefix: str
        :param index_suffix: Index name suffix. Only A/B tests for indices ending with this string are included in the response.
        :type index_suffix: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        _query_parameters: Dict[str, Any] = {}

        if offset is not None:
            _query_parameters["offset"] = offset
        if limit is not None:
            _query_parameters["limit"] = limit
        if index_prefix is not None:
            _query_parameters["indexPrefix"] = index_prefix
        if index_suffix is not None:
            _query_parameters["indexSuffix"] = index_suffix

        return self._transporter.request(
            verb=Verb.GET,
            path="/2/abtests",
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def list_ab_tests(
        self,
        offset: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Position of the first item to return."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="Number of items to return.")
        ] = None,
        index_prefix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name prefix. Only A/B tests for indices starting with this string are included in the response."
            ),
        ] = None,
        index_suffix: Annotated[
            Optional[StrictStr],
            Field(
                description="Index name suffix. Only A/B tests for indices ending with this string are included in the response."
            ),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ListABTestsResponse:
        """
        Lists all A/B tests you configured for this application.

        Required API Key ACLs:
          - analytics

        :param offset: Position of the first item to return.
        :type offset: int
        :param limit: Number of items to return.
        :type limit: int
        :param index_prefix: Index name prefix. Only A/B tests for indices starting with this string are included in the response.
        :type index_prefix: str
        :param index_suffix: Index name suffix. Only A/B tests for indices ending with this string are included in the response.
        :type index_suffix: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ListABTestsResponse' result object.
        """
        resp = self.list_ab_tests_with_http_info(
            offset, limit, index_prefix, index_suffix, request_options
        )
        return resp.deserialize(ListABTestsResponse, resp.raw_data)

    def schedule_ab_test_with_http_info(
        self,
        schedule_ab_tests_request: Union[ScheduleABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Schedule an A/B test to be started at a later time.

        Required API Key ACLs:
          - editSettings

        :param schedule_ab_tests_request: (required)
        :type schedule_ab_tests_request: ScheduleABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if schedule_ab_tests_request is None:
            raise ValueError(
                "Parameter `schedule_ab_tests_request` is required when calling `schedule_ab_test`."
            )

        _data = {}
        if schedule_ab_tests_request is not None:
            _data = schedule_ab_tests_request

        return self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/schedule",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def schedule_ab_test(
        self,
        schedule_ab_tests_request: Union[ScheduleABTestsRequest, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ScheduleABTestResponse:
        """
        Schedule an A/B test to be started at a later time.

        Required API Key ACLs:
          - editSettings

        :param schedule_ab_tests_request: (required)
        :type schedule_ab_tests_request: ScheduleABTestsRequest
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ScheduleABTestResponse' result object.
        """
        resp = self.schedule_ab_test_with_http_info(
            schedule_ab_tests_request, request_options
        )
        return resp.deserialize(ScheduleABTestResponse, resp.raw_data)

    def stop_ab_test_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Stops an A/B test by its ID.  You can't restart stopped A/B tests.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if id is None:
            raise ValueError("Parameter `id` is required when calling `stop_ab_test`.")

        return self._transporter.request(
            verb=Verb.POST,
            path="/2/abtests/{id}/stop".replace("{id}", quote(str(id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def stop_ab_test(
        self,
        id: Annotated[StrictInt, Field(description="Unique A/B test identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ABTestResponse:
        """
        Stops an A/B test by its ID.  You can't restart stopped A/B tests.

        Required API Key ACLs:
          - editSettings

        :param id: Unique A/B test identifier. (required)
        :type id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ABTestResponse' result object.
        """
        resp = self.stop_ab_test_with_http_info(id, request_options)
        return resp.deserialize(ABTestResponse, resp.raw_data)
