# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.abtesting_v3.models.metric_metadata import MetricMetadata

_ALIASES = {
    "name": "name",
    "updated_at": "updatedAt",
    "value": "value",
    "value_ci_high": "valueCIHigh",
    "value_ci_low": "valueCILow",
    "p_value": "pValue",
    "dimension": "dimension",
    "metadata": "metadata",
    "critical_value": "criticalValue",
    "significant": "significant",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class MetricResult(BaseModel):
    """
    MetricResult
    """

    name: str
    updated_at: str
    """ Date and time when the metric was last updated, in RFC 3339 format. """
    value: float
    value_ci_high: Optional[float] = None
    """ The upper bound of the 95% confidence interval for the metric value. The confidence interval is calculated using either the relative ratio or relative difference between the metric values for the control and the variant. Relative ratio is used for metrics that are ratios (e.g., click-through rate, conversion rate), while relative difference is used for continuous metrics (e.g., revenue).  """
    value_ci_low: Optional[float] = None
    """ The lower bound of the 95% confidence interval for the metric value. The confidence interval is calculated using either the relative ratio or relative difference between the metric values for the control and the variant. Relative ratio is used for metrics that are ratios (e.g., click-through rate, conversion rate), while relative difference is used for continuous metrics (e.g., revenue).  """
    p_value: float
    """ PValue for the first variant (control) will always be 0. For the other variants, pValue is calculated for the current variant based on the control. """
    dimension: Optional[str] = None
    """ Dimension defined during test creation. """
    metadata: Optional[MetricMetadata] = None
    critical_value: Optional[float] = None
    """ The value that was computed during error correction. It is used to determine significance of the metric pValue. The critical value is calculated using Bonferroni or Benjamini-Hochberg corrections, based on the given configuration during the A/B test creation.  """
    significant: Optional[bool] = None
    """ Whether the pValue is significant or not based on the critical value and the error correction algorithm used.  """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetricResult from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetricResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["metadata"] = (
            MetricMetadata.from_dict(obj["metadata"])
            if obj.get("metadata") is not None
            else None
        )

        return cls.model_validate(obj)
