# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.abtesting_v3.models.ab_test_configuration import ABTestConfiguration
from algoliasearch.abtesting_v3.models.add_ab_tests_variant import AddABTestsVariant
from algoliasearch.abtesting_v3.models.create_metric import CreateMetric

_ALIASES = {
    "name": "name",
    "variants": "variants",
    "metrics": "metrics",
    "configuration": "configuration",
    "scheduled_at": "scheduledAt",
    "end_at": "endAt",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class ScheduleABTestsRequest(BaseModel):
    """
    ScheduleABTestsRequest
    """

    name: str
    """ A/B test name. """
    variants: List[AddABTestsVariant]
    """ A/B test variants. """
    metrics: List[CreateMetric]
    """ A/B test metrics involved in the test. Only these metrics will be considered when calculating results. """
    configuration: Optional[ABTestConfiguration] = None
    scheduled_at: str
    """ Date and time when the A/B test is scheduled to start, in RFC 3339 format. """
    end_at: str
    """ End date and time of the A/B test, in RFC 3339 format. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScheduleABTestsRequest from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScheduleABTestsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["variants"] = (
            [AddABTestsVariant.from_dict(_item) for _item in obj["variants"]]
            if obj.get("variants") is not None
            else None
        )
        obj["metrics"] = (
            [CreateMetric.from_dict(_item) for _item in obj["metrics"]]
            if obj.get("metrics") is not None
            else None
        )
        obj["configuration"] = (
            ABTestConfiguration.from_dict(obj["configuration"])
            if obj.get("configuration") is not None
            else None
        )

        return cls.model_validate(obj)
