# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.abtesting_v3.models.metric_result import MetricResult
from algoliasearch.abtesting_v3.models.variant_metadata import VariantMetadata

_ALIASES = {
    "description": "description",
    "estimated_sample_size": "estimatedSampleSize",
    "index": "index",
    "traffic_percentage": "trafficPercentage",
    "metrics": "metrics",
    "metadata": "metadata",
    "custom_search_parameters": "customSearchParameters",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Variant(BaseModel):
    """
    Variant
    """

    description: str
    """ Description for this variant. """
    estimated_sample_size: Optional[int] = None
    """ Estimated number of searches required to achieve the desired statistical significance.  The A/B test configuration must include a `minimumDetectableEffect` setting for this number to be included in the response.  """
    index: str
    """ Index name of the A/B test variant (case-sensitive). """
    traffic_percentage: int
    """ Percentage of search requests each variant receives. """
    metrics: List[MetricResult]
    """ All ABTest metrics that were defined during test creation. """
    metadata: Optional[VariantMetadata] = None
    custom_search_parameters: Optional[object] = None
    """ Search parameters applied to this variant when the same index is used for multiple variants. Only present if custom search parameters were provided during test creation.  """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Variant from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Variant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["metrics"] = (
            [MetricResult.from_dict(_item) for _item in obj["metrics"]]
            if obj.get("metrics") is not None
            else None
        )
        obj["metadata"] = (
            VariantMetadata.from_dict(obj["metadata"])
            if obj.get("metadata") is not None
            else None
        )

        return cls.model_validate(obj)
