# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.ingestion.models.event_status import EventStatus
from algoliasearch.ingestion.models.event_type import EventType

_ALIASES = {
    "event_id": "eventID",
    "run_id": "runID",
    "status": "status",
    "type": "type",
    "batch_size": "batchSize",
    "data": "data",
    "published_at": "publishedAt",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Event(BaseModel):
    """
    An event describe a step of the task execution flow..
    """

    event_id: str
    """ Universally unique identifier (UUID) of an event. """
    run_id: str
    """ Universally unique identifier (UUID) of a task run. """
    status: Union[EventStatus, None]
    type: EventType
    batch_size: int
    """ The extracted record batch size. """
    data: Optional[Dict[str, object]] = None
    published_at: str
    """ Date of publish RFC 3339 format. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Event from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Event from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["status"] = obj.get("status")
        obj["type"] = obj.get("type")

        return cls.model_validate(obj)
