# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.ingestion.models.run_outcome import RunOutcome
from algoliasearch.ingestion.models.run_progress import RunProgress
from algoliasearch.ingestion.models.run_reason_code import RunReasonCode
from algoliasearch.ingestion.models.run_status import RunStatus
from algoliasearch.ingestion.models.run_type import RunType

_ALIASES = {
    "run_id": "runID",
    "app_id": "appID",
    "task_id": "taskID",
    "status": "status",
    "progress": "progress",
    "outcome": "outcome",
    "failure_threshold": "failureThreshold",
    "reason": "reason",
    "reason_code": "reasonCode",
    "type": "type",
    "created_at": "createdAt",
    "started_at": "startedAt",
    "finished_at": "finishedAt",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Run(BaseModel):
    """
    Run
    """

    run_id: str
    """ Universally unique identifier (UUID) of a task run. """
    app_id: str
    task_id: str
    """ Universally unique identifier (UUID) of a task. """
    status: RunStatus
    progress: Optional[RunProgress] = None
    outcome: Optional[RunOutcome] = None
    failure_threshold: Optional[int] = None
    """ Maximum accepted percentage of failures for a task run to finish successfully. """
    reason: Optional[str] = None
    """ More information about the task run's outcome. """
    reason_code: Optional[RunReasonCode] = None
    type: RunType
    created_at: str
    """ Date of creation in RFC 3339 format. """
    started_at: Optional[str] = None
    """ Date of start in RFC 3339 format. """
    finished_at: Optional[str] = None
    """ Date of finish in RFC 3339 format. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Run from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Run from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["status"] = obj.get("status")
        obj["progress"] = (
            RunProgress.from_dict(obj["progress"])
            if obj.get("progress") is not None
            else None
        )
        obj["outcome"] = obj.get("outcome")
        obj["reasonCode"] = obj.get("reasonCode")
        obj["type"] = obj.get("type")

        return cls.model_validate(obj)
