# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.ingestion.models.authentication_create import AuthenticationCreate
from algoliasearch.ingestion.models.transformation_input import TransformationInput
from algoliasearch.ingestion.models.transformation_type import TransformationType

_ALIASES = {
    "code": "code",
    "type": "type",
    "input": "input",
    "sample_record": "sampleRecord",
    "authentications": "authentications",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class TransformationTry(BaseModel):
    """
    TransformationTry
    """

    code: Optional[str] = None
    """ It is deprecated. Use the `input` field with proper `type` instead to specify the transformation code. """
    type: Optional[TransformationType] = None
    input: Optional[TransformationInput] = None
    sample_record: object
    """ The record to apply the given code to. """
    authentications: Optional[List[AuthenticationCreate]] = None

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransformationTry from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransformationTry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["type"] = obj.get("type")
        obj["input"] = (
            TransformationInput.from_dict(obj["input"])
            if obj.get("input") is not None
            else None
        )
        obj["authentications"] = (
            [AuthenticationCreate.from_dict(_item) for _item in obj["authentications"]]
            if obj.get("authentications") is not None
            else None
        )

        return cls.model_validate(obj)
