# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import dumps
from sys import version_info
from typing import Any, Dict, List, Optional, Union
from urllib.parse import quote

from pydantic import Field, StrictStr
from typing_extensions import Annotated

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self

from algoliasearch.http.api_response import ApiResponse
from algoliasearch.http.base_config import BaseConfig
from algoliasearch.http.request_options import RequestOptions
from algoliasearch.http.serializer import body_serializer
from algoliasearch.http.transporter import Transporter
from algoliasearch.http.transporter_sync import TransporterSync
from algoliasearch.http.verb import Verb
from algoliasearch.query_suggestions.config import QuerySuggestionsConfig
from algoliasearch.query_suggestions.models import (
    BaseResponse,
    ConfigStatus,
    Configuration,
    ConfigurationResponse,
    ConfigurationWithIndex,
    LogFile,
)


class QuerySuggestionsClient:
    """The Algolia 'QuerySuggestionsClient' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("eu" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = QuerySuggestionsClient("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")
    _client_with_named_args = QuerySuggestionsClient(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")

    See `QuerySuggestionsClient.create_with_config` for advanced configuration.
    """

    _transporter: Transporter
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: str = "",
        transporter: Optional[Transporter] = None,
        config: Optional[QuerySuggestionsConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = QuerySuggestionsConfig(
                transporter.config.app_id, transporter.config.api_key, region
            )
        elif config is None:
            config = QuerySuggestionsConfig(app_id, api_key, region)

        config.set_default_hosts()

        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = Transporter(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls, config: QuerySuggestionsConfig, transporter: Optional[Transporter] = None
    ) -> QuerySuggestionsClient:
        """Allows creating a client with a customized `QuerySuggestionsConfig` and `Transporter`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (QuerySuggestionsConfig): The config of the API client.
        transporter (Transporter): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = QuerySuggestionsClient.create_with_config(config=QuerySuggestionsConfig(...))
        _client_with_custom_config_and_transporter = QuerySuggestionsClient.create_with_config(config=QuerySuggestionsConfig(...), transporter=Transporter(...))
        """
        if transporter is None:
            transporter = Transporter(config)

        client = QuerySuggestionsClient(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

        return client

    async def __aenter__(self) -> Self:
        return self

    async def __aexit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        await self.close()

    async def close(self) -> None:
        """Closes the underlying `transporter` of the API client."""
        return await self._transporter.close()

    async def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    async def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    async def create_config_with_http_info(
        self,
        configuration_with_index: Union[ConfigurationWithIndex, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Creates a new Query Suggestions configuration.  You can have up to 100 configurations per Algolia application.

        Required API Key ACLs:
          - editSettings

        :param configuration_with_index: (required)
        :type configuration_with_index: ConfigurationWithIndex
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if configuration_with_index is None:
            raise ValueError(
                "Parameter `configuration_with_index` is required when calling `create_config`."
            )

        _data = {}
        if configuration_with_index is not None:
            _data = configuration_with_index

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/configs",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def create_config(
        self,
        configuration_with_index: Union[ConfigurationWithIndex, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Creates a new Query Suggestions configuration.  You can have up to 100 configurations per Algolia application.

        Required API Key ACLs:
          - editSettings

        :param configuration_with_index: (required)
        :type configuration_with_index: ConfigurationWithIndex
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = await self.create_config_with_http_info(
            configuration_with_index, request_options
        )
        return resp.deserialize(BaseResponse, resp.raw_data)

    async def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_delete_with_http_info(
            path, parameters, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    async def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_post_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_put_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def delete_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes a Query Suggestions configuration.  Deleting only removes the configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the Search API and the `Delete an index` operation.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `delete_config`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Deletes a Query Suggestions configuration.  Deleting only removes the configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the Search API and the `Delete an index` operation.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = await self.delete_config_with_http_info(index_name, request_options)
        return resp.deserialize(BaseResponse, resp.raw_data)

    async def get_all_configs_with_http_info(
        self, request_options: Optional[Union[dict, RequestOptions]] = None
    ) -> ApiResponse[str]:
        """
        Retrieves all Query Suggestions configurations of your Algolia application.

        Required API Key ACLs:
          - settings

        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/configs",
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_all_configs(
        self, request_options: Optional[Union[dict, RequestOptions]] = None
    ) -> List[ConfigurationResponse]:
        """
        Retrieves all Query Suggestions configurations of your Algolia application.

        Required API Key ACLs:
          - settings

        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[ConfigurationResponse]' result object.
        """
        resp = await self.get_all_configs_with_http_info(request_options)
        return resp.deserialize(List[ConfigurationResponse], resp.raw_data)

    async def get_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves a single Query Suggestions configuration by its index name.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_config`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ConfigurationResponse:
        """
        Retrieves a single Query Suggestions configuration by its index name.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ConfigurationResponse' result object.
        """
        resp = await self.get_config_with_http_info(index_name, request_options)
        return resp.deserialize(ConfigurationResponse, resp.raw_data)

    async def get_config_status_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Reports the status of a Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_config_status`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/configs/{indexName}/status".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_config_status(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ConfigStatus:
        """
        Reports the status of a Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ConfigStatus' result object.
        """
        resp = await self.get_config_status_with_http_info(index_name, request_options)
        return resp.deserialize(ConfigStatus, resp.raw_data)

    async def get_log_file_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves the logs for a single Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_log_file`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/logs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_log_file(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> LogFile:
        """
        Retrieves the logs for a single Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'LogFile' result object.
        """
        resp = await self.get_log_file_with_http_info(index_name, request_options)
        return resp.deserialize(LogFile, resp.raw_data)

    async def update_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        configuration: Union[Configuration, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Updates a QuerySuggestions configuration.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param configuration: (required)
        :type configuration: Configuration
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `update_config`."
            )

        if configuration is None:
            raise ValueError(
                "Parameter `configuration` is required when calling `update_config`."
            )

        _data = {}
        if configuration is not None:
            _data = configuration

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def update_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        configuration: Union[Configuration, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Updates a QuerySuggestions configuration.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param configuration: (required)
        :type configuration: Configuration
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = await self.update_config_with_http_info(
            index_name, configuration, request_options
        )
        return resp.deserialize(BaseResponse, resp.raw_data)


class QuerySuggestionsClientSync:
    """The Algolia 'QuerySuggestionsClientSync' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.
    region ("eu" | "us"): The region of your Algolia application.

    Returns:
    The initialized API client.

    Example:
    _client = QuerySuggestionsClientSync("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")
    _client_with_named_args = QuerySuggestionsClientSync(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY", region="'eu' or 'us'")

    See `QuerySuggestionsClientSync.create_with_config` for advanced configuration.
    """

    _transporter: TransporterSync
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        region: str = "",
        transporter: Optional[TransporterSync] = None,
        config: Optional[QuerySuggestionsConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = QuerySuggestionsConfig(
                transporter.config.app_id, transporter.config.api_key, region
            )
        elif config is None:
            config = QuerySuggestionsConfig(app_id, api_key, region)

        config.set_default_hosts()

        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = TransporterSync(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls,
        config: QuerySuggestionsConfig,
        transporter: Optional[TransporterSync] = None,
    ) -> QuerySuggestionsClientSync:
        """Allows creating a client with a customized `QuerySuggestionsConfig` and `TransporterSync`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (QuerySuggestionsConfig): The config of the API client.
        transporter (TransporterSync): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = QuerySuggestionsClientSync.create_with_config(config=QuerySuggestionsConfig(...))
        _client_with_custom_config_and_transporter = QuerySuggestionsClientSync.create_with_config(config=QuerySuggestionsConfig(...), transporter=TransporterSync(...))
        """
        if transporter is None:
            transporter = TransporterSync(config)

        client = QuerySuggestionsClientSync(
            app_id=config.app_id,
            api_key=config.api_key,
            region=config.region,
            transporter=transporter,
            config=config,
        )

        return client

    def __enter__(self) -> Self:
        return self

    def __exit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        self.close()

    def close(self) -> None:
        return self._transporter.close()

    def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    def create_config_with_http_info(
        self,
        configuration_with_index: Union[ConfigurationWithIndex, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Creates a new Query Suggestions configuration.  You can have up to 100 configurations per Algolia application.

        Required API Key ACLs:
          - editSettings

        :param configuration_with_index: (required)
        :type configuration_with_index: ConfigurationWithIndex
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if configuration_with_index is None:
            raise ValueError(
                "Parameter `configuration_with_index` is required when calling `create_config`."
            )

        _data = {}
        if configuration_with_index is not None:
            _data = configuration_with_index

        return self._transporter.request(
            verb=Verb.POST,
            path="/1/configs",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def create_config(
        self,
        configuration_with_index: Union[ConfigurationWithIndex, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Creates a new Query Suggestions configuration.  You can have up to 100 configurations per Algolia application.

        Required API Key ACLs:
          - editSettings

        :param configuration_with_index: (required)
        :type configuration_with_index: ConfigurationWithIndex
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = self.create_config_with_http_info(
            configuration_with_index, request_options
        )
        return resp.deserialize(BaseResponse, resp.raw_data)

    def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_delete_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_post_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(description="Path of the endpoint, for example `1/newFeature`."),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method lets you send requests to the Algolia REST API.


        :param path: Path of the endpoint, for example `1/newFeature`. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_put_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def delete_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes a Query Suggestions configuration.  Deleting only removes the configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the Search API and the `Delete an index` operation.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `delete_config`."
            )

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def delete_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Deletes a Query Suggestions configuration.  Deleting only removes the configuration and stops updates to the Query Suggestions index. To delete the Query Suggestions index itself, use the Search API and the `Delete an index` operation.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = self.delete_config_with_http_info(index_name, request_options)
        return resp.deserialize(BaseResponse, resp.raw_data)

    def get_all_configs_with_http_info(
        self, request_options: Optional[Union[dict, RequestOptions]] = None
    ) -> ApiResponse[str]:
        """
        Retrieves all Query Suggestions configurations of your Algolia application.

        Required API Key ACLs:
          - settings

        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/configs",
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_all_configs(
        self, request_options: Optional[Union[dict, RequestOptions]] = None
    ) -> List[ConfigurationResponse]:
        """
        Retrieves all Query Suggestions configurations of your Algolia application.

        Required API Key ACLs:
          - settings

        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'List[ConfigurationResponse]' result object.
        """
        resp = self.get_all_configs_with_http_info(request_options)
        return resp.deserialize(List[ConfigurationResponse], resp.raw_data)

    def get_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves a single Query Suggestions configuration by its index name.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_config`."
            )

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ConfigurationResponse:
        """
        Retrieves a single Query Suggestions configuration by its index name.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ConfigurationResponse' result object.
        """
        resp = self.get_config_with_http_info(index_name, request_options)
        return resp.deserialize(ConfigurationResponse, resp.raw_data)

    def get_config_status_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Reports the status of a Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_config_status`."
            )

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/configs/{indexName}/status".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_config_status(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ConfigStatus:
        """
        Reports the status of a Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'ConfigStatus' result object.
        """
        resp = self.get_config_status_with_http_info(index_name, request_options)
        return resp.deserialize(ConfigStatus, resp.raw_data)

    def get_log_file_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves the logs for a single Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_log_file`."
            )

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/logs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_log_file(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> LogFile:
        """
        Retrieves the logs for a single Query Suggestions index.

        Required API Key ACLs:
          - settings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'LogFile' result object.
        """
        resp = self.get_log_file_with_http_info(index_name, request_options)
        return resp.deserialize(LogFile, resp.raw_data)

    def update_config_with_http_info(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        configuration: Union[Configuration, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Updates a QuerySuggestions configuration.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param configuration: (required)
        :type configuration: Configuration
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `update_config`."
            )

        if configuration is None:
            raise ValueError(
                "Parameter `configuration` is required when calling `update_config`."
            )

        _data = {}
        if configuration is not None:
            _data = configuration

        return self._transporter.request(
            verb=Verb.PUT,
            path="/1/configs/{indexName}".replace(
                "{indexName}", quote(str(index_name), safe="")
            ),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def update_config(
        self,
        index_name: Annotated[
            StrictStr, Field(description="Query Suggestions index name.")
        ],
        configuration: Union[Configuration, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> BaseResponse:
        """
        Updates a QuerySuggestions configuration.

        Required API Key ACLs:
          - editSettings

        :param index_name: Query Suggestions index name. (required)
        :type index_name: str
        :param configuration: (required)
        :type configuration: Configuration
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'BaseResponse' result object.
        """
        resp = self.update_config_with_http_info(
            index_name, configuration, request_options
        )
        return resp.deserialize(BaseResponse, resp.raw_data)
