# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.recommend.models.match_level import MatchLevel

_ALIASES = {
    "value": "value",
    "match_level": "matchLevel",
    "matched_words": "matchedWords",
    "fully_highlighted": "fullyHighlighted",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class HighlightResultOption(BaseModel):
    """
    Surround words that match the query with HTML tags for highlighting.
    """

    value: str
    """ Highlighted attribute value, including HTML tags. """
    match_level: MatchLevel
    matched_words: List[str]
    """ List of matched words from the search query. """
    fully_highlighted: Optional[bool] = None
    """ Whether the entire attribute value is highlighted. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HighlightResultOption from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HighlightResultOption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["matchLevel"] = obj.get("matchLevel")

        return cls.model_validate(obj)
