# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.dictionary_entry_state import DictionaryEntryState
from algoliasearch.search.models.dictionary_entry_type import DictionaryEntryType
from algoliasearch.search.models.supported_language import SupportedLanguage

_ALIASES = {
    "object_id": "objectID",
    "language": "language",
    "word": "word",
    "words": "words",
    "decomposition": "decomposition",
    "state": "state",
    "type": "type",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class DictionaryEntry(BaseModel):
    """
    Dictionary entry.
    """

    object_id: str
    """ Unique identifier for the dictionary entry. """
    language: Optional[SupportedLanguage] = None
    word: Optional[str] = None
    """ Matching dictionary word for `stopwords` and `compounds` dictionaries. """
    words: Optional[List[str]] = None
    """ Matching words in the `plurals` dictionary including declensions. """
    decomposition: Optional[List[str]] = None
    """ Invividual components of a compound word in the `compounds` dictionary. """
    state: Optional[DictionaryEntryState] = None
    type: Optional[DictionaryEntryType] = None

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DictionaryEntry from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DictionaryEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["language"] = obj.get("language")
        obj["state"] = obj.get("state")
        obj["type"] = obj.get("type")

        return cls.model_validate(obj)
