{% materialization table, adapter='depp', supported_languages=['python', 'sql'] -%}

{%- set language = model['language'] -%}

{%- if language == 'python' -%}


  {%- set relation = this.incorporate(type='table') -%}

  {%- call statement('main', language=language) -%}

    {{- py_write(compiled_code, relation) }}

  {%- endcall %}

{{- return({'relations': [relation]}) }}

{%- elif language == 'sql' -%}

  {# HACK: proxy to the db adapter table materialization #}
  {{- return(adapter.db_materialization(context, "table")) }}

{%- endif -%}

{% endmaterialization %}

{% macro py_write(code, relation) -%}
{{- compiled_code -}}

# Generated by dbt-depp

def main(read_df, write_df, fal_context=None):
  dbt_context = dbtObj(read_df)
  df = model(dbt_context, fal_context)
  return write_df(
      '{{ relation.quote(False, False, False) }}',
      df
  )
{%- endmacro %}
