import numpy as np

class linearRegression:

    def __init__(self):
        self.coefficient = None  
        self.intercept = None  
        
    def fit(self, X, y):
        X = np.array(X)
        y = np.array(y)

        X_mean = np.mean(X)
        y_mean = np.mean(y)

        numerator = np.sum((X - X_mean) * (y - y_mean))
        denominator = np.sum((X - X_mean) ** 2)
        self.coefficient = numerator / denominator
        
        self.intercept = y_mean - (self.coefficient * X_mean)
    
    def predict(self, X):

        X = np.array(X)
        return self.intercept + self.coefficient * X

    def get_params(self):

        return self.coefficient, self.intercept

    def __str__(self):
        return f"y = {self.coefficient:.3f}x + {self.intercept:.3f}"
