import pyEDAA.ProjectModel as pm

from pathlib import Path
from typing import Optional
from pyTooling.MetaClasses import ExtendedType
from .attributes import Encrypt, UsedIn, SIMULATION, IMPLEMENTATION, Scope


class FileMixIn(metaclass=ExtendedType, mixin=True):
    def _registerAttributes(self):
        self._attributes[UsedIn] = {SIMULATION, IMPLEMENTATION}


class File(pm.File, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class SourceFile(pm.SourceFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class HDLLibrary(pm.VHDLLibrary):
    pass


class HDLIncludeFile(SourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[UsedIn] = {SIMULATION, IMPLEMENTATION}


class HDLSearchPath(HDLIncludeFile):
    pass


class HDLSourceFile(pm.HDLSourceFile, FileMixIn):
    _library: HDLLibrary

    def __init__(self,
                 path: Path = None, project: pm.Project = None,
                 design: pm.Design = None, fileset: pm.FileSet = None,
                 library: Optional[HDLLibrary] = None):
        super().__init__(path, project, design, fileset)
        self._library = library

    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {SIMULATION, IMPLEMENTATION}
        self[Encrypt] = True

    @property
    def Library(self) -> HDLLibrary:
        if self._library is not None:
            return self._library
        elif self.FileSet.VHDLLibrary is not None:
            return self.FileSet.VHDLLibrary

    @Library.setter
    def Library(self, value) -> None:
        self._library = value


class VerilogIncludeSearchPath(HDLSearchPath):
    pass


class VerilogIncludeFile(HDLIncludeFile, pm.HumanReadableContent):
    pass


class VerilogSourceFile(HDLSourceFile, pm.HumanReadableContent):
    pass


class SystemVerilogSourceFile(HDLSourceFile, pm.HumanReadableContent):
    pass


class VHDLSourceFile(HDLSourceFile, pm.HumanReadableContent):
    pass


class VerilogIncludeEncryptedFile(VerilogIncludeFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[Encrypt] = False


class VerilogEncryptedSourceFile(VerilogSourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[Encrypt] = False


class SystemVerilogEncryptedSourceFile(SystemVerilogSourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[Encrypt] = False


class VHDLEncryptedSourceFile(VHDLSourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[Encrypt] = False


class PythonSourceFile(pm.PythonSourceFile):
    pass


class CocotbPythonFile(PythonSourceFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {SIMULATION}


class TCLSourceFile(pm.TCLSourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class IPSpecificationFile(File, pm.XMLContent):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class NetlistFile(pm.NetlistFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class EDIFNetlistFile(pm.EDIFNetlistFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class CHeaderFile(SourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[UsedIn] = {SIMULATION}


class CSourceFile(pm.CSourceFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {SIMULATION}


class SystemCSourceFile(CSourceFile):
    pass


class SystemCHeaderFile(CHeaderFile):
    pass


class SettingFile(pm.SettingFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class ConstraintFile(pm.ConstraintFile, FileMixIn):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {IMPLEMENTATION}
        self[Scope] = None


class QuartusSignalTapFile(File):
    def _registerAttributes(self):
        super()._registerAttributes()
        self[UsedIn] = {IMPLEMENTATION}


class QuartusIPSpecificationFile(IPSpecificationFile):
    pass


class QuartusIPCompressedSpecificationFile(QuartusIPSpecificationFile):
    pass


class QuartusQSYSSpecificationFile(QuartusIPSpecificationFile):
    pass


class QuartusQSYSCompressedSpecificationFile(QuartusQSYSSpecificationFile):
    pass


class QuartusQIPSpecificationFile(QuartusIPSpecificationFile):
    pass


class QuartusIniFile(File):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {IMPLEMENTATION}


class QuartusSourceTCLFile(TCLSourceFile):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {IMPLEMENTATION}


class VivadoIPSpecificationFile(IPSpecificationFile):
    pass


class VivadoBDTclFile(TCLSourceFile):
    pass


class VivadoProjectStepFile(TCLSourceFile):
    pass


class SystemRDLSourceFile(File):
    pass


class ScalaBuildFile(File):
    pass


class ChiselBuildFile(ScalaBuildFile):
    pass


class MemoryInitFile(File):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)


class ModelsimIniFile(File):
    def _registerAttributes(self):
        super()._registerAttributes()
        FileMixIn._registerAttributes(self)
        self[UsedIn] = {SIMULATION}
