# Units

This document contains a list of units that are available in the Cognite Fusion platform. It was last generated 2024-12-06.
For the most up-to-date list of units, please refer to the [units catalog](https://raw.githubusercontent.com/cognitedata/units-catalog/main/versions/v1/units.json).


## API Gravity

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| api_gravity:degree_api | DEGREE_API | Degree API | °API | [https://qudt.org/vocab/unit/DEGREE_API](https://qudt.org/vocab/unit/DEGREE_API) |
| api_gravity:kilo_degree_api | KILO_DEGREE_API | Kilo Degree API | k °API |  |


## Acceleration

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| acceleration:ft-per-sec2 | FT-PER-SEC2 | Foot per Square Second | ft/s² | [https://qudt.org/vocab/unit/FT-PER-SEC2](https://qudt.org/vocab/unit/FT-PER-SEC2) |
| acceleration:in-per-sec2 | IN-PER-SEC2 | Inch per Square second | in/s² | [https://qudt.org/vocab/unit/IN-PER-SEC2](https://qudt.org/vocab/unit/IN-PER-SEC2) |
| acceleration:m-per-sec2 | M-PER-SEC2 | Meter per Square Second | m/s² | [https://qudt.org/vocab/unit/M-PER-SEC2](https://qudt.org/vocab/unit/M-PER-SEC2) |


## Amount Of Substance

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| amount_of_substance:centimol | CentiMOL | CentiMole | cmol | [https://qudt.org/vocab/unit/CentiMOL](https://qudt.org/vocab/unit/CentiMOL) |
| amount_of_substance:kilomol | KiloMOL | Kilomole | kmol | [https://qudt.org/vocab/unit/KiloMOL](https://qudt.org/vocab/unit/KiloMOL) |
| amount_of_substance:micromol | MicroMOL | Micromole | μmol | [https://qudt.org/vocab/unit/MicroMOL](https://qudt.org/vocab/unit/MicroMOL) |
| amount_of_substance:millimol | MilliMOL | Millimole | mmol | [https://qudt.org/vocab/unit/MilliMOL](https://qudt.org/vocab/unit/MilliMOL) |
| amount_of_substance:mol | MOL | mole | mol | [https://qudt.org/vocab/unit/MOL](https://qudt.org/vocab/unit/MOL) |


## Amount Of Substance Per Unit Volume

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| amount_of_substance_per_unit_volume:centimol-per-l | CentiMOL-PER-L | Centimole per litre | cmol/L | [https://qudt.org/vocab/unit/CentiMOL-PER-L](https://qudt.org/vocab/unit/CentiMOL-PER-L) |
| amount_of_substance_per_unit_volume:kilomol-per-m3 | KiloMOL-PER-M3 | Kilomole Per Cubic Meter | kmol/m³ | [https://qudt.org/vocab/unit/KiloMOL-PER-M3](https://qudt.org/vocab/unit/KiloMOL-PER-M3) |
| amount_of_substance_per_unit_volume:micromol-per-l | MicroMOL-PER-L | Micromoles per litre | µmol/L | [https://qudt.org/vocab/unit/MicroMOL-PER-L](https://qudt.org/vocab/unit/MicroMOL-PER-L) |
| amount_of_substance_per_unit_volume:millimol-per-l | MilliMOL-PER-L | millimoles per litre | mmol/L | [https://qudt.org/vocab/unit/MilliMOL-PER-L](https://qudt.org/vocab/unit/MilliMOL-PER-L) |
| amount_of_substance_per_unit_volume:millimol-per-m3 | MilliMOL-PER-M3 | Millimoles per cubic metre | mmol/m³ | [https://qudt.org/vocab/unit/MilliMOL-PER-M3](https://qudt.org/vocab/unit/MilliMOL-PER-M3) |
| amount_of_substance_per_unit_volume:mol-per-decim3 | MOL-PER-DeciM3 | Mole Per Cubic Decimeter | mol/dm³ | [https://qudt.org/vocab/unit/MOL-PER-DeciM3](https://qudt.org/vocab/unit/MOL-PER-DeciM3) |
| amount_of_substance_per_unit_volume:mol-per-l | MOL-PER-L | Mole Per Liter | mol/L | [https://qudt.org/vocab/unit/MOL-PER-L](https://qudt.org/vocab/unit/MOL-PER-L) |
| amount_of_substance_per_unit_volume:mol-per-m3 | MOL-PER-M3 | Mole per Cubic Meter | mol/m³ | [https://qudt.org/vocab/unit/MOL-PER-M3](https://qudt.org/vocab/unit/MOL-PER-M3) |


## Angle

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| angle:deg | DEG | Degree | ° | [https://qudt.org/vocab/unit/DEG](https://qudt.org/vocab/unit/DEG) |
| angle:grad | GRAD | Grad | grad | [https://qudt.org/vocab/unit/GRAD](https://qudt.org/vocab/unit/GRAD) |
| angle:microrad | MicroRAD | microradian | µrad | [https://qudt.org/vocab/unit/MicroRAD](https://qudt.org/vocab/unit/MicroRAD) |
| angle:millirad | MilliRAD | milliradian | mrad | [https://qudt.org/vocab/unit/MilliRAD](https://qudt.org/vocab/unit/MilliRAD) |
| angle:rad | RAD | radian | rad | [https://qudt.org/vocab/unit/RAD](https://qudt.org/vocab/unit/RAD) |
| angle:rev | REV | Revolution | rev | [https://qudt.org/vocab/unit/REV](https://qudt.org/vocab/unit/REV) |


## Angle Per Length

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| angle_per_length:deg-per-m | DEG-PER-M | Degrees Per Meter | deg/m | [https://qudt.org/vocab/unit/DEG-PER-M](https://qudt.org/vocab/unit/DEG-PER-M) |
| angle_per_length:rad-per-ft | RAD-PER-FT | Radians Per Foot | rad/ft | [https://www.energistics.org/energistics-unit-of-measure-standard](https://www.energistics.org/energistics-unit-of-measure-standard) |
| angle_per_length:rad-per-m | RAD-PER-M | Radians Per Meter | rad/m | [https://qudt.org/vocab/unit/RAD-PER-M](https://qudt.org/vocab/unit/RAD-PER-M) |


## Angular Acceleration

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| angular_acceleration:rev-per-sec2 | REV-PER-SEC2 | Revolution per Square Second | rev/s² | [https://qudt.org/vocab/unit/REV-PER-SEC2](https://qudt.org/vocab/unit/REV-PER-SEC2) |


## Angular Velocity

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| angular_velocity:rev-per-hr | REV-PER-HR | Revolution per Hour | rev/h | [https://qudt.org/vocab/unit/REV-PER-HR](https://qudt.org/vocab/unit/REV-PER-HR) |
| angular_velocity:rev-per-min | REV-PER-MIN | Revolution per Minute | rev/min | [https://qudt.org/vocab/unit/REV-PER-MIN](https://qudt.org/vocab/unit/REV-PER-MIN) |
| angular_velocity:rev-per-sec | REV-PER-SEC | Revolution per Second | rev/s | [https://qudt.org/vocab/unit/REV-PER-SEC](https://qudt.org/vocab/unit/REV-PER-SEC) |


## Area

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| area:centim2 | CentiM2 | Square Centimeter | cm² | [https://qudt.org/vocab/unit/CentiM2](https://qudt.org/vocab/unit/CentiM2) |
| area:decim2 | DeciM2 | Square Decimeter | dm² | [https://qudt.org/vocab/unit/DeciM2](https://qudt.org/vocab/unit/DeciM2) |
| area:ft2 | FT2 | Square Foot | ft² | [https://qudt.org/vocab/unit/FT2](https://qudt.org/vocab/unit/FT2) |
| area:in2 | IN2 | Square Inch | in² | [https://qudt.org/vocab/unit/IN2](https://qudt.org/vocab/unit/IN2) |
| area:m2 | M2 | Square Meter | m² | [https://qudt.org/vocab/unit/M2](https://qudt.org/vocab/unit/M2) |
| area:millim2 | MilliM2 | Square Millimeter | mm² | [https://qudt.org/vocab/unit/MilliM2](https://qudt.org/vocab/unit/MilliM2) |
| area:yd2 | YD2 | Square Yard | yd² | [https://qudt.org/vocab/unit/YD2](https://qudt.org/vocab/unit/YD2) |


## Attenuation

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| attenuation:b | B | Bel | B | [https://qudt.org/vocab/unit/B](https://qudt.org/vocab/unit/B) |
| attenuation:decib | DeciB | Decibel | dB | [https://qudt.org/vocab/unit/DeciB](https://qudt.org/vocab/unit/DeciB) |


## Capacitance

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| capacitance:farad | FARAD | farad | F | [https://qudt.org/vocab/unit/FARAD](https://qudt.org/vocab/unit/FARAD) |
| capacitance:microfarad | MicroFARAD | microfarad | µF | [https://qudt.org/vocab/unit/MicroFARAD](https://qudt.org/vocab/unit/MicroFARAD) |
| capacitance:millifarad | MilliFARAD | Millifarad | mF | [https://qudt.org/vocab/unit/MilliFARAD](https://qudt.org/vocab/unit/MilliFARAD) |


## Density

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| density:gm-per-m3 | GM-PER-M3 | Gram Per Cubic Meter | g/m³ | [https://qudt.org/vocab/unit/GM-PER-M3](https://qudt.org/vocab/unit/GM-PER-M3) |
| density:kilogm-per-m3 | KiloGM-PER-M3 | kilogram per cubic meter | kg/m³ | [https://qudt.org/vocab/unit/KiloGM-PER-M3](https://qudt.org/vocab/unit/KiloGM-PER-M3) |
| density:lb-per-ft3 | LB-PER-FT3 | Pound per Cubic Foot | lb/ft³ | [https://qudt.org/vocab/unit/LB-PER-FT3](https://qudt.org/vocab/unit/LB-PER-FT3) |
| density:lb-per-gal | LB-PER-GAL | Pound per Gallon | lb/gal | [https://qudt.org/vocab/unit/LB-PER-GAL](https://qudt.org/vocab/unit/LB-PER-GAL) |
| density:lb-per-in3 | LB-PER-IN3 | Pound per Cubic Inch | lb/in³ | [https://qudt.org/vocab/unit/LB-PER-IN3](https://qudt.org/vocab/unit/LB-PER-IN3) |
| density:lb-per-yd3 | LB-PER-YD3 | Pound per Cubic Yard | lb/yd³ | [https://qudt.org/vocab/unit/LB-PER-YD3](https://qudt.org/vocab/unit/LB-PER-YD3) |
| density:milligm-per-m3 | MilliGM-PER-M3 | Milligram Per Cubic Meter | mg/m³ | [https://qudt.org/vocab/unit/MilliGM-PER-M3](https://qudt.org/vocab/unit/MilliGM-PER-M3) |
| density:oz-per-gal | OZ-PER-GAL | Imperial Mass Ounce per Gallon | oz/gal{US} | [https://qudt.org/vocab/unit/OZ-PER-GAL](https://qudt.org/vocab/unit/OZ-PER-GAL) |
| density:oz-per-in3 | OZ-PER-IN3 | Imperial Mass Ounce per Cubic Inch | oz/in³{US} | [https://qudt.org/vocab/unit/OZ-PER-IN3](https://qudt.org/vocab/unit/OZ-PER-IN3) |


## Dimensionless

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| dimensionless:num | NUM | Number | # | [https://qudt.org/vocab/unit/NUM](https://qudt.org/vocab/unit/NUM) |
| dimensionless:unitless | UNITLESS | Unitless |  | [https://qudt.org/vocab/unit/UNITLESS](https://qudt.org/vocab/unit/UNITLESS) |


## Dimensionless Ratio

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| dimensionless_ratio:fraction | FRACTION | Fraction |  | [https://qudt.org/vocab/unit/FRACTION](https://qudt.org/vocab/unit/FRACTION) |
| dimensionless_ratio:percent | PERCENT | Percent | % | [https://qudt.org/vocab/unit/PERCENT](https://qudt.org/vocab/unit/PERCENT) |
| dimensionless_ratio:ppb | PPB | Parts per billion | PPB | [https://qudt.org/vocab/unit/PPB](https://qudt.org/vocab/unit/PPB) |
| dimensionless_ratio:ppm | PPM | Parts per million | PPM | [https://qudt.org/vocab/unit/PPM](https://qudt.org/vocab/unit/PPM) |
| dimensionless_ratio:ppth | PPTH | Parts per thousand | PPTH | [https://qudt.org/vocab/unit/PPTH](https://qudt.org/vocab/unit/PPTH) |
| dimensionless_ratio:unitless | UNITLESS | Unitless |  | [https://qudt.org/vocab/unit/UNITLESS](https://qudt.org/vocab/unit/UNITLESS) |


## Dynamic Viscosity

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| dynamic_viscosity:centipoise | CentiPOISE | Centipoise | cP | [https://qudt.org/vocab/unit/CentiPOISE](https://qudt.org/vocab/unit/CentiPOISE) |
| dynamic_viscosity:lb-per-ft-hr | LB-PER-FT-HR | Pound per Foot Hour | lb/(ft⋅h) | [https://qudt.org/vocab/unit/LB-PER-FT-HR](https://qudt.org/vocab/unit/LB-PER-FT-HR) |
| dynamic_viscosity:lb-per-ft-sec | LB-PER-FT-SEC | Pound per Foot Second | lb/(ft⋅s) | [https://qudt.org/vocab/unit/LB-PER-FT-SEC](https://qudt.org/vocab/unit/LB-PER-FT-SEC) |
| dynamic_viscosity:millipa-sec | MilliPA-SEC | Millipascal Second | mPa⋅s | [https://qudt.org/vocab/unit/MilliPA-SEC](https://qudt.org/vocab/unit/MilliPA-SEC) |
| dynamic_viscosity:pa-sec | PA-SEC | pascal second | Pa⋅s | [https://qudt.org/vocab/unit/PA-SEC](https://qudt.org/vocab/unit/PA-SEC) |
| dynamic_viscosity:poise | POISE | Poise | P | [https://qudt.org/vocab/unit/POISE](https://qudt.org/vocab/unit/POISE) |


## Electric Current

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| electric_current:a | A | ampere | A | [https://qudt.org/vocab/unit/A](https://qudt.org/vocab/unit/A) |
| electric_current:kiloa | KiloA | kiloampere | kA | [https://qudt.org/vocab/unit/KiloA](https://qudt.org/vocab/unit/KiloA) |
| electric_current:megaa | MegaA | Megaampere | MA | [https://qudt.org/vocab/unit/MegaA](https://qudt.org/vocab/unit/MegaA) |
| electric_current:millia | MilliA | MilliAmpere | mA | [https://qudt.org/vocab/unit/MilliA](https://qudt.org/vocab/unit/MilliA) |


## Electric Potential

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| electric_potential:kilov | KiloV | Kilovolt | kV | [https://qudt.org/vocab/unit/KiloV](https://qudt.org/vocab/unit/KiloV) |
| electric_potential:megav | MegaV | Megavolt | MV | [https://qudt.org/vocab/unit/MegaV](https://qudt.org/vocab/unit/MegaV) |
| electric_potential:microv | MicroV | Microvolt | µV | [https://qudt.org/vocab/unit/MicroV](https://qudt.org/vocab/unit/MicroV) |
| electric_potential:milliv | MilliV | Millivolt | mV | [https://qudt.org/vocab/unit/MilliV](https://qudt.org/vocab/unit/MilliV) |
| electric_potential:v | V | volt | V | [https://qudt.org/vocab/unit/V](https://qudt.org/vocab/unit/V) |


## Energy

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| energy:boe | BOE | Barrel of Oil Equivalent | boe |  |
| energy:btu_it | BTU_IT | British Thermal Unit (International Definition) | Btu{IT} | [https://qudt.org/vocab/unit/BTU_IT](https://qudt.org/vocab/unit/BTU_IT) |
| energy:btu_th | BTU_TH | British Thermal Unit (Thermochemical Definition) | Btu{th} | [https://qudt.org/vocab/unit/BTU_TH](https://qudt.org/vocab/unit/BTU_TH) |
| energy:cal_it | CAL_IT | International Table calorie | cal{IT} | [https://qudt.org/vocab/unit/CAL_IT](https://qudt.org/vocab/unit/CAL_IT) |
| energy:cal_th | CAL_TH | Thermochemical Calorie | cal | [https://qudt.org/vocab/unit/CAL_TH](https://qudt.org/vocab/unit/CAL_TH) |
| energy:ft-lb_f | FT-LB_F | Foot Pound Force | ft⋅lbf | [https://qudt.org/vocab/unit/FT-LB_F](https://qudt.org/vocab/unit/FT-LB_F) |
| energy:gigaj | GigaJ | Gigajoule | GJ | [https://qudt.org/vocab/unit/GigaJ](https://qudt.org/vocab/unit/GigaJ) |
| energy:gigaw-hr | GigaW-HR | Gigawatt Hour | GW⋅h | [https://qudt.org/vocab/unit/GigaW-HR](https://qudt.org/vocab/unit/GigaW-HR) |
| energy:j | J | joule | J | [https://qudt.org/vocab/unit/J](https://qudt.org/vocab/unit/J) |
| energy:kilobtu_it | KiloBTU_IT | Kilo British Thermal Unit (International Definition) | kBtu{IT} | [https://qudt.org/vocab/unit/KiloBTU_IT](https://qudt.org/vocab/unit/KiloBTU_IT) |
| energy:kilobtu_th | KiloBTU_TH | Kilo British Thermal Unit (Thermochemical Definition) | kBtu{th} | [https://qudt.org/vocab/unit/KiloBTU_TH](https://qudt.org/vocab/unit/KiloBTU_TH) |
| energy:kilocal | KiloCAL | Kilocalorie | kcal | [https://qudt.org/vocab/unit/KiloCAL](https://qudt.org/vocab/unit/KiloCAL) |
| energy:kiloj | KiloJ | Kilojoule | kJ | [https://qudt.org/vocab/unit/KiloJ](https://qudt.org/vocab/unit/KiloJ) |
| energy:kilov-a-hr | KiloV-A-HR | Kilovolt Ampere Hour | kV⋅A/h | [https://qudt.org/vocab/unit/KiloV-A-HR](https://qudt.org/vocab/unit/KiloV-A-HR) |
| energy:kilow-hr | KiloW-HR | Kilowatthour | kW⋅h | [https://qudt.org/vocab/unit/KiloW-HR](https://qudt.org/vocab/unit/KiloW-HR) |
| energy:megaj | MegaJ | Megajoule | MJ | [https://qudt.org/vocab/unit/MegaJ](https://qudt.org/vocab/unit/MegaJ) |
| energy:megatoe | MegaTOE | Megaton of Oil Equivalent | megatoe | [https://qudt.org/vocab/unit/MegaTOE](https://qudt.org/vocab/unit/MegaTOE) |
| energy:megav-a-hr | MegaV-A-HR | Megavolt Ampere Hour | MV⋅A⋅h | [https://qudt.org/vocab/unit/MegaV-A-HR](https://qudt.org/vocab/unit/MegaV-A-HR) |
| energy:megaw-hr | MegaW-HR | Megawatt Hour | MW⋅h | [https://qudt.org/vocab/unit/MegaW-HR](https://qudt.org/vocab/unit/MegaW-HR) |
| energy:microj | MicroJ | Micro Joule | µJ | [https://qudt.org/vocab/unit/MicroJ](https://qudt.org/vocab/unit/MicroJ) |
| energy:millij | MilliJ | Millijoule | mJ | [https://qudt.org/vocab/unit/MilliJ](https://qudt.org/vocab/unit/MilliJ) |
| energy:teraj | TeraJ | Terajoule | TJ | [https://qudt.org/vocab/unit/TeraJ](https://qudt.org/vocab/unit/TeraJ) |
| energy:teraw-hr | TeraW-HR | Terawatt Hour | TW⋅h | [https://qudt.org/vocab/unit/TeraW-HR](https://qudt.org/vocab/unit/TeraW-HR) |
| energy:toe | TOE | Ton of Oil Equivalent | toe | [https://qudt.org/vocab/unit/TOE](https://qudt.org/vocab/unit/TOE) |
| energy:v-a-hr | V-A-HR | Volt Ampere Hour | V⋅A⋅h | [https://qudt.org/vocab/unit/V-A-HR](https://qudt.org/vocab/unit/V-A-HR) |
| energy:w-hr | W-HR | Watthour | W⋅h | [https://qudt.org/vocab/unit/W-HR](https://qudt.org/vocab/unit/W-HR) |
| energy:w-sec | W-SEC | Watt Second | W⋅s | [https://qudt.org/vocab/unit/W-SEC](https://qudt.org/vocab/unit/W-SEC) |


## Energy Density

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| energy_density:btu_it-per-ft3 | BTU_IT-PER-FT3 | British Thermal Unit (IT) Per Cubic Foot | Btu{IT}/ft³ | [https://qudt.org/vocab/unit/BTU_IT-PER-FT3](https://qudt.org/vocab/unit/BTU_IT-PER-FT3) |
| energy_density:btu_th-per-ft3 | BTU_TH-PER-FT3 | British Thermal Unit (TH) Per Cubic Foot | Btu{th}/ft³ | [https://qudt.org/vocab/unit/BTU_TH-PER-FT3](https://qudt.org/vocab/unit/BTU_TH-PER-FT3) |
| energy_density:j-per-m3 | J-PER-M3 | Joule per Cubic Meter | J/m³ | [https://qudt.org/vocab/unit/J-PER-M3](https://qudt.org/vocab/unit/J-PER-M3) |
| energy_density:megaj-per-m3 | MegaJ-PER-M3 | Megajoule Per Cubic Meter | MJ/m³ | [https://qudt.org/vocab/unit/MegaJ-PER-M3](https://qudt.org/vocab/unit/MegaJ-PER-M3) |
| energy_density:w-hr-per-m3 | W-HR-PER-M3 | Watthour per Cubic meter | W⋅h/m³ | [https://qudt.org/vocab/unit/W-HR-PER-M3](https://qudt.org/vocab/unit/W-HR-PER-M3) |


## Energy Per Area

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| energy_per_area:gigaj-per-m2 | GigaJ-PER-M2 | Gigajoule per Square Meter | GJ/m² | [https://qudt.org/vocab/unit/GigaJ-PER-M2](https://qudt.org/vocab/unit/GigaJ-PER-M2) |
| energy_per_area:j-per-m2 | J-PER-M2 | Joule per Square Meter | J/m² | [https://qudt.org/vocab/unit/J-PER-M2](https://qudt.org/vocab/unit/J-PER-M2) |
| energy_per_area:megaj-per-m2 | MegaJ-PER-M2 | Megajoule Per Square Meter | MJ/m² | [https://qudt.org/vocab/unit/MegaJ-PER-M2](https://qudt.org/vocab/unit/MegaJ-PER-M2) |


## Force

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| force:centin | CentiN | CentiNewton | cN | [https://qudt.org/vocab/unit/CentiN](https://qudt.org/vocab/unit/CentiN) |
| force:kilolb_f | KiloLB_F | KiloPound Force | klbf | [https://qudt.org/vocab/unit/KiloLB_F](https://qudt.org/vocab/unit/KiloLB_F) |
| force:kilon | KiloN | Kilonewton | kN | [https://qudt.org/vocab/unit/KiloN](https://qudt.org/vocab/unit/KiloN) |
| force:lb_f | LB_F | Pound Force | lbf | [https://qudt.org/vocab/unit/LB_F](https://qudt.org/vocab/unit/LB_F) |
| force:megalb_f | MegaLB_F | Mega Pound Force | Mlbf | [https://qudt.org/vocab/unit/MegaLB_F](https://qudt.org/vocab/unit/MegaLB_F) |
| force:n | N | newton | N | [https://qudt.org/vocab/unit/N](https://qudt.org/vocab/unit/N) |
| force:oz_f | OZ_F | Imperial Ounce Force | ozf | [https://qudt.org/vocab/unit/OZ_F](https://qudt.org/vocab/unit/OZ_F) |


## Frequency

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| frequency:hectohz | HectoHZ | Hectohertz | hHz |  |
| frequency:hz | HZ | hertz | Hz | [https://qudt.org/vocab/unit/HZ](https://qudt.org/vocab/unit/HZ) |
| frequency:kilohz | KiloHZ | Kilohertz | kHz | [https://qudt.org/vocab/unit/KiloHZ](https://qudt.org/vocab/unit/KiloHZ) |
| frequency:num-per-hr | NUM-PER-HR | Number per hour | #/h | [https://qudt.org/vocab/unit/NUM-PER-HR](https://qudt.org/vocab/unit/NUM-PER-HR) |
| frequency:num-per-sec | NUM-PER-SEC | Counts per second | #/s | [https://qudt.org/vocab/unit/NUM-PER-SEC](https://qudt.org/vocab/unit/NUM-PER-SEC) |
| frequency:num-per-yr | NUM-PER-YR | Number per Year | #/yr | [https://qudt.org/vocab/unit/NUM-PER-YR](https://qudt.org/vocab/unit/NUM-PER-YR) |
| frequency:per-min | PER-MIN | Reciprocal Minute | /min | [https://qudt.org/vocab/unit/PER-MIN](https://qudt.org/vocab/unit/PER-MIN) |


## Inductance

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| inductance:h | H | henry | H | [https://qudt.org/vocab/unit/H](https://qudt.org/vocab/unit/H) |
| inductance:microh | MicroH | Microhenry | µH | [https://qudt.org/vocab/unit/MicroH](https://qudt.org/vocab/unit/MicroH) |


## Inverse Length

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| inverse_length:per-m | PER-M | Reciprocal Meter | /m | [https://qudt.org/vocab/unit/PER-M](https://qudt.org/vocab/unit/PER-M) |


## Kinematic Viscosity

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| kinematic_viscosity:centist | CentiST | Centistokes | cSt | [https://qudt.org/vocab/unit/CentiST](https://qudt.org/vocab/unit/CentiST) |
| kinematic_viscosity:st | ST | Stokes | St | [https://qudt.org/vocab/unit/ST](https://qudt.org/vocab/unit/ST) |


## Length

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| length:centim | CentiM | Centimeter | cm | [https://qudt.org/vocab/unit/CentiM](https://qudt.org/vocab/unit/CentiM) |
| length:decim | DeciM | Decimeter | dm | [https://qudt.org/vocab/unit/DeciM](https://qudt.org/vocab/unit/DeciM) |
| length:ft | FT | Foot | ft | [https://qudt.org/vocab/unit/FT](https://qudt.org/vocab/unit/FT) |
| length:in | IN | Inch | in | [https://qudt.org/vocab/unit/IN](https://qudt.org/vocab/unit/IN) |
| length:kilom | KiloM | Kilometer | km | [https://qudt.org/vocab/unit/KiloM](https://qudt.org/vocab/unit/KiloM) |
| length:m | M | Meter | m | [https://qudt.org/vocab/unit/M](https://qudt.org/vocab/unit/M) |
| length:mi | MI | International Mile | mi | [https://qudt.org/vocab/unit/MI](https://qudt.org/vocab/unit/MI) |
| length:microm | MicroM | Micrometer | µm | [https://qudt.org/vocab/unit/MicroM](https://qudt.org/vocab/unit/MicroM) |
| length:milliin | MilliIN | Milli-inch | mil | [https://qudt.org/vocab/unit/MilliIN](https://qudt.org/vocab/unit/MilliIN) |
| length:millim | MilliM | Millimeter | mm | [https://qudt.org/vocab/unit/MilliM](https://qudt.org/vocab/unit/MilliM) |
| length:yd | YD | Yard | yd | [https://qudt.org/vocab/unit/YD](https://qudt.org/vocab/unit/YD) |


## Linear Density

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| linear_density:kilogm-per-m | KiloGM-PER-M | Kilogram per Meter | kg/m | [https://qudt.org/vocab/unit/KiloGM-PER-M](https://qudt.org/vocab/unit/KiloGM-PER-M) |


## Mass

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| mass:centigm | CentiGM | Centigram | cg | [https://qudt.org/vocab/unit/CentiGM](https://qudt.org/vocab/unit/CentiGM) |
| mass:gm | GM | Gram | g | [https://qudt.org/vocab/unit/GM](https://qudt.org/vocab/unit/GM) |
| mass:kilogm | KiloGM | kilogram | kg | [https://qudt.org/vocab/unit/KiloGM](https://qudt.org/vocab/unit/KiloGM) |
| mass:kilotonne | KiloTONNE | KiloTonne | kt | [https://qudt.org/vocab/unit/KiloTONNE](https://qudt.org/vocab/unit/KiloTONNE) |
| mass:lb | LB | Pound Mass | lbm | [https://qudt.org/vocab/unit/LB](https://qudt.org/vocab/unit/LB) |
| mass:milligm | MilliGM | Milligram | mg | [https://qudt.org/vocab/unit/MilliGM](https://qudt.org/vocab/unit/MilliGM) |
| mass:oz | OZ | Ounce Mass | oz | [https://qudt.org/vocab/unit/OZ](https://qudt.org/vocab/unit/OZ) |
| mass:tonne | TONNE | Tonne | t | [https://qudt.org/vocab/unit/TONNE](https://qudt.org/vocab/unit/TONNE) |


## Mass Concentration

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| mass_concentration:kilogm-per-m3 | KiloGM-PER-M3 | kilogram per cubic meter | kg/m³ | [https://qudt.org/vocab/unit/KiloGM-PER-M3](https://qudt.org/vocab/unit/KiloGM-PER-M3) |
| mass_concentration:milligm-per-millil | MilliGM-PER-MilliL | Milligram Per Milliliter | mg/mL | [https://qudt.org/vocab/unit/MilliGM-PER-MilliL](https://qudt.org/vocab/unit/MilliGM-PER-MilliL) |


## Mass Flow Rate

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| mass_flow_rate:gm-per-min | GM-PER-MIN | Gram Per Minute | g/min | [https://qudt.org/vocab/unit/GM-PER-MIN](https://qudt.org/vocab/unit/GM-PER-MIN) |
| mass_flow_rate:gm-per-sec | GM-PER-SEC | Gram Per Second | g/s | [https://qudt.org/vocab/unit/GM-PER-SEC](https://qudt.org/vocab/unit/GM-PER-SEC) |
| mass_flow_rate:kilogm-per-day | KiloGM-PER-DAY | Kilogram Per Day | kg/day | [https://qudt.org/vocab/unit/KiloGM-PER-DAY](https://qudt.org/vocab/unit/KiloGM-PER-DAY) |
| mass_flow_rate:kilogm-per-hr | KiloGM-PER-HR | Kilogram per Hour | kg/h | [https://qudt.org/vocab/unit/KiloGM-PER-HR](https://qudt.org/vocab/unit/KiloGM-PER-HR) |
| mass_flow_rate:kilogm-per-min | KiloGM-PER-MIN | Kilogram Per Minute | kg/min | [https://qudt.org/vocab/unit/KiloGM-PER-MIN](https://qudt.org/vocab/unit/KiloGM-PER-MIN) |
| mass_flow_rate:kilogm-per-sec | KiloGM-PER-SEC | Kilogram per Second | kg/s | [https://qudt.org/vocab/unit/KiloGM-PER-SEC](https://qudt.org/vocab/unit/KiloGM-PER-SEC) |
| mass_flow_rate:lb-per-hr | LB-PER-HR | Pound per Hour | lb/h | [https://qudt.org/vocab/unit/LB-PER-HR](https://qudt.org/vocab/unit/LB-PER-HR) |
| mass_flow_rate:lb-per-min | LB-PER-MIN | Pound per Minute | lb/min | [https://qudt.org/vocab/unit/LB-PER-MIN](https://qudt.org/vocab/unit/LB-PER-MIN) |
| mass_flow_rate:lb-per-sec | LB-PER-SEC | Pound (avoirdupois) Per Second | lb/s | [https://qudt.org/vocab/unit/LB-PER-SEC](https://qudt.org/vocab/unit/LB-PER-SEC) |
| mass_flow_rate:milligm-per-sec | MilliGM-PER-SEC | Milligram Per Second | mg/s | [https://qudt.org/vocab/unit/MilliGM-PER-SEC](https://qudt.org/vocab/unit/MilliGM-PER-SEC) |
| mass_flow_rate:tonne-per-day | TONNE-PER-DAY | Tonne Per Day | t/day | [https://qudt.org/vocab/unit/TONNE-PER-DAY](https://qudt.org/vocab/unit/TONNE-PER-DAY) |
| mass_flow_rate:tonne-per-hr | TONNE-PER-HR | Tonne Per Hour | t/h | [https://qudt.org/vocab/unit/TONNE-PER-HR](https://qudt.org/vocab/unit/TONNE-PER-HR) |
| mass_flow_rate:tonne-per-min | TONNE-PER-MIN | Tonne Per Minute | t/min | [https://qudt.org/vocab/unit/TONNE-PER-MIN](https://qudt.org/vocab/unit/TONNE-PER-MIN) |
| mass_flow_rate:tonne-per-sec | TONNE-PER-SEC | Tonne Per Second | t/s | [https://qudt.org/vocab/unit/TONNE-PER-SEC](https://qudt.org/vocab/unit/TONNE-PER-SEC) |


## Permeability

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| permeability:h-per-m | H-PER-M | Henry per Meter | H/m | [https://qudt.org/vocab/unit/H-PER-M](https://qudt.org/vocab/unit/H-PER-M) |


## Power

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| power:btu_it-per-hr | BTU_IT-PER-HR | BTU per Hour | Btu{IT}/h | [https://qudt.org/vocab/unit/BTU_IT-PER-HR](https://qudt.org/vocab/unit/BTU_IT-PER-HR) |
| power:btu_it-per-sec | BTU_IT-PER-SEC | BTU per Second | Btu{IT}/s | [https://qudt.org/vocab/unit/BTU_IT-PER-SEC](https://qudt.org/vocab/unit/BTU_IT-PER-SEC) |
| power:ft-lb_f-per-hr | FT-LB_F-PER-HR | Foot Pound Force per Hour | ft⋅lbf/h | [https://qudt.org/vocab/unit/FT-LB_F-PER-HR](https://qudt.org/vocab/unit/FT-LB_F-PER-HR) |
| power:ft-lb_f-per-min | FT-LB_F-PER-MIN | Foot Pound Force per Minute | ft⋅lbf/min | [https://qudt.org/vocab/unit/FT-LB_F-PER-MIN](https://qudt.org/vocab/unit/FT-LB_F-PER-MIN) |
| power:ft-lb_f-per-sec | FT-LB_F-PER-SEC | Foot Pound Force per Second | ft⋅lbf/s | [https://qudt.org/vocab/unit/FT-LB_F-PER-SEC](https://qudt.org/vocab/unit/FT-LB_F-PER-SEC) |
| power:gigaw | GigaW | Gigawatt | GW | [https://qudt.org/vocab/unit/GigaW](https://qudt.org/vocab/unit/GigaW) |
| power:hp | HP | Horsepower | HP | [https://qudt.org/vocab/unit/HP](https://qudt.org/vocab/unit/HP) |
| power:j-per-hr | J-PER-HR | Joule Per Hour | J/h | [https://qudt.org/vocab/unit/J-PER-HR](https://qudt.org/vocab/unit/J-PER-HR) |
| power:j-per-sec | J-PER-SEC | Joule Per Second | J/s | [https://qudt.org/vocab/unit/J-PER-SEC](https://qudt.org/vocab/unit/J-PER-SEC) |
| power:kilobtu_it-per-hr | KiloBTU_IT-PER-HR | Kilo British Thermal Unit (International Definition) per Hour | kBtu{IT}/h | [https://qudt.org/vocab/unit/KiloBTU_IT-PER-HR](https://qudt.org/vocab/unit/KiloBTU_IT-PER-HR) |
| power:kilocal-per-min | KiloCAL-PER-MIN | Kilocalorie Per Minute | kcal/min | [https://qudt.org/vocab/unit/KiloCAL-PER-MIN](https://qudt.org/vocab/unit/KiloCAL-PER-MIN) |
| power:kilocal-per-sec | KiloCAL-PER-SEC | Kilocalorie Per Second | kcal/s | [https://qudt.org/vocab/unit/KiloCAL-PER-SEC](https://qudt.org/vocab/unit/KiloCAL-PER-SEC) |
| power:kilov-a | KiloV-A | Kilovolt Ampere | kV⋅A | [https://qudt.org/vocab/unit/KiloV-A](https://qudt.org/vocab/unit/KiloV-A) |
| power:kilow | KiloW | Kilowatt | kW | [https://qudt.org/vocab/unit/KiloW](https://qudt.org/vocab/unit/KiloW) |
| power:megabtu_it-per-hr | MegaBTU_IT-PER-HR | Mega British Thermal Unit (International Definition) per Hour | MBtu{IT}/h | [https://qudt.org/vocab/unit/MegaBTU_IT-PER-HR](https://qudt.org/vocab/unit/MegaBTU_IT-PER-HR) |
| power:megaj-per-sec | MegaJ-PER-SEC | Megajoule Per Second | MJ/s | [https://qudt.org/vocab/unit/MegaJ-PER-SEC](https://qudt.org/vocab/unit/MegaJ-PER-SEC) |
| power:megav-a | MegaV-A | Megavolt Ampere | MV⋅A | [https://qudt.org/vocab/unit/MegaV-A](https://qudt.org/vocab/unit/MegaV-A) |
| power:megaw | MegaW | MegaW | MW | [https://qudt.org/vocab/unit/MegaW](https://qudt.org/vocab/unit/MegaW) |
| power:milliw | MilliW | MilliW | mW | [https://qudt.org/vocab/unit/MilliW](https://qudt.org/vocab/unit/MilliW) |
| power:teraw | TeraW | Terawatt | TW | [https://qudt.org/vocab/unit/TeraW](https://qudt.org/vocab/unit/TeraW) |
| power:v-a | V-A | Volt Ampere | V⋅A | [https://qudt.org/vocab/unit/V-A](https://qudt.org/vocab/unit/V-A) |
| power:w | W | watt | W | [https://qudt.org/vocab/unit/W](https://qudt.org/vocab/unit/W) |


## Power Per Area

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| power_per_area:w-per-m2 | W-PER-M2 | Watt per square meter | W/m² | [https://qudt.org/vocab/unit/W-PER-M2](https://qudt.org/vocab/unit/W-PER-M2) |


## Pressure

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| pressure:atm | ATM | Standard Atmosphere | atm | [https://qudt.org/vocab/unit/ATM](https://qudt.org/vocab/unit/ATM) |
| pressure:bar | BAR | Bar | bar | [https://qudt.org/vocab/unit/BAR](https://qudt.org/vocab/unit/BAR) |
| pressure:barg | BARg | Bar(g) | bar(g) | [https://rds.posccaesar.org/ontology/plm/rdl/PCA_100003649/](https://rds.posccaesar.org/ontology/plm/rdl/PCA_100003649/) |
| pressure:gigapa | GigaPA | Gigapascal | GPa | [https://qudt.org/vocab/unit/GigaPA](https://qudt.org/vocab/unit/GigaPA) |
| pressure:hectopa | HectoPA | Hectopascal | hPa | [https://qudt.org/vocab/unit/HectoPA](https://qudt.org/vocab/unit/HectoPA) |
| pressure:kilobar | KiloBAR | Kilobar | kbar | [https://qudt.org/vocab/unit/KiloBAR](https://qudt.org/vocab/unit/KiloBAR) |
| pressure:kilogm-per-m-sec2 | KiloGM-PER-M-SEC2 | Kilograms per meter per square second | kg/(m⋅s²) | [https://qudt.org/vocab/unit/KiloGM-PER-M-SEC2](https://qudt.org/vocab/unit/KiloGM-PER-M-SEC2) |
| pressure:kilogm_f-per-centim2 | KiloGM_F-PER-CentiM2 | Kilogram Force per Square Centimeter | kgf/cm² | [https://qudt.org/vocab/unit/KiloGM_F-PER-CentiM2](https://qudt.org/vocab/unit/KiloGM_F-PER-CentiM2) |
| pressure:kilolb_f-per-in2 | KiloLB_F-PER-IN2 | Kilopound Force Per Square Inch | kpsi | [https://qudt.org/vocab/unit/KiloLB_F-PER-IN2](https://qudt.org/vocab/unit/KiloLB_F-PER-IN2) |
| pressure:kilopa | KiloPA | Kilopascal | kPa | [https://qudt.org/vocab/unit/KiloPA](https://qudt.org/vocab/unit/KiloPA) |
| pressure:kilopag | KiloPAg | Kilopascal(g) | kPa(g) | [https://rds.posccaesar.org/ontology/plm/rdl/PCA_100005357](https://rds.posccaesar.org/ontology/plm/rdl/PCA_100005357) |
| pressure:lb_f-per-ft2 | LB_F-PER-FT2 | Pound Force per Square Foot | lbf/ft² | [https://qudt.org/vocab/unit/LB_F-PER-FT2](https://qudt.org/vocab/unit/LB_F-PER-FT2) |
| pressure:megabar | MegaBAR | Megabar | Mbar | [https://qudt.org/vocab/unit/MegaBAR](https://qudt.org/vocab/unit/MegaBAR) |
| pressure:megapa | MegaPA | Megapascal | MPa | [https://qudt.org/vocab/unit/MegaPA](https://qudt.org/vocab/unit/MegaPA) |
| pressure:micropa | MicroPA | Micropascal | μPa | [https://qudt.org/vocab/unit/MicroPA](https://qudt.org/vocab/unit/MicroPA) |
| pressure:millibar | MilliBAR | Millibar | mbar | [https://qudt.org/vocab/unit/MilliBAR](https://qudt.org/vocab/unit/MilliBAR) |
| pressure:millim_h2o | MilliM_H2O | Millimeter Of Water | mmH₂0 | [https://qudt.org/vocab/unit/MilliM_H2O](https://qudt.org/vocab/unit/MilliM_H2O) |
| pressure:millipa | MilliPA | Millipascal | mPa | [https://qudt.org/vocab/unit/MilliPA](https://qudt.org/vocab/unit/MilliPA) |
| pressure:n-per-centim2 | N-PER-CentiM2 | Newton Per Square Centimeter | N/cm² | [https://qudt.org/vocab/unit/N-PER-CentiM2](https://qudt.org/vocab/unit/N-PER-CentiM2) |
| pressure:n-per-m2 | N-PER-M2 | Newtons Per Square Meter | N/m² | [https://qudt.org/vocab/unit/N-PER-M2](https://qudt.org/vocab/unit/N-PER-M2) |
| pressure:n-per-millim2 | N-PER-MilliM2 | Newton Per Square Millimeter | N/mm² | [https://qudt.org/vocab/unit/N-PER-MilliM2](https://qudt.org/vocab/unit/N-PER-MilliM2) |
| pressure:pa | PA | pascal | Pa | [https://qudt.org/vocab/unit/PA](https://qudt.org/vocab/unit/PA) |
| pressure:psi | PSI | Pound Force per Square Inch | psi | [https://qudt.org/vocab/unit/PSI](https://qudt.org/vocab/unit/PSI) |
| pressure:psig | PSIg | Pound Force per Square Inch (gauge) | psi(g) |  |


## Pressure Gradient

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| pressure_gradient:bar-per-m | BAR-PER-M | Bar per meter | bar/m |  |
| pressure_gradient:kilopa-per-m | KiloPA-PER-M | Kilopascal per meter | kPa/m | [https://qudt.org/vocab/unit/KiloPA-PER-M](https://qudt.org/vocab/unit/KiloPA-PER-M) |
| pressure_gradient:pa-per-m | PA-PER-M | Pascal per meter | Pa/m |  |
| pressure_gradient:psi-per-ft | PSI-PER-FT | Pound Force per Square Inch per Foot | psi/ft |  |
| pressure_gradient:psi-per-m | PSI-PER-M | Pound Force per Square Inch per Meter | psi/m |  |


## Resistance

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| resistance:kiloohm | KiloOHM | Kiloohm | kΩ | [https://qudt.org/vocab/unit/KiloOHM](https://qudt.org/vocab/unit/KiloOHM) |
| resistance:milliohm | MilliOHM | Milliohm | mΩ | [https://qudt.org/vocab/unit/MilliOHM](https://qudt.org/vocab/unit/MilliOHM) |
| resistance:ohm | OHM | ohm | Ω | [https://qudt.org/vocab/unit/OHM](https://qudt.org/vocab/unit/OHM) |


## Surface Tension

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| surface_tension:ft-lb_f-per-ft2 | FT-LB_F-PER-FT2 | Foot Pound per Square Foot | ft⋅lbf/ft² | [https://qudt.org/vocab/unit/FT-LB_F-PER-FT2](https://qudt.org/vocab/unit/FT-LB_F-PER-FT2) |
| surface_tension:j-per-centim2 | J-PER-CentiM2 | Joule Per Square Centimeter | J/cm² | [https://qudt.org/vocab/unit/J-PER-CentiM2](https://qudt.org/vocab/unit/J-PER-CentiM2) |
| surface_tension:j-per-m2 | J-PER-M2 | Joule per Square Meter | J/m² | [https://qudt.org/vocab/unit/J-PER-M2](https://qudt.org/vocab/unit/J-PER-M2) |
| surface_tension:kilogm-per-sec2 | KiloGM-PER-SEC2 | Kilogram per Square Second | kg/s² | [https://qudt.org/vocab/unit/KiloGM-PER-SEC2](https://qudt.org/vocab/unit/KiloGM-PER-SEC2) |
| surface_tension:megaj-per-m2 | MegaJ-PER-M2 | Megajoule Per Square Meter | MJ/m² | [https://qudt.org/vocab/unit/MegaJ-PER-M2](https://qudt.org/vocab/unit/MegaJ-PER-M2) |
| surface_tension:n-m-per-m2 | N-M-PER-M2 | Newton Meter Per Square Meter | N⋅m/m² | [https://qudt.org/vocab/unit/N-M-PER-M2](https://qudt.org/vocab/unit/N-M-PER-M2) |
| surface_tension:w-hr-per-m2 | W-HR-PER-M2 | Watt hour per square meter | W⋅h/m² | [https://qudt.org/vocab/unit/W-HR-PER-M2](https://qudt.org/vocab/unit/W-HR-PER-M2) |
| surface_tension:w-sec-per-m2 | W-SEC-PER-M2 | Watt seconds per square meter | W⋅s/m² | [https://qudt.org/vocab/unit/W-SEC-PER-M2](https://qudt.org/vocab/unit/W-SEC-PER-M2) |


## Temperature

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| temperature:deg_c | DEG_C | degree Celsius | °C | [https://qudt.org/vocab/unit/DEG_C](https://qudt.org/vocab/unit/DEG_C) |
| temperature:deg_f | DEG_F | Degree Fahrenheit | °F | [https://qudt.org/vocab/unit/DEG_F](https://qudt.org/vocab/unit/DEG_F) |
| temperature:deg_r | DEG_R | Degree Rankine | °R | [https://qudt.org/vocab/unit/DEG_R](https://qudt.org/vocab/unit/DEG_R) |
| temperature:k | K | kelvin | K | [https://qudt.org/vocab/unit/K](https://qudt.org/vocab/unit/K) |


## Temperature Gradient

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| temperature_gradient:k-per-m | K-PER-M | Degrees Kelvin per meter | K/m | [https://qudt.org/vocab/unit/K-PER-M](https://qudt.org/vocab/unit/K-PER-M) |


## Time

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| time:day | DAY | Day | day | [https://qudt.org/vocab/unit/DAY](https://qudt.org/vocab/unit/DAY) |
| time:hr | HR | Hour | h | [https://qudt.org/vocab/unit/HR](https://qudt.org/vocab/unit/HR) |
| time:microsec | MicroSEC | microsecond | µs | [https://qudt.org/vocab/unit/MicroSEC](https://qudt.org/vocab/unit/MicroSEC) |
| time:millisec | MilliSEC | millisecond | ms | [https://qudt.org/vocab/unit/MilliSEC](https://qudt.org/vocab/unit/MilliSEC) |
| time:min | MIN | Minute | min | [https://qudt.org/vocab/unit/MIN](https://qudt.org/vocab/unit/MIN) |
| time:mo | MO | Month | mo |  |
| time:sec | SEC | second | s | [https://qudt.org/vocab/unit/SEC](https://qudt.org/vocab/unit/SEC) |
| time:wk | WK | Week | wk | [https://qudt.org/vocab/unit/WK](https://qudt.org/vocab/unit/WK) |
| time:yr | YR | Year | yr | [https://qudt.org/vocab/unit/YR](https://qudt.org/vocab/unit/YR) |


## Torque

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| torque:lb_f-ft | LB_F-FT | Pound Force Foot | lbf⋅ft | [https://qudt.org/vocab/unit/LB_F-FT](https://qudt.org/vocab/unit/LB_F-FT) |
| torque:lb_f-in | LB_F-IN | Pound Force Inch | lbf⋅in | [https://qudt.org/vocab/unit/LB_F-IN](https://qudt.org/vocab/unit/LB_F-IN) |
| torque:n-m | N-M | Newton Meter | N⋅m | [https://qudt.org/vocab/unit/N-M](https://qudt.org/vocab/unit/N-M) |


## Unknown

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| unknown:unknown | Unknown | Unknown unit |  |  |


## Velocity

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| velocity:ft-per-hr | FT-PER-HR | Foot per Hour | ft/h | [https://qudt.org/vocab/unit/FT-PER-HR](https://qudt.org/vocab/unit/FT-PER-HR) |
| velocity:ft-per-sec | FT-PER-SEC | Foot per Second | ft/s | [https://qudt.org/vocab/unit/FT-PER-SEC](https://qudt.org/vocab/unit/FT-PER-SEC) |
| velocity:in-per-sec | IN-PER-SEC | Inch per Second | in/s | [https://qudt.org/vocab/unit/IN-PER-SEC](https://qudt.org/vocab/unit/IN-PER-SEC) |
| velocity:kilom-per-hr | KiloM-PER-HR | Kilometer per Hour | km/h | [https://qudt.org/vocab/unit/KiloM-PER-HR](https://qudt.org/vocab/unit/KiloM-PER-HR) |
| velocity:kilom-per-sec | KiloM-PER-SEC | Kilometer per Second | km/s | [https://qudt.org/vocab/unit/KiloM-PER-SEC](https://qudt.org/vocab/unit/KiloM-PER-SEC) |
| velocity:kn | KN | Knot | kn | [https://qudt.org/vocab/unit/KN](https://qudt.org/vocab/unit/KN) |
| velocity:m-per-hr | M-PER-HR | Meter per Hour | m/h | [https://qudt.org/vocab/unit/M-PER-HR](https://qudt.org/vocab/unit/M-PER-HR) |
| velocity:m-per-sec | M-PER-SEC | Meter per Second | m/s | [https://qudt.org/vocab/unit/M-PER-SEC](https://qudt.org/vocab/unit/M-PER-SEC) |
| velocity:mi-per-hr | MI-PER-HR | Mile per Hour | mi/h | [https://qudt.org/vocab/unit/MI-PER-HR](https://qudt.org/vocab/unit/MI-PER-HR) |
| velocity:mi-per-sec | MI-PER-SEC | Mile per Second | mi/s | [https://qudt.org/vocab/unit/MI-PER-SEC](https://qudt.org/vocab/unit/MI-PER-SEC) |
| velocity:millim-per-hr | MilliM-PER-HR | Millimeter Per Hour | mm/h | [https://qudt.org/vocab/unit/MilliM-PER-HR](https://qudt.org/vocab/unit/MilliM-PER-HR) |
| velocity:millim-per-sec | MilliM-PER-SEC | Millimeter Per Second | mm/s | [https://qudt.org/vocab/unit/MilliM-PER-SEC](https://qudt.org/vocab/unit/MilliM-PER-SEC) |


## Volume

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| volume:bbl_us | BBL_US | Barrel (US) | bbl | [https://qudt.org/vocab/unit/BBL_US](https://qudt.org/vocab/unit/BBL_US) |
| volume:centim3 | CentiM3 | cubic centimeter | cm³ | [https://qudt.org/vocab/unit/CentiM3](https://qudt.org/vocab/unit/CentiM3) |
| volume:decil | DeciL | Decilitre | dL | [https://qudt.org/vocab/unit/DeciL](https://qudt.org/vocab/unit/DeciL) |
| volume:decim3 | DeciM3 | Cubic Decimeter | dm³ | [https://qudt.org/vocab/unit/DeciM3](https://qudt.org/vocab/unit/DeciM3) |
| volume:ft3 | FT3 | Cubic Foot | ft³ | [https://qudt.org/vocab/unit/FT3](https://qudt.org/vocab/unit/FT3) |
| volume:gal_uk | GAL_UK | Gallon (UK) | gal{UK} | [https://qudt.org/vocab/unit/GAL_UK](https://qudt.org/vocab/unit/GAL_UK) |
| volume:in3 | IN3 | Cubic Inch | in³ | [https://qudt.org/vocab/unit/IN3](https://qudt.org/vocab/unit/IN3) |
| volume:kilo-ft3 | Kilo-FT3 | Thousand Cubic Foot | k.ft³ | [https://qudt.org/vocab/unit/Kilo-FT3](https://qudt.org/vocab/unit/Kilo-FT3) |
| volume:kilol | KiloL | Kilolitre | kL | [https://qudt.org/vocab/unit/KiloL](https://qudt.org/vocab/unit/KiloL) |
| volume:l | L | Liter | L | [https://qudt.org/vocab/unit/L](https://qudt.org/vocab/unit/L) |
| volume:m3 | M3 | Cubic Meter | m³ | [https://qudt.org/vocab/unit/M3](https://qudt.org/vocab/unit/M3) |
| volume:mega-ft3 | Mega-FT3 | Million Standard Cubic Feet | MMscf |  |
| volume:mega-m3 | Mega-M3 | Million Standard Cubic Meter | MMscm |  |
| volume:megal | MegaL | Megalitre | ML | [https://qudt.org/vocab/unit/MegaL](https://qudt.org/vocab/unit/MegaL) |
| volume:microl | MicroL | Microlitre | μL | [https://qudt.org/vocab/unit/MicroL](https://qudt.org/vocab/unit/MicroL) |
| volume:microm3 | MicroM3 | Cubic micrometers (microns) | µm³ | [https://qudt.org/vocab/unit/MicroM3](https://qudt.org/vocab/unit/MicroM3) |
| volume:millil | MilliL | Millilitre | mL | [https://qudt.org/vocab/unit/MilliL](https://qudt.org/vocab/unit/MilliL) |
| volume:millim3 | MilliM3 | Cubic Millimeter | mm³ | [https://qudt.org/vocab/unit/MilliM3](https://qudt.org/vocab/unit/MilliM3) |
| volume:yd3 | YD3 | Cubic Yard | yd³ | [https://qudt.org/vocab/unit/YD3](https://qudt.org/vocab/unit/YD3) |


## Volume Flow Rate

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| volume_flow_rate:bbl_us-per-day | BBL_US-PER-DAY | Barrel (US) Per Day | bbl/day | [https://qudt.org/vocab/unit/BBL_US-PER-DAY](https://qudt.org/vocab/unit/BBL_US-PER-DAY) |
| volume_flow_rate:centim3-per-sec | CentiM3-PER-SEC | Cubic Centimeter Per Second | cm³/s | [https://qudt.org/vocab/unit/CentiM3-PER-SEC](https://qudt.org/vocab/unit/CentiM3-PER-SEC) |
| volume_flow_rate:decim3-per-min | DeciM3-PER-MIN | Cubic Decimeter Per Minute | dm³/min | [https://qudt.org/vocab/unit/DeciM3-PER-MIN](https://qudt.org/vocab/unit/DeciM3-PER-MIN) |
| volume_flow_rate:decim3-per-sec | DeciM3-PER-SEC | Cubic Decimeter Per Second | dm³/s | [https://qudt.org/vocab/unit/DeciM3-PER-SEC](https://qudt.org/vocab/unit/DeciM3-PER-SEC) |
| volume_flow_rate:ft3-per-day | FT3-PER-DAY | Cubic Foot Per Day | ft³/day | [https://qudt.org/vocab/unit/FT3-PER-DAY](https://qudt.org/vocab/unit/FT3-PER-DAY) |
| volume_flow_rate:ft3-per-hr | FT3-PER-HR | Cubic Foot Per Hour | ft³/h | [https://qudt.org/vocab/unit/FT3-PER-HR](https://qudt.org/vocab/unit/FT3-PER-HR) |
| volume_flow_rate:ft3-per-min | FT3-PER-MIN | Cubic Foot per Minute | ft³/min | [https://qudt.org/vocab/unit/FT3-PER-MIN](https://qudt.org/vocab/unit/FT3-PER-MIN) |
| volume_flow_rate:ft3-per-sec | FT3-PER-SEC | Cubic Foot per Second | ft³/s | [https://qudt.org/vocab/unit/FT3-PER-SEC](https://qudt.org/vocab/unit/FT3-PER-SEC) |
| volume_flow_rate:gal_uk-per-hr | GAL_UK-PER-HR | Gallon (UK) Per Hour | gal{UK}/h | [https://qudt.org/vocab/unit/GAL_UK-PER-HR](https://qudt.org/vocab/unit/GAL_UK-PER-HR) |
| volume_flow_rate:gal_uk-per-min | GAL_UK-PER-MIN | Gallon (UK) Per Minute | gal{UK}/min | [https://qudt.org/vocab/unit/GAL_UK-PER-MIN](https://qudt.org/vocab/unit/GAL_UK-PER-MIN) |
| volume_flow_rate:gal_uk-per-sec | GAL_UK-PER-SEC | Gallon (UK) Per Second | gal{UK}/s | [https://qudt.org/vocab/unit/GAL_UK-PER-SEC](https://qudt.org/vocab/unit/GAL_UK-PER-SEC) |
| volume_flow_rate:in3-per-sec | IN3-PER-SEC | Cubic Inch Per Second | in³/s | [https://qudt.org/vocab/unit/IN3-PER-SEC](https://qudt.org/vocab/unit/IN3-PER-SEC) |
| volume_flow_rate:kilo-ft3-per-day | Kilo-FT3-PER-DAY | Thousand Standard Cubic Feet per Day | kft³/day |  |
| volume_flow_rate:kilol-per-hr | KiloL-PER-HR | Kilolitre Per Hour | kL/h | [https://qudt.org/vocab/unit/KiloL-PER-HR](https://qudt.org/vocab/unit/KiloL-PER-HR) |
| volume_flow_rate:l-per-day | L-PER-DAY | Liter Per Day | L/day | [https://qudt.org/vocab/unit/L-PER-DAY](https://qudt.org/vocab/unit/L-PER-DAY) |
| volume_flow_rate:l-per-hr | L-PER-HR | Liter Per Hour | L/hr | [https://qudt.org/vocab/unit/L-PER-HR](https://qudt.org/vocab/unit/L-PER-HR) |
| volume_flow_rate:l-per-min | L-PER-MIN | Liter Per Minute | L/min | [https://qudt.org/vocab/unit/L-PER-MIN](https://qudt.org/vocab/unit/L-PER-MIN) |
| volume_flow_rate:l-per-sec | L-PER-SEC | Liter Per Second | L/s | [https://qudt.org/vocab/unit/L-PER-SEC](https://qudt.org/vocab/unit/L-PER-SEC) |
| volume_flow_rate:m3-per-day | M3-PER-DAY | Cubic Meter Per Day | m³/day | [https://qudt.org/vocab/unit/M3-PER-DAY](https://qudt.org/vocab/unit/M3-PER-DAY) |
| volume_flow_rate:m3-per-hr | M3-PER-HR | Cubic Meter per Hour | m³/h | [https://qudt.org/vocab/unit/M3-PER-HR](https://qudt.org/vocab/unit/M3-PER-HR) |
| volume_flow_rate:m3-per-min | M3-PER-MIN | Cubic Meter Per Minute | m³/min | [https://qudt.org/vocab/unit/M3-PER-MIN](https://qudt.org/vocab/unit/M3-PER-MIN) |
| volume_flow_rate:m3-per-sec | M3-PER-SEC | Cubic Meter per Second | m³/s | [https://qudt.org/vocab/unit/M3-PER-SEC](https://qudt.org/vocab/unit/M3-PER-SEC) |
| volume_flow_rate:mega-ft3-per-day | Mega-FT3-PER-DAY | Million Standard Cubic Feet per Day | MMscf/day | [https://rds.posccaesar.org/ontology/plm/rdl/PCA_100005446/](https://rds.posccaesar.org/ontology/plm/rdl/PCA_100005446/) |
| volume_flow_rate:millil-per-sec | MilliL-PER-SEC | Millilitre Per Second | mL/s | [https://qudt.org/vocab/unit/MilliL-PER-SEC](https://qudt.org/vocab/unit/MilliL-PER-SEC) |
| volume_flow_rate:yd3-per-day | YD3-PER-DAY | Cubic Yard Per Day | yd³/day | [https://qudt.org/vocab/unit/YD3-PER-DAY](https://qudt.org/vocab/unit/YD3-PER-DAY) |
| volume_flow_rate:yd3-per-hr | YD3-PER-HR | Cubic Yard Per Hour | yd³/h | [https://qudt.org/vocab/unit/YD3-PER-HR](https://qudt.org/vocab/unit/YD3-PER-HR) |
| volume_flow_rate:yd3-per-min | YD3-PER-MIN | Cubic Yard per Minute | yd³/min | [https://qudt.org/vocab/unit/YD3-PER-MIN](https://qudt.org/vocab/unit/YD3-PER-MIN) |
| volume_flow_rate:yd3-per-sec | YD3-PER-SEC | Cubic Yard Per Second | yd³/s | [https://qudt.org/vocab/unit/YD3-PER-SEC](https://qudt.org/vocab/unit/YD3-PER-SEC) |


## Volume Fraction

| externalId  | name       | longName                  | symbol      | source             |
|-------------|------------|---------------------------|-------------|--------------------|
| volume_fraction:centim3-per-centim3 | CentiM3-PER-CentiM3 | Cubic Centimeter Per Cubic Centimeter | cm³/cm³ | [https://qudt.org/vocab/unit/CentiM3-PER-CentiM3](https://qudt.org/vocab/unit/CentiM3-PER-CentiM3) |
| volume_fraction:centim3-per-m3 | CentiM3-PER-M3 | Cubic Centimeter Per Cubic Meter | cm³/m³ | [https://qudt.org/vocab/unit/CentiM3-PER-M3](https://qudt.org/vocab/unit/CentiM3-PER-M3) |
| volume_fraction:l-per-l | L-PER-L | Liter Per Liter | L/L | [https://qudt.org/vocab/unit/L-PER-L](https://qudt.org/vocab/unit/L-PER-L) |
| volume_fraction:m3-per-m3 | M3-PER-M3 | Cubic Meter Per Cubic Meter | m³/m³ | [https://qudt.org/vocab/unit/M3-PER-M3](https://qudt.org/vocab/unit/M3-PER-M3) |
| volume_fraction:microl-per-l | MicroL-PER-L | Microlitre Per Liter | μL/L | [https://qudt.org/vocab/unit/MicroL-PER-L](https://qudt.org/vocab/unit/MicroL-PER-L) |
| volume_fraction:millil-per-l | MilliL-PER-L | Millilitre Per Liter | mL/L | [https://qudt.org/vocab/unit/MilliL-PER-L](https://qudt.org/vocab/unit/MilliL-PER-L) |
| volume_fraction:millil-per-m3 | MilliL-PER-M3 | Millilitre Per Cubic Meter | mL/m³ | [https://qudt.org/vocab/unit/MilliL-PER-M3](https://qudt.org/vocab/unit/MilliL-PER-M3) |

