from setuptools import setup, find_packages

setup(
    name="stemsage",
    version="0.8.6",
    description="Uncovering Stem-loop Motifs from RBP Binding Regions",
    author="Zixiang Wang, Lei Yang",
    author_email="wangzixiang@sdu.edu.cn",
    packages=find_packages(),
    entry_points={
        'console_scripts': [
            'stemsage=stemsage.main:main',
        ],
    },
    install_requires=[
        'numpy>=1.21.0',
        'pandas>=1.3.0',
        'scikit-learn>=1.0.0',
        'xgboost>=1.5.0',
        'matplotlib>=3.5.0',
        'seaborn>=0.11.0',
        'biopython>=1.79',
        'scipy>=1.7.0',
        'statsmodels>=0.13.0',
        'tqdm>=4.62.0',
        'joblib>=1.1.0',
        'Levenshtein>=0.20.0',
        'jinja2>=3.0.0',
    ],
    python_requires='>=3.8',
    include_package_data=True, 
    package_data={
        'stemsage': ['templates/*'], 
    },
    license="GPL-3.0",
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering :: Bio-Informatics',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
    ],
)
