# rnafold_template.sh
#!/bin/bash

# 预测阳性序列结构
echo "Predicting structures for positive sequences..."
RNAfold -j --noPS < __POSITIVE_INPUT__ > temp_positive.res

# 预测阴性序列结构  
echo "Predicting structures for negative sequences..."
RNAfold -j --noPS < __NEGATIVE_INPUT__ > temp_negative.res

# 清理阳性结果文件
echo "Processing positive results..."
sed 's/ (  [-0-9.]*)$//' temp_positive.res > temp_positive_clean1.res
sed 's/ ( [-0-9.]*)$//' temp_positive_clean1.res > temp_positive_clean2.res
sed 's/ ([-0-9.]*)$//' temp_positive_clean2.res > __POSITIVE_OUTPUT__
rm temp_positive_clean*.res temp_positive.res

# 清理阴性结果文件
echo "Processing negative results..."
sed 's/ (  [-0-9.]*)$//' temp_negative.res > temp_negative_clean1.res
sed 's/ ( [-0-9.]*)$//' temp_negative_clean1.res > temp_negative_clean2.res
sed 's/ ([-0-9.]*)$//' temp_negative_clean2.res > __NEGATIVE_OUTPUT__
rm temp_negative_clean*.res temp_negative.res

echo "RNAfold processing completed!"
echo "Positive structures: __POSITIVE_OUTPUT__"
echo "Negative structures: __NEGATIVE_OUTPUT__"
