"""
Definitions of rectangular regions used in pyaerocom

NOTE: replaces former regions.ini in pyaerocom/data dir
"""

#: Name of region containing absolute all valid data points (WORLD in old aerocom notation)
ALL_REGION_NAME = "ALL"

_AEROCOM_DEFS = {
    ALL_REGION_NAME: {
        "lat_range": [-90, 90],
        "lon_range": [-180, 180],
        "lon_range_plot": [-180, 180],
        "lon_ticks": [-180.0, -135.0, -90.0, -45.0, 0.0, 45, 90, 135, 180],
        "lat_ticks": [-90.0, -60, -30, 0.0, 30, 60, 90],
    },
    "ASIA": {"lat_range": [0, 72], "lon_range": [50, 150], "lon_range_plot": [50, 150]},
    "AUSTRALIA": {"lat_range": [-50, -10], "lon_range": [110, 155], "lon_range_plot": [90, 180]},
    "CHINA": {"lat_range": [20, 50], "lon_range": [90, 130], "lon_range_plot": [90, 140]},
    "EUROPE": {
        "lat_range": [40, 72],
        "lon_range": [-10, 40],
        "lon_range_plot": [-10, 40],
        "lon_ticks": [-20, -10, 0, 10, 20, 30, 40, 50, 60, 70],
        "lat_ticks": [30, 40, 50, 60, 70, 80],
    },
    "INDIA": {"lat_range": [5, 35], "lon_range": [65, 90], "lon_range_plot": [50, 100]},
    "NAFRICA": {"lat_range": [0, 40], "lon_range": [-17, 50], "lon_range_plot": [-17, 50]},
    "SAFRICA": {"lat_range": [-35, 0], "lon_range": [10, 40], "lon_range_plot": [10, 40]},
    "SAMERICA": {"lat_range": [-60, 20], "lon_range": [-105, -30], "lon_range_plot": [-105, -30]},
    "NAMERICA": {"lat_range": [20, 80], "lon_range": [-150, -45], "lon_range_plot": [-150, -45]},
}

_HTAP_DEFS = {
    "PAN": {"lat_range": [-54.74999999999966, 11.550000000000823], "lon_range": [112, -134]},
    "EAS": {
        "lat_range": [18.25000000000084, 53.55000000000134],
        "lon_range": [73.64999999999412, 145.74999999999002],
    },
    "NAF": {
        "lat_range": [19.05000000000085, 37.25000000000111],
        "lon_range": [-17.050000000005937, 35.74999999999427],
    },
    "MDE": {
        "lat_range": [12.150000000000821, 39.65000000000114],
        "lon_range": [34.24999999999425, 63.249999999994664],
    },
    "LAND": {"lat_range": [-59.449999999999726, 71.15000000000109], "lon_range": [-180, 180]},
    "SAS": {
        "lat_range": [-9.749999999999135, 37.050000000001106],
        "lon_range": [46.349999999994424, 97.34999999999278],
    },
    "SPO": {
        "lat_range": [-89.94999999999831, -60.049999999999734],
        "lon_range": [-179.95000000000002, 179.94999999998808],
    },
    "OCN": {"lat_range": [-59.94999999999973, 66.25000000000136], "lon_range": [-180, 180]},
    "SEA": {
        "lat_range": [-11.649999999999128, 28.450000000000983],
        "lon_range": [92.24999999999307, 155.94999999998944],
    },
    "RBU": {"lat_range": [29.450000000000998, 66.25000000000136], "lon_range": [22, -170]},
    "EEUROPE": {
        "lat_range": [34.65000000000107, 59.550000000001425],
        "lon_range": [12.14999999999401, 44.7499999999944],
    },
    "NAM": {"lat_range": [18.95000000000085, 71.15000000000109], "lon_range": [172, -52]},
    "WEUROPE": {
        "lat_range": [27.750000000000973, 66.45000000000135],
        "lon_range": [-31.25000000000614, 31.449999999994215],
    },
    "SAF": {
        "lat_range": [-54.449999999999655, 27.250000000000966],
        "lon_range": [-25.350000000006055, 77.5499999999939],
    },
    "USA": {
        "lat_range": [18.95000000000085, 49.35000000000128],
        "lon_range": [-159.75000000000117, -56.250000000006494],
    },
    "SAM": {
        "lat_range": [-59.449999999999726, 5.150000000000846],
        "lon_range": [-109.35000000000403, -26.250000000006068],
    },
    "EUR": {
        "lat_range": [27.750000000000973, 66.45000000000135],
        "lon_range": [-31.25000000000614, 44.7499999999944],
    },
    "NPO": {
        "lat_range": [59.85000000000143, 89.95000000000002],
        "lon_range": [-179.95000000000002, 179.94999999998808],
    },
    "MCA": {
        "lat_range": [-4.149999999999155, 32.65000000000104],
        "lon_range": [-118.35000000000352, -51.65000000000643],
    },
}


_OTHER_REG_DEFS = {
    "NHEMISPHERE": {"lat_range": [0, 90], "lon_range": [-180, 180], "lon_range_plot": [-180, 180]},
    "SHEMISPHERE": {
        "lat_range": [-90, 0],
        "lon_range": [-180, 180],
        "lon_range_plot": [-180, 180],
    },
}


_EU_CITIES = {
    "Aachen": {
        "lat_range": [50.636802673339844, 50.867191314697266],
        "lon_range": [5.966033458709717, 6.228730201721191],
    },
    "Amsterdam": {
        "lat_range": [52.235111236572266, 52.450042724609375],
        "lon_range": [4.7180094718933105, 5.103306293487549],
    },
    "Antwerp": {
        "lat_range": [51.13616180419922, 51.387718200683594],
        "lon_range": [4.235825061798096, 4.511722087860107],
    },
    "Athens": {
        "lat_range": [37.73632049560547, 38.2413444519043],
        "lon_range": [23.51335334777832, 23.998926162719727],
    },
    "Berlin": {
        "lat_range": [52.33273696899414, 52.69112777709961],
        "lon_range": [13.077515602111816, 13.78443717956543],
    },
    "Bordeaux": {
        "lat_range": [44.70786666870117, 44.96601486206055],
        "lon_range": [-0.8970025181770325, -0.4452879726886749],
    },
    "Bratislava": {
        "lat_range": [47.99800491333008, 48.26951217651367],
        "lon_range": [16.913551330566406, 17.30634880065918],
    },
    "Bremen": {
        "lat_range": [53.002567291259766, 53.60324478149414],
        "lon_range": [8.461311340332031, 9.000018119812012],
    },
    "Brussels": {
        "lat_range": [50.75230407714844, 50.918785095214844],
        "lon_range": [4.230016231536865, 4.493005752563477],
    },
    "Cologne": {
        "lat_range": [50.81940841674805, 51.09670639038086],
        "lon_range": [6.767996311187744, 7.172985553741455],
    },
    "Copenhagen": {
        "lat_range": [55.53798294067383, 55.82252883911133],
        "lon_range": [12.132223129272461, 12.812111854553223],
    },
    "Frankfurt": {
        "lat_range": [50.008689880371094, 50.230812072753906],
        "lon_range": [8.46023178100586, 8.812448501586914],
    },
    "Gothenburg": {
        "lat_range": [57.50046157836914, 57.87602996826172],
        "lon_range": [11.585185050964355, 12.252819061279297],
    },
    "Hamburg": {
        "lat_range": [53.38390350341797, 53.975887298583984],
        "lon_range": [8.409785270690918, 10.33332633972168],
    },
    "Hanover": {
        "lat_range": [52.30150604248047, 52.457183837890625],
        "lon_range": [9.597295761108398, 9.924869537353516],
    },
    "Katowice": {
        "lat_range": [50.12342071533203, 50.31399917602539],
        "lon_range": [18.866928100585938, 19.139799118041992],
    },
    "Lille": {
        "lat_range": [50.544219970703125, 50.803993225097656],
        "lon_range": [2.906511068344116, 3.283663511276245],
    },
    "Lisbon": {
        "lat_range": [38.46509552001953, 38.957637786865234],
        "lon_range": [-9.536591529846191, -8.962636947631836],
    },
    "Luxembourg": {
        "lat_range": [49.5549430847168, 49.66079330444336],
        "lon_range": [6.060097694396973, 6.209787368774414],
    },
    "Lyon": {
        "lat_range": [45.63044357299805, 45.86970138549805],
        "lon_range": [4.692460060119629, 5.062458038330078],
    },
    "Madrid": {
        "lat_range": [40.17313766479492, 40.675025939941406],
        "lon_range": [-4.016128063201904, -3.370154857635498],
    },
    "Malmö": {
        "lat_range": [55.49353790283203, 55.646114349365234],
        "lon_range": [12.873371124267578, 13.16543960571289],
    },
    "Mannheim": {
        "lat_range": [49.405303955078125, 49.594383239746094],
        "lon_range": [8.404372215270996, 8.599868774414062],
    },
    "Munich": {
        "lat_range": [48.05363082885742, 48.25450134277344],
        "lon_range": [11.35603141784668, 11.734712600708008],
    },
    "Nantes": {
        "lat_range": [47.09950256347656, 47.33213424682617],
        "lon_range": [-1.702157974243164, -1.4110151529312134],
    },
    "Naples": {
        "lat_range": [40.63092041015625, 41.05332946777344],
        "lon_range": [13.993684768676758, 14.742915153503418],
    },
    "Nuremberg": {
        "lat_range": [49.3282470703125, 49.54488754272461],
        "lon_range": [10.978351593017578, 11.289997100830078],
    },
    "Oslo": {
        "lat_range": [59.804927825927734, 60.13806915283203],
        "lon_range": [10.482114791870117, 10.966914176940918],
    },
    "Paris": {
        "lat_range": [48.502445220947266, 49.151649475097656],
        "lon_range": [1.8323332071304321, 2.881556987762451],
    },
    "Rotterdam": {
        "lat_range": [51.68125915527344, 52.04006576538086],
        "lon_range": [3.951533079147339, 4.899263858795166],
    },
    "Ruhr": {
        "lat_range": [51.34428024291992, 51.54142761230469],
        "lon_range": [6.887744426727295, 7.1481242179870605],
    },
    "Stockholm": {
        "lat_range": [58.81275939941406, 59.5318717956543],
        "lon_range": [17.604873657226562, 18.71013069152832],
    },
    "Thessaloniki": {
        "lat_range": [40.5311164855957, 40.73189163208008],
        "lon_range": [22.831668853759766, 23.0572452545166],
    },
    "Toulouse": {
        "lat_range": [43.49565124511719, 43.72552490234375],
        "lon_range": [1.2111377716064453, 1.551960825920105],
    },
    "Utrecht": {
        "lat_range": [51.984107971191406, 52.153053283691406],
        "lon_range": [4.957651615142822, 5.211655139923096],
    },
    "Vienna": {
        "lat_range": [48.10041809082031, 48.33709716796875],
        "lon_range": [16.165645599365234, 16.60494041442871],
    },
    "Warsaw": {
        "lat_range": [52.073333740234375, 52.38652420043945],
        "lon_range": [20.82090187072754, 21.320478439331055],
    },
    "Wrocław": {
        "lat_range": [51.029300689697266, 51.21991729736328],
        "lon_range": [16.787124633789062, 17.19321632385254],
    },
    "Łódź": {
        "lat_range": [51.66504669189453, 51.87682342529297],
        "lon_range": [19.29356575012207, 19.666975021362305],
    },
}


REGION_DEFS = {**_AEROCOM_DEFS, **_HTAP_DEFS, **_OTHER_REG_DEFS, **_EU_CITIES}

# optional: alternative names for regions (e.g. used for plotting)
# if undefined the corresponding ID is used as name. Names are adapetd from
# https://publications.jrc.ec.europa.eu/repository/bitstream/JRC102552/lbna28255enn.pdf
# (Fig. 3, P11)
_HTAP_NAMES = {
    "NAM": "N America",
    "EUR": "Europe",
    "EEUROPE": "E Europe",
    "RBU": "Rus,Bel,Ukr",
    "MDE": "Middle East",
    "EAS": "E Asia",
    "SAS": "S Asia",
    "SEA": "SE Asia",
    "NAF": "N Africa",
    "MCA": "C America",
    "SAF": "S Africa",
    "SAM": "S America",
    "PAN": "Pacific,Aust,NZ",
    "OCN": "Oceans",
}


REGION_NAMES = {**_HTAP_NAMES}

OLD_AEROCOM_REGIONS = list(_AEROCOM_DEFS)
HTAP_REGIONS_DEFAULT = list(_HTAP_NAMES)
HTAP_REGIONS = list(_HTAP_DEFS)
OTHER_REGIONS = list(_OTHER_REG_DEFS)

EU_CITIES_REGIONS = list(_EU_CITIES)
