CFG = {
    "model_cfg": {
        "EMEP": {
            "model_id": "CAMS2-83.EMEP.day0.FC",
            "model_data_dir": "/lustre/storeB/project/fou/kl/CAMS2_83/model",
            "gridded_reader_id": {"model": "ReadCAMS2_83"},
            "model_kwargs": {"daterange": ["2025-03-01", "2025-03-01"]},
        }
    },
    "obs_cfg": {
        "EEA": {
            "obs_id": "CAMS2_83.NRT",
            "obs_vars": ["concno2", "concco", "conco3", "concso2", "concpm10", "concpm25"],
            "web_interface_name": "EEA-UTD",
            "obs_vert_type": "Surface",
            "read_opts_ungridded": {
                "files": [
                    "/lustre/storeB/project/fou/kl/CAMS2_83/obs/202502/obsmacc4verif_20250228.csv",
                    "/lustre/storeB/project/fou/kl/CAMS2_83/obs/202503/obsmacc4verif_20250301.csv",
                ],
                "force_caching": True,
            },
            "obs_filters": {
                "concno2": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": ["NO0042*"],
                    "negate": "station_id",
                },
                "concco": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": ["BETN*"],
                    "negate": "station_id",
                },
                "conco3": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": ["NO0042*"],
                    "negate": "station_id",
                },
                "concso2": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": "GR0001*",
                    "negate": "station_id",
                },
                "concpm10": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": ["NO0042*"],
                    "negate": "station_id",
                },
                "concpm25": {
                    "latitude": [30, 82],
                    "longitude": [-30, 90],
                    "station_id": ["NO0042*"],
                    "negate": "station_id",
                },
            },
        }
    },
    "proj_id": "cams2-83",
    "exp_id": "test",
    "exp_name": "Test",
    "exp_descr": "Evaluation using EEA-MF NRT obs.",
    "exp_pi": "<a href='https://atmosphere.copernicus.eu/help-and-support'>CAMS user support</a>",
    "public": True,
    "json_basedir": None,
    "coldata_basedir": None,
    "reanalyse_existing": True,
    "only_json": False,
    "only_colocation": True,
    "add_model_maps": False,
    "only_model_maps": False,
    "clear_existing_json": False,
    "raise_exceptions": False,
    "use_cams2_83": True,
    "filter_name": "ALL-wMOUNTAINS",
    "ts_type": "hourly",
    "map_zoom": "Europe",
    "freqs": ["hourly", "daily"],
    "periods": ["20250301-20250301"],
    "main_freq": "hourly",
    "add_seasons": False,
    "use_meteorological_seasons": True,
    "use_diurnal": False,
    "resample_how": {"vmro3": {"daily": {"hourly": "max"}}},
    "zeros_to_nan": True,
    "colocate_time": False,
    "obs_remove_outliers": False,
    "model_remove_outliers": False,
    "harmonise_units": True,
    "regions_how": "country",
    "annual_stats_constrained": False,
    "weighted_stats": False,
    "forecast_evaluation": True,
    "forecast_days": 1,
    "use_fairmode": False,
    "use_cams2_83_fairmode": True,
    "drop_stats": ("mb", "mab"),
    "var_order_menu": [
        "conco3",
        "conco3mda8",
        "concno2",
        "concpm10",
        "concpm25",
        "concso2",
        "concco",
    ],
    "min_num_obs": {"daily": {"hourly": 18}},
}
