"""Default data definitions for BibTeX standardization.

This module contains default field lists and format flags used throughout
the BibTeX standardization process. These definitions help ensure consistent
field recognition and validation across different BibTeX entry types.

Constants:
    FIELD_FORMAT_FLAG: Regular expression patterns for identifying field
        value delimiters (quotes, braces, and word characters).
    DEFAULT_FIELDS_LIST: Comprehensive list of standard BibTeX field names
        that are recognized and processed during standardization.
"""

FIELD_FORMAT_FLAG = [r'"', r"{", r"\w"]

DEFAULT_FIELDS_LIST = [
    "abstract",
    "accepted",
    "accessdate",
    "address",
    "affiliation",
    "affiliations",
    "annotation",
    "archive",
    "article-number",
    "articleno",
    "audio",
    "author",
    "author-email",
    "authors",
    "bibsource",
    "biburl",
    "book-group-author",
    "booktitle",
    "cited-references",
    "code",
    "copyright",
    "crossref",
    "data",
    "date",
    "doc-delivery-number",
    "doi",
    "edition",
    "editor",
    "editors",
    "eissn",
    "eprint",
    "extra",
    "fjournal",
    "funding-acknowledgement",
    "funding-text",
    "howpublished",
    "institution",
    "isbn",
    "isbn-13",
    "issn",
    "issue",
    "issue_date",
    "journal",
    "journal-iso",
    "journalabbr",
    "journalabbreviation",
    "key",
    "keywords",
    "keywords-plus",
    "language",
    "lccn",
    "location",
    "month",
    "note",
    "number",
    "number-of-cited-references",
    "numpages",
    "orcid-numbers",
    "organization",
    "pages",
    "pdf",
    "place",
    "pubdates",
    "publisher",
    "remark",
    "research-areas",
    "researcherid-numbers",
    "rights",
    "school",
    "series",
    "shortjournal",
    "shorttitle",
    "slide",
    "submitted",
    "summary",
    "supplementary",
    "times-cited",
    "timestamp",
    "title",
    "type",
    "unique-id",
    "url",
    "usage-count-last-180-days",
    "usage-count-since-2013",
    "video",
    "volume",
    "web-of-science-categories",
    "web-of-science-index",
    "xxeditor",
    "xxnote",
    "xxtitle",
    "xxyear",
    "year",
]
