# Generated by Django 5.1 on 2024-08-15 23:56

from django.db import migrations
from django.db.migrations import RunPython

from clinicedc_constants import FEEDBACK, PENDING


def update_status(apps, schema_editor):
    for model_cls in apps.get_models():
        if getattr(model_cls, "status", None):
            print(
                f"Updated `{model_cls._meta.label_lower}.status` from `{FEEDBACK}` "
                f"to `{PENDING}`."
            )
            model_cls.objects.filter(status=FEEDBACK).update(status=PENDING)


class Migration(migrations.Migration):
    dependencies = [
        ("edc_qareports", "0016_alter_note_options_alter_qareportlog_options"),
    ]

    operations = [RunPython(update_status)]
