# Generated by Django 4.2.5 on 2023-09-12 15:16

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import edc_metadata.metadata_helper.metadata_helper_mixin
import edc_metadata.model_mixins.creates.creates_metadata_model_mixin
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_sites.models
import edc_visit_tracking.managers
import django.utils.timezone


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("edc_appointment", "0042_alter_appointment_device_created_and_more"),
        ("sites", "0002_alter_domain_unique"),
        ("edc_visit_tracking", "0003_auto_20220913_2139"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide the reason for the unscheduled visit",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                            ("N/A", "Not applicable (if missed)"),
                        ],
                        default="alive",
                        help_text="If YES, submit Death report",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        help_text="Will be validated on the Death report",
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "document_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag as incomplete",
                        max_length=25,
                        verbose_name="Document status",
                    ),
                ),
                (
                    "document_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this document",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit/contact"),
                            ("unscheduled", "Unscheduled visit/contact"),
                            ("missed", "Missed visit"),
                            (
                                "lost",
                                "Lost to follow-up (use only when taking subject off study)",
                            ),
                            ("deferred", "Deferred"),
                            ("completed protocol", "Completed protocol"),
                        ],
                        max_length=25,
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("timepoint", "Missed timepoint"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("participant", "1. Clinic visit with participant"),
                            ("other_contact", "2. Other contact with participant"),
                            (
                                "other_doctor",
                                "3. Contact with external health care provider/medical doctor",
                            ),
                            (
                                "family",
                                "4. Contact with family or designated person who can provide information",
                            ),
                            ("chart", "5. Hospital chart or other medical record"),
                            ("OTHER", "9. Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "appointment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="default_subjectvisit",
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            bases=(
                edc_metadata.metadata_helper.metadata_helper_mixin.MetadataHelperMixin,
                edc_metadata.model_mixins.creates.creates_metadata_model_mixin.RelatedVisitProtocol,
                models.Model,
            ),
            managers=[
                ("objects", edc_visit_tracking.managers.VisitModelManager()),
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name="subjectvisitmissedreasons",
            name="extra_value",
            field=models.CharField(max_length=250, null=True),
        ),
        migrations.AddField(
            model_name="visitreasons",
            name="extra_value",
            field=models.CharField(max_length=250, null=True),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders. Multiple attempts on the same day count as a single attempt.",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_visit_tracking.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Missed Visit Report",
                "verbose_name_plural": "historical Missed Visit Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide the reason for the unscheduled visit",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                            ("N/A", "Not applicable (if missed)"),
                        ],
                        default="alive",
                        help_text="If YES, submit Death report",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        help_text="Will be validated on the Death report",
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "document_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag as incomplete",
                        max_length=25,
                        verbose_name="Document status",
                    ),
                ),
                (
                    "document_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this document",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit/contact"),
                            ("unscheduled", "Unscheduled visit/contact"),
                            ("missed", "Missed visit"),
                            (
                                "lost",
                                "Lost to follow-up (use only when taking subject off study)",
                            ),
                            ("deferred", "Deferred"),
                            ("completed protocol", "Completed protocol"),
                        ],
                        max_length=25,
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("timepoint", "Missed timepoint"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("participant", "1. Clinic visit with participant"),
                            ("other_contact", "2. Other contact with participant"),
                            (
                                "other_doctor",
                                "3. Contact with external health care provider/medical doctor",
                            ),
                            (
                                "family",
                                "4. Contact with family or designated person who can provide information",
                            ),
                            ("chart", "5. Hospital chart or other medical record"),
                            ("OTHER", "9. Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "appointment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject visit",
                "verbose_name_plural": "historical subject visits",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="SubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders. Multiple attempts on the same day count as a single attempt.",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "missed_reasons",
                    models.ManyToManyField(
                        blank=True,
                        related_name="default_missed_reasons",
                        to="edc_visit_tracking.subjectvisitmissedreasons",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="edc_subject_visit",
                        to="edc_visit_tracking.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Missed Visit Report",
                "verbose_name_plural": "Missed Visit Report",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="edc_visit_t_subject_8fc4e6_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="edc_visit_t_subject_36f1fc_idx",
                    ),
                ],
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="subjectvisit",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ],
                name="edc_visit_t_subject_413eb1_idx",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="subjectvisit",
            unique_together={
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                ),
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "report_datetime",
                ),
            },
        ),
    ]
