import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @stability stable
 */
export interface AliasTargetInstanceProps extends BaseInstanceProps {
    /**
     * DNS name of the target.
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * The Cloudmap service this resource is registered to.
     *
     * @stability stable
     */
    readonly service: IService;
}
/**
 * Instance that uses Route 53 Alias record type.
 *
 * Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @stability stable
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class AliasTargetInstance extends InstanceBase {
    /**
     * The Id of the instance.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * The Cloudmap service to which the instance is registered.
     *
     * @stability stable
     */
    readonly service: IService;
    /**
     * The Route53 DNS name of the alias target.
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: AliasTargetInstanceProps);
}
