import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @stability stable
 */
export interface IpInstanceBaseProps extends BaseInstanceProps {
    /**
     * The port on the endpoint that you want AWS Cloud Map to perform health checks on.
     *
     * This value is also used for
     * the port value in an SRV record if the service that you specify includes an SRV record. You can also specify a
     * default port that is applied to all instances in the Service configuration.
     *
     * @default 80
     * @stability stable
     */
    readonly port?: number;
    /**
     * If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record.
     *
     * @default none
     * @stability stable
     */
    readonly ipv4?: string;
    /**
     * If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record.
     *
     * @default none
     * @stability stable
     */
    readonly ipv6?: string;
}
/**
 * @stability stable
 */
export interface IpInstanceProps extends IpInstanceBaseProps {
    /**
     * The Cloudmap service this resource is registered to.
     *
     * @stability stable
     */
    readonly service: IService;
}
/**
 * Instance that is accessible using an IP address.
 *
 * @stability stable
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class IpInstance extends InstanceBase {
    /**
     * The Id of the instance.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * The Cloudmap service to which the instance is registered.
     *
     * @stability stable
     */
    readonly service: IService;
    /**
     * The Ipv4 address of the instance, or blank string if none available.
     *
     * @stability stable
     */
    readonly ipv4: string;
    /**
     * The Ipv6 address of the instance, or blank string if none available.
     *
     * @stability stable
     */
    readonly ipv6: string;
    /**
     * The exposed port of the instance.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: IpInstanceProps);
}
