"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const instance_1 = require("./instance");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using an IP address.
 *
 * @stability stable
 * @resource AWS::ServiceDiscovery::Instance
 */
class IpInstance extends instance_1.InstanceBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType === service_1.DnsRecordType.CNAME) {
            throw new Error('Service must support `A`, `AAAA` or `SRV` records to register this instance type.');
        }
        if (dnsRecordType === service_1.DnsRecordType.SRV) {
            if (!props.port) {
                throw new Error('A `port` must be specified for a service using a `SRV` record.');
            }
            if (!props.ipv4 && !props.ipv6) {
                throw new Error('At least `ipv4` or `ipv6` must be specified for a service using a `SRV` record.');
            }
        }
        if (!props.ipv4 && (dnsRecordType === service_1.DnsRecordType.A || dnsRecordType === service_1.DnsRecordType.A_AAAA)) {
            throw new Error('An `ipv4` must be specified for a service using a `A` record.');
        }
        if (!props.ipv6 &&
            (dnsRecordType === service_1.DnsRecordType.AAAA || dnsRecordType === service_1.DnsRecordType.A_AAAA)) {
            throw new Error('An `ipv6` must be specified for a service using a `AAAA` record.');
        }
        const port = props.port || 80;
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_INSTANCE_IPV4: props.ipv4,
                AWS_INSTANCE_IPV6: props.ipv6,
                AWS_INSTANCE_PORT: port.toString(),
                ...props.customAttributes,
            },
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.ipv4 = props.ipv4 || '';
        this.ipv6 = props.ipv6 || '';
        this.port = port;
    }
}
exports.IpInstance = IpInstance;
_a = JSII_RTTI_SYMBOL_1;
IpInstance[_a] = { fqn: "@aws-cdk/aws-servicediscovery.IpInstance", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaXAtaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpcC1pbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHlDQUE2RDtBQUM3RCx1Q0FBb0Q7QUFDcEQsNkVBQTJEOzs7Ozs7O0FBcUIzRCxNQUFhLFVBQVcsU0FBUSx1QkFBWTs7OztJQWdCMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDO1FBRWxELElBQUksYUFBYSxLQUFLLHVCQUFhLENBQUMsS0FBSyxFQUFFO1lBQ3pDLE1BQU0sSUFBSSxLQUFLLENBQUMsbUZBQW1GLENBQUMsQ0FBQztTQUN0RztRQUNELElBQUksYUFBYSxLQUFLLHVCQUFhLENBQUMsR0FBRyxFQUFFO1lBQ3ZDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFO2dCQUNmLE1BQU0sSUFBSSxLQUFLLENBQUMsZ0VBQWdFLENBQUMsQ0FBQzthQUNuRjtZQUVELElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRTtnQkFDOUIsTUFBTSxJQUFJLEtBQUssQ0FBQyxpRkFBaUYsQ0FBQyxDQUFDO2FBQ3BHO1NBQ0Y7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDLGFBQWEsS0FBSyx1QkFBYSxDQUFDLENBQUMsSUFBSSxhQUFhLEtBQUssdUJBQWEsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUNoRyxNQUFNLElBQUksS0FBSyxDQUFDLCtEQUErRCxDQUFDLENBQUM7U0FDbEY7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUk7WUFDYixDQUFDLGFBQWEsS0FBSyx1QkFBYSxDQUFDLElBQUksSUFBSSxhQUFhLEtBQUssdUJBQWEsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUNsRixNQUFNLElBQUksS0FBSyxDQUFDLGtFQUFrRSxDQUFDLENBQUM7U0FDckY7UUFFRCxNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUU5QixNQUFNLFFBQVEsR0FBRyxJQUFJLHdDQUFXLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNqRCxrQkFBa0IsRUFBRTtnQkFDbEIsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLElBQUk7Z0JBQzdCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxJQUFJO2dCQUM3QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsUUFBUSxFQUFFO2dCQUNsQyxHQUFHLEtBQUssQ0FBQyxnQkFBZ0I7YUFDMUI7WUFDRCxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7WUFDdkQsU0FBUyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUztTQUNuQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1FBQy9CLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUM7UUFDN0IsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDOztBQTVESCxnQ0E2REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEJhc2VJbnN0YW5jZVByb3BzLCBJbnN0YW5jZUJhc2UgfSBmcm9tICcuL2luc3RhbmNlJztcbmltcG9ydCB7IERuc1JlY29yZFR5cGUsIElTZXJ2aWNlIH0gZnJvbSAnLi9zZXJ2aWNlJztcbmltcG9ydCB7IENmbkluc3RhbmNlIH0gZnJvbSAnLi9zZXJ2aWNlZGlzY292ZXJ5LmdlbmVyYXRlZCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSXBJbnN0YW5jZUJhc2VQcm9wcyBleHRlbmRzIEJhc2VJbnN0YW5jZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGlwdjQ/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaXB2Nj86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSXBJbnN0YW5jZVByb3BzIGV4dGVuZHMgSXBJbnN0YW5jZUJhc2VQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VydmljZTogSVNlcnZpY2U7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSXBJbnN0YW5jZSBleHRlbmRzIEluc3RhbmNlQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGluc3RhbmNlSWQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHNlcnZpY2U6IElTZXJ2aWNlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGlwdjQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpcHY2OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSXBJbnN0YW5jZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBkbnNSZWNvcmRUeXBlID0gcHJvcHMuc2VydmljZS5kbnNSZWNvcmRUeXBlO1xuXG4gICAgaWYgKGRuc1JlY29yZFR5cGUgPT09IERuc1JlY29yZFR5cGUuQ05BTUUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2VydmljZSBtdXN0IHN1cHBvcnQgYEFgLCBgQUFBQWAgb3IgYFNSVmAgcmVjb3JkcyB0byByZWdpc3RlciB0aGlzIGluc3RhbmNlIHR5cGUuJyk7XG4gICAgfVxuICAgIGlmIChkbnNSZWNvcmRUeXBlID09PSBEbnNSZWNvcmRUeXBlLlNSVikge1xuICAgICAgaWYgKCFwcm9wcy5wb3J0KSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignQSBgcG9ydGAgbXVzdCBiZSBzcGVjaWZpZWQgZm9yIGEgc2VydmljZSB1c2luZyBhIGBTUlZgIHJlY29yZC4nKTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFwcm9wcy5pcHY0ICYmICFwcm9wcy5pcHY2KSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignQXQgbGVhc3QgYGlwdjRgIG9yIGBpcHY2YCBtdXN0IGJlIHNwZWNpZmllZCBmb3IgYSBzZXJ2aWNlIHVzaW5nIGEgYFNSVmAgcmVjb3JkLicpO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmICghcHJvcHMuaXB2NCAmJiAoZG5zUmVjb3JkVHlwZSA9PT0gRG5zUmVjb3JkVHlwZS5BIHx8IGRuc1JlY29yZFR5cGUgPT09IERuc1JlY29yZFR5cGUuQV9BQUFBKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdBbiBgaXB2NGAgbXVzdCBiZSBzcGVjaWZpZWQgZm9yIGEgc2VydmljZSB1c2luZyBhIGBBYCByZWNvcmQuJyk7XG4gICAgfVxuXG4gICAgaWYgKCFwcm9wcy5pcHY2ICYmXG4gICAgICAoZG5zUmVjb3JkVHlwZSA9PT0gRG5zUmVjb3JkVHlwZS5BQUFBIHx8IGRuc1JlY29yZFR5cGUgPT09IERuc1JlY29yZFR5cGUuQV9BQUFBKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdBbiBgaXB2NmAgbXVzdCBiZSBzcGVjaWZpZWQgZm9yIGEgc2VydmljZSB1c2luZyBhIGBBQUFBYCByZWNvcmQuJyk7XG4gICAgfVxuXG4gICAgY29uc3QgcG9ydCA9IHByb3BzLnBvcnQgfHwgODA7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5JbnN0YW5jZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBpbnN0YW5jZUF0dHJpYnV0ZXM6IHtcbiAgICAgICAgQVdTX0lOU1RBTkNFX0lQVjQ6IHByb3BzLmlwdjQsXG4gICAgICAgIEFXU19JTlNUQU5DRV9JUFY2OiBwcm9wcy5pcHY2LFxuICAgICAgICBBV1NfSU5TVEFOQ0VfUE9SVDogcG9ydC50b1N0cmluZygpLFxuICAgICAgICAuLi5wcm9wcy5jdXN0b21BdHRyaWJ1dGVzLFxuICAgICAgfSxcbiAgICAgIGluc3RhbmNlSWQ6IHByb3BzLmluc3RhbmNlSWQgfHwgdGhpcy51bmlxdWVJbnN0YW5jZUlkKCksXG4gICAgICBzZXJ2aWNlSWQ6IHByb3BzLnNlcnZpY2Uuc2VydmljZUlkLFxuICAgIH0pO1xuXG4gICAgdGhpcy5zZXJ2aWNlID0gcHJvcHMuc2VydmljZTtcbiAgICB0aGlzLmluc3RhbmNlSWQgPSByZXNvdXJjZS5yZWY7XG4gICAgdGhpcy5pcHY0ID0gcHJvcHMuaXB2NCB8fCAnJztcbiAgICB0aGlzLmlwdjYgPSBwcm9wcy5pcHY2IHx8ICcnO1xuICAgIHRoaXMucG9ydCA9IHBvcnQ7XG4gIH1cbn1cbiJdfQ==