"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateDnsNamespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Service Discovery HTTP Namespace.
 *
 * @stability stable
 */
class PrivateDnsNamespace extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.vpc === undefined) {
            throw new Error('VPC must be specified for PrivateDNSNamespaces');
        }
        const ns = new servicediscovery_generated_1.CfnPrivateDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
            vpc: props.vpc.vpcId,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PRIVATE;
    }
    /**
     * @stability stable
     */
    static fromPrivateDnsNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PRIVATE;
            }
        }
        return new Import(scope, id);
    }
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceArn() { return this.namespaceArn; }
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceName() { return this.namespaceName; }
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PrivateDnsNamespace = PrivateDnsNamespace;
_a = JSII_RTTI_SYMBOL_1;
PrivateDnsNamespace[_a] = { fqn: "@aws-cdk/aws-servicediscovery.PrivateDnsNamespace", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,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