import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { DnsServiceProps, Service } from './service';
/**
 * @stability stable
 */
export interface PublicDnsNamespaceProps extends BaseNamespaceProps {
}
/**
 * @stability stable
 */
export interface IPublicDnsNamespace extends INamespace {
}
/**
 * @stability stable
 */
export interface PublicDnsNamespaceAttributes {
    /**
     * A name for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace ARN for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
}
/**
 * Define a Public DNS Namespace.
 *
 * @stability stable
 */
export declare class PublicDnsNamespace extends Resource implements IPublicDnsNamespace {
    /**
     * @stability stable
     */
    static fromPublicDnsNamespaceAttributes(scope: Construct, id: string, attrs: PublicDnsNamespaceAttributes): IPublicDnsNamespace;
    /**
     * A name for the namespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the namespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace Arn for the namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
    /**
     * Type of the namespace.
     *
     * @stability stable
     */
    readonly type: NamespaceType;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: PublicDnsNamespaceProps);
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceArn(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceName(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceId(): string;
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id: string, props?: DnsServiceProps): Service;
}
