# Generated by Django 5.1.6 on 2025-08-16 09:02

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("drfchelseru", "0006_alter_chatroom_user_1_alter_chatroom_user_2_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name="chatroom",
            name="pinned_for",
            field=models.ManyToManyField(
                blank=True,
                related_name="pinned_drf_chelseru",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="chatroom",
            name="status",
            field=models.IntegerField(
                default=1, verbose_name=[(1, "Open"), (2, "Close")]
            ),
        ),
        migrations.AddField(
            model_name="chatroom",
            name="users",
            field=models.ManyToManyField(
                blank=True,
                related_name="users_drf_chelseru",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="messagechat",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, default=django.utils.timezone.now
            ),
            preserve_default=False,
        ),
        migrations.CreateModel(
            name="ChatRoomPermissions",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "access",
                    models.IntegerField(
                        choices=[
                            (0, "Read Only"),
                            (1, "Member"),
                            (2, "Can Add Members"),
                            (3, "Can Kick Members"),
                            (4, "Can Ban Members"),
                            (5, "Can Add Access"),
                            (6, "Can Remove Accessa"),
                            (7, "Can Kick Admins"),
                            (8, "Can Close Chat Room"),
                            (9, "Can ReOpen Chat Room"),
                            (10, "Can Rename Chat Room"),
                            (11, "Can Update Chatroom Avatar"),
                            (12, "Can Delete Chat Room"),
                        ],
                        default=1,
                    ),
                ),
                ("user", models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name="chatroom",
            name="permissions",
            field=models.ManyToManyField(
                blank=True,
                related_name="permissions_drf_chelseru",
                to="drfchelseru.chatroompermissions",
            ),
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=45)),
                ("uname", models.CharField(max_length=45, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "owner",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="organization_drf_chelseru",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="chatroom",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="chatroom_drf_chelseru",
                to="drfchelseru.organization",
            ),
        ),
    ]
