<!-- markdownlint-disable -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-20-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
<!-- markdownlint-restore -->

# Render Engine

[![PyTest](https://github.com/kjaymiller/render_engine/actions/workflows/test.yml/badge.svg)](https://github.com/kjaymiller/render_engine/actions/workflows/test.yml)
[![Discord](https://img.shields.io/discord/1174377880118104156?label=Discord&color=purple)](https://discord.gg/2xMQ4j4d8m)

## Learn More

- [Check out the Documentation](https://render-engine.readthedocs.io/en/latest/)
- [Contributors and Builders, Check out the Wiki](https://github.com/render-engine/render-engine/wiki)
- [Join the community!](https://discord.gg/2xMQ4j4d8m)

## What is RenderEngine

## The _3 layer_ Architecture

- **[Page](https://render-engine.readthedocs.io/en/latest/page/)** - A single webpage item built from content, a template, raw data, or a combination of those things.
- **[Collection](https://render-engine.readthedocs.io/en/latest/collection/)** - A group of webpages built from the same template, organized in a single directory
- **[Site](https://render-engine.readthedocs.io/en/latest/site/)** - The container that helps to render all Pages and Collections with uniform settings and variables

## Installing Render Engine

To use the render engine, you must have Python 3.10 or greater installed. You can download Python from [python.org](https://python.org).

- Linux/MacOS: [python.org](https://python.org)
- Windows: [Microsoft Store](https://apps.microsoft.com/store/detail/python-311/9NRWMJP3717K)

Render Engine is available in PyPI and can be installed using pip:

```bash
pip install render-engine
```

To use the cli, install the cli extras

```bash
pip install render-engine[cli]
```

## Getting Started

Check out the [Getting Started](https://render-engine.readthedocs.io/en/latest/page/) Section in the [Documentation](https://render-engine.readthedocs.io)

## Finding Awesome Add-Ons

We've compiled a set of [awesome add-ons](https://github.com/render-engine/render-engine-awesome-list) that you can use to make your site even better!

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Tashuuuu"><img src="https://avatars.githubusercontent.com/u/85075827?v=4?s=57" width="57px;" alt="Akriti Sengar"/><br /><sub><b>Akriti Sengar</b></sub></a><br /><a href="#tool-Tashuuuu" title="Tools">🔧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://tonybaloney.github.io/"><img src="https://avatars.githubusercontent.com/u/1532417?v=4?s=57" width="57px;" alt="Anthony Shaw"/><br /><sub><b>Anthony Shaw</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=tonybaloney" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://b.dougie.dev/"><img src="https://avatars.githubusercontent.com/u/5713670?v=4?s=57" width="57px;" alt="Brian Douglas"/><br /><sub><b>Brian Douglas</b></sub></a><br /><a href="#financial-bdougie" title="Financial">💵</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://brassnet.biz"><img src="https://avatars.githubusercontent.com/u/1806946?v=4?s=57" width="57px;" alt="Dan Shernicoff"/><br /><sub><b>Dan Shernicoff</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=brass75" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mannyanebi"><img src="https://avatars.githubusercontent.com/u/25439000?v=4?s=57" width="57px;" alt="Emmanuel Anebi"/><br /><sub><b>Emmanuel Anebi</b></sub></a><br /><a href="#plugin-mannyanebi" title="Plugin/utility libraries">🔌</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://giovannimartins.dev"><img src="https://avatars.githubusercontent.com/u/7796661?v=4?s=57" width="57px;" alt="Giovanni Martins"/><br /><sub><b>Giovanni Martins</b></sub></a><br /><a href="#infra-giovannism20" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kjaymiller"><img src="https://avatars.githubusercontent.com/u/8632637?v=4?s=57" width="57px;" alt="Jay Miller"/><br /><sub><b>Jay Miller</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=kjaymiller" title="Code">💻</a> <a href="https://github.com/render-engine/render-engine/commits?author=kjaymiller" title="Documentation">📖</a> <a href="#maintenance-kjaymiller" title="Maintenance">🚧</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://webology.dev"><img src="https://avatars.githubusercontent.com/u/50527?v=4?s=57" width="57px;" alt="Jeff Triplett"/><br /><sub><b>Jeff Triplett</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=jefftriplett" title="Documentation">📖</a> <a href="#mentoring-jefftriplett" title="Mentoring">🧑‍🏫</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://linktr.ee/john0isaac"><img src="https://avatars.githubusercontent.com/u/64026625?v=4?s=57" width="57px;" alt="John Aziz"/><br /><sub><b>John Aziz</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=john0isaac" title="Documentation">📖</a> <a href="#maintenance-john0isaac" title="Maintenance">🚧</a> <a href="#userTesting-john0isaac" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.jonafato.com"><img src="https://avatars.githubusercontent.com/u/392720?v=4?s=57" width="57px;" alt="Jon Banafato"/><br /><sub><b>Jon Banafato</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=jonafato" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jlgimeno"><img src="https://avatars.githubusercontent.com/u/17421585?v=4?s=57" width="57px;" alt="Jorge L. Gimeno"/><br /><sub><b>Jorge L. Gimeno</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=jlgimeno" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://lauralangdon.io"><img src="https://avatars.githubusercontent.com/u/48335772?v=4?s=57" width="57px;" alt="Laura Langdon"/><br /><sub><b>Laura Langdon</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=LauraLangdon" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Mahhheshh"><img src="https://avatars.githubusercontent.com/u/100200105?v=4?s=57" width="57px;" alt="Mahhheshh"/><br /><sub><b>Mahhheshh</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=Mahhheshh" title="Documentation">📖</a> <a href="https://github.com/render-engine/render-engine/commits?author=Mahhheshh" title="Code">💻</a> <a href="#maintenance-Mahhheshh" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.pythonbynight.com"><img src="https://avatars.githubusercontent.com/u/46942991?v=4?s=57" width="57px;" alt="Mario Munoz"/><br /><sub><b>Mario Munoz</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=tataraba" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MohitKambli"><img src="https://avatars.githubusercontent.com/u/31406633?v=4?s=57" width="57px;" alt="Mohit Kambli"/><br /><sub><b>Mohit Kambli</b></sub></a><br /><a href="#infra-MohitKambli" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/OsamaRab3"><img src="https://avatars.githubusercontent.com/u/159753803?v=4?s=57" width="57px;" alt="Osama Rabea "/><br /><sub><b>Osama Rabea </b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=OsamaRab3" title="Documentation">📖</a> <a href="https://github.com/render-engine/render-engine/commits?author=OsamaRab3" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.pamelafox.org"><img src="https://avatars.githubusercontent.com/u/297042?v=4?s=57" width="57px;" alt="Pamela Fox"/><br /><sub><b>Pamela Fox</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=pamelafox" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/viktoriussuwandi"><img src="https://avatars.githubusercontent.com/u/68414300?v=4?s=57" width="57px;" alt="Viktorius Suwandi"/><br /><sub><b>Viktorius Suwandi</b></sub></a><br /><a href="https://github.com/render-engine/render-engine/commits?author=viktoriussuwandi" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/VinayakG311"><img src="https://avatars.githubusercontent.com/u/96966973?v=4?s=57" width="57px;" alt="VinayakG311"/><br /><sub><b>VinayakG311</b></sub></a><br /><a href="#plugin-VinayakG311" title="Plugin/utility libraries">🔌</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Izaan17"><img src="https://avatars.githubusercontent.com/u/93177492?v=4?s=57" width="57px;" alt="izaan17"/><br /><sub><b>izaan17</b></sub></a><br /><a href="#plugin-izaan17" title="Plugin/utility libraries">🔌</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

### Sponsors at the $20/month and Higher Level

- [Brian Douglas](https://github.com/bdougie)

Thank you to them and all of those who continue to support this project!
