"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.execSync = void 0;
const child = require("child_process");
function execSync(command, options = {}) {
    try {
        child.execSync(command, { cwd: options.cwd, env: options.env });
    }
    catch (err) {
        const message = [`Command failed: ${command}`];
        if (err.stderr) {
            message.push('STDERR:');
            message.push('\n');
            message.push('\n');
            message.push(err.stderr.toString().trim());
        }
        if (err.stdout) {
            message.push('STDOUT:');
            message.push('\n');
            message.push('\n');
            message.push(err.stdout.toString().trim());
        }
        throw new Error(message.join('\n\n'));
    }
}
exports.execSync = execSync;
//# sourceMappingURL=data:application/json;base64,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